/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AttachedDiskInitializeParams;
import com.google.cloud.compute.v1.CustomerEncryptionKey;
import com.google.cloud.compute.v1.GuestOsFeature;
import com.google.cloud.compute.v1.InitialStateConfig;
import com.google.gson.annotations.SerializedName;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AttachedDisk
implements ApiMessage {
    private final Boolean autoDelete;
    private final Boolean boot;
    private final String deviceName;
    private final CustomerEncryptionKey diskEncryptionKey;
    private final String diskSizeGb;
    private final List<GuestOsFeature> guestOsFeatures;
    private final Integer index;
    private final AttachedDiskInitializeParams initializeParams;
    @SerializedName(value="interface")
    private final String interface2;
    private final String kind;
    private final List<String> licenses;
    private final String mode;
    private final InitialStateConfig shieldedInstanceInitialState;
    private final String source;
    private final String type;
    private static final AttachedDisk DEFAULT_INSTANCE = new AttachedDisk();

    private AttachedDisk() {
        this.autoDelete = null;
        this.boot = null;
        this.deviceName = null;
        this.diskEncryptionKey = null;
        this.diskSizeGb = null;
        this.guestOsFeatures = null;
        this.index = null;
        this.initializeParams = null;
        this.interface2 = null;
        this.kind = null;
        this.licenses = null;
        this.mode = null;
        this.shieldedInstanceInitialState = null;
        this.source = null;
        this.type = null;
    }

    private AttachedDisk(Boolean autoDelete, Boolean boot, String deviceName, CustomerEncryptionKey diskEncryptionKey, String diskSizeGb, List<GuestOsFeature> guestOsFeatures, Integer index, AttachedDiskInitializeParams initializeParams, String interface2, String kind, List<String> licenses, String mode, InitialStateConfig shieldedInstanceInitialState, String source, String type) {
        this.autoDelete = autoDelete;
        this.boot = boot;
        this.deviceName = deviceName;
        this.diskEncryptionKey = diskEncryptionKey;
        this.diskSizeGb = diskSizeGb;
        this.guestOsFeatures = guestOsFeatures;
        this.index = index;
        this.initializeParams = initializeParams;
        this.interface2 = interface2;
        this.kind = kind;
        this.licenses = licenses;
        this.mode = mode;
        this.shieldedInstanceInitialState = shieldedInstanceInitialState;
        this.source = source;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if ("autoDelete".equals(fieldName)) {
            return this.autoDelete;
        }
        if ("boot".equals(fieldName)) {
            return this.boot;
        }
        if ("deviceName".equals(fieldName)) {
            return this.deviceName;
        }
        if ("diskEncryptionKey".equals(fieldName)) {
            return this.diskEncryptionKey;
        }
        if ("diskSizeGb".equals(fieldName)) {
            return this.diskSizeGb;
        }
        if ("guestOsFeatures".equals(fieldName)) {
            return this.guestOsFeatures;
        }
        if ("index".equals(fieldName)) {
            return this.index;
        }
        if ("initializeParams".equals(fieldName)) {
            return this.initializeParams;
        }
        if ("interface2".equals(fieldName)) {
            return this.interface2;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("licenses".equals(fieldName)) {
            return this.licenses;
        }
        if ("mode".equals(fieldName)) {
            return this.mode;
        }
        if ("shieldedInstanceInitialState".equals(fieldName)) {
            return this.shieldedInstanceInitialState;
        }
        if ("source".equals(fieldName)) {
            return this.source;
        }
        if ("type".equals(fieldName)) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public Boolean getBoot() {
        return this.boot;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public CustomerEncryptionKey getDiskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    public String getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public List<GuestOsFeature> getGuestOsFeaturesList() {
        return this.guestOsFeatures;
    }

    public Integer getIndex() {
        return this.index;
    }

    public AttachedDiskInitializeParams getInitializeParams() {
        return this.initializeParams;
    }

    public String getInterface() {
        return this.interface2;
    }

    public String getKind() {
        return this.kind;
    }

    public List<String> getLicensesList() {
        return this.licenses;
    }

    public String getMode() {
        return this.mode;
    }

    public InitialStateConfig getShieldedInstanceInitialState() {
        return this.shieldedInstanceInitialState;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AttachedDisk prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AttachedDisk getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AttachedDisk{autoDelete=" + this.autoDelete + ", boot=" + this.boot + ", deviceName=" + this.deviceName + ", diskEncryptionKey=" + this.diskEncryptionKey + ", diskSizeGb=" + this.diskSizeGb + ", guestOsFeatures=" + this.guestOsFeatures + ", index=" + this.index + ", initializeParams=" + this.initializeParams + ", interface2=" + this.interface2 + ", kind=" + this.kind + ", licenses=" + this.licenses + ", mode=" + this.mode + ", shieldedInstanceInitialState=" + this.shieldedInstanceInitialState + ", source=" + this.source + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttachedDisk) {
            AttachedDisk that = (AttachedDisk)o;
            return Objects.equals(this.autoDelete, that.getAutoDelete()) && Objects.equals(this.boot, that.getBoot()) && Objects.equals(this.deviceName, that.getDeviceName()) && Objects.equals(this.diskEncryptionKey, that.getDiskEncryptionKey()) && Objects.equals(this.diskSizeGb, that.getDiskSizeGb()) && Objects.equals(this.guestOsFeatures, that.getGuestOsFeaturesList()) && Objects.equals(this.index, that.getIndex()) && Objects.equals(this.initializeParams, that.getInitializeParams()) && Objects.equals(this.interface2, that.getInterface()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.licenses, that.getLicensesList()) && Objects.equals(this.mode, that.getMode()) && Objects.equals(this.shieldedInstanceInitialState, that.getShieldedInstanceInitialState()) && Objects.equals(this.source, that.getSource()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoDelete, this.boot, this.deviceName, this.diskEncryptionKey, this.diskSizeGb, this.guestOsFeatures, this.index, this.initializeParams, this.interface2, this.kind, this.licenses, this.mode, this.shieldedInstanceInitialState, this.source, this.type);
    }

    public static class Builder {
        private Boolean autoDelete;
        private Boolean boot;
        private String deviceName;
        private CustomerEncryptionKey diskEncryptionKey;
        private String diskSizeGb;
        private List<GuestOsFeature> guestOsFeatures;
        private Integer index;
        private AttachedDiskInitializeParams initializeParams;
        private String interface2;
        private String kind;
        private List<String> licenses;
        private String mode;
        private InitialStateConfig shieldedInstanceInitialState;
        private String source;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(AttachedDisk other) {
            if (other == AttachedDisk.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoDelete() != null) {
                this.autoDelete = other.autoDelete;
            }
            if (other.getBoot() != null) {
                this.boot = other.boot;
            }
            if (other.getDeviceName() != null) {
                this.deviceName = other.deviceName;
            }
            if (other.getDiskEncryptionKey() != null) {
                this.diskEncryptionKey = other.diskEncryptionKey;
            }
            if (other.getDiskSizeGb() != null) {
                this.diskSizeGb = other.diskSizeGb;
            }
            if (other.getGuestOsFeaturesList() != null) {
                this.guestOsFeatures = other.guestOsFeatures;
            }
            if (other.getIndex() != null) {
                this.index = other.index;
            }
            if (other.getInitializeParams() != null) {
                this.initializeParams = other.initializeParams;
            }
            if (other.getInterface() != null) {
                this.interface2 = other.interface2;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLicensesList() != null) {
                this.licenses = other.licenses;
            }
            if (other.getMode() != null) {
                this.mode = other.mode;
            }
            if (other.getShieldedInstanceInitialState() != null) {
                this.shieldedInstanceInitialState = other.shieldedInstanceInitialState;
            }
            if (other.getSource() != null) {
                this.source = other.source;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(AttachedDisk source) {
            this.autoDelete = source.autoDelete;
            this.boot = source.boot;
            this.deviceName = source.deviceName;
            this.diskEncryptionKey = source.diskEncryptionKey;
            this.diskSizeGb = source.diskSizeGb;
            this.guestOsFeatures = source.guestOsFeatures;
            this.index = source.index;
            this.initializeParams = source.initializeParams;
            this.interface2 = source.interface2;
            this.kind = source.kind;
            this.licenses = source.licenses;
            this.mode = source.mode;
            this.shieldedInstanceInitialState = source.shieldedInstanceInitialState;
            this.source = source.source;
            this.type = source.type;
        }

        public Boolean getAutoDelete() {
            return this.autoDelete;
        }

        public Builder setAutoDelete(Boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public Boolean getBoot() {
            return this.boot;
        }

        public Builder setBoot(Boolean boot) {
            this.boot = boot;
            return this;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public Builder setDeviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public CustomerEncryptionKey getDiskEncryptionKey() {
            return this.diskEncryptionKey;
        }

        public Builder setDiskEncryptionKey(CustomerEncryptionKey diskEncryptionKey) {
            this.diskEncryptionKey = diskEncryptionKey;
            return this;
        }

        public String getDiskSizeGb() {
            return this.diskSizeGb;
        }

        public Builder setDiskSizeGb(String diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public List<GuestOsFeature> getGuestOsFeaturesList() {
            return this.guestOsFeatures;
        }

        public Builder addAllGuestOsFeatures(List<GuestOsFeature> guestOsFeatures) {
            if (this.guestOsFeatures == null) {
                this.guestOsFeatures = new LinkedList<GuestOsFeature>();
            }
            this.guestOsFeatures.addAll(guestOsFeatures);
            return this;
        }

        public Builder addGuestOsFeatures(GuestOsFeature guestOsFeatures) {
            if (this.guestOsFeatures == null) {
                this.guestOsFeatures = new LinkedList<GuestOsFeature>();
            }
            this.guestOsFeatures.add(guestOsFeatures);
            return this;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Builder setIndex(Integer index) {
            this.index = index;
            return this;
        }

        public AttachedDiskInitializeParams getInitializeParams() {
            return this.initializeParams;
        }

        public Builder setInitializeParams(AttachedDiskInitializeParams initializeParams) {
            this.initializeParams = initializeParams;
            return this;
        }

        public String getInterface() {
            return this.interface2;
        }

        public Builder setInterface(String interface2) {
            this.interface2 = interface2;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public List<String> getLicensesList() {
            return this.licenses;
        }

        public Builder addAllLicenses(List<String> licenses) {
            if (this.licenses == null) {
                this.licenses = new LinkedList<String>();
            }
            this.licenses.addAll(licenses);
            return this;
        }

        public Builder addLicenses(String licenses) {
            if (this.licenses == null) {
                this.licenses = new LinkedList<String>();
            }
            this.licenses.add(licenses);
            return this;
        }

        public String getMode() {
            return this.mode;
        }

        public Builder setMode(String mode) {
            this.mode = mode;
            return this;
        }

        public InitialStateConfig getShieldedInstanceInitialState() {
            return this.shieldedInstanceInitialState;
        }

        public Builder setShieldedInstanceInitialState(InitialStateConfig shieldedInstanceInitialState) {
            this.shieldedInstanceInitialState = shieldedInstanceInitialState;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public AttachedDisk build() {
            return new AttachedDisk(this.autoDelete, this.boot, this.deviceName, this.diskEncryptionKey, this.diskSizeGb, this.guestOsFeatures, this.index, this.initializeParams, this.interface2, this.kind, this.licenses, this.mode, this.shieldedInstanceInitialState, this.source, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoDelete(this.autoDelete);
            newBuilder.setBoot(this.boot);
            newBuilder.setDeviceName(this.deviceName);
            newBuilder.setDiskEncryptionKey(this.diskEncryptionKey);
            newBuilder.setDiskSizeGb(this.diskSizeGb);
            newBuilder.addAllGuestOsFeatures(this.guestOsFeatures);
            newBuilder.setIndex(this.index);
            newBuilder.setInitializeParams(this.initializeParams);
            newBuilder.setInterface(this.interface2);
            newBuilder.setKind(this.kind);
            newBuilder.addAllLicenses(this.licenses);
            newBuilder.setMode(this.mode);
            newBuilder.setShieldedInstanceInitialState(this.shieldedInstanceInitialState);
            newBuilder.setSource(this.source);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

