/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListRegionHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionHealthCheckName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionHealthCheckClient;
import com.google.cloud.compute.v1.UpdateRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionHealthCheckCallableFactory;
import com.google.cloud.compute.v1.stub.RegionHealthCheckStub;
import com.google.cloud.compute.v1.stub.RegionHealthCheckStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRegionHealthCheckStub
extends RegionHealthCheckStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionHealthChecks.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionHealthChecks.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HealthCheck.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionHealthChecks.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/healthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListRegionHealthChecksHttpRequest, HealthCheckList> listRegionHealthChecksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionHealthChecks.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/healthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HealthCheckList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionHealthChecks.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionHealthChecks.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/healthChecks/{healthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionHealthCheckName.newFactory()).setResourceNameField("healthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckCallable;
    private final UnaryCallable<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckCallable;
    private final UnaryCallable<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckCallable;
    private final UnaryCallable<ListRegionHealthChecksHttpRequest, HealthCheckList> listRegionHealthChecksCallable;
    private final UnaryCallable<ListRegionHealthChecksHttpRequest, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> listRegionHealthChecksPagedCallable;
    private final UnaryCallable<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckCallable;
    private final UnaryCallable<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionHealthCheckStub create(RegionHealthCheckStubSettings settings) throws IOException {
        return new HttpJsonRegionHealthCheckStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionHealthCheckStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionHealthCheckStub(RegionHealthCheckStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionHealthCheckStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionHealthCheckStub(RegionHealthCheckStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionHealthCheckStub(RegionHealthCheckStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionHealthCheckCallableFactory());
    }

    protected HttpJsonRegionHealthCheckStub(RegionHealthCheckStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteRegionHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRegionHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings getRegionHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRegionHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings insertRegionHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertRegionHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings listRegionHealthChecksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRegionHealthChecksMethodDescriptor).build();
        HttpJsonCallSettings patchRegionHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchRegionHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings updateRegionHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRegionHealthCheckMethodDescriptor).build();
        this.deleteRegionHealthCheckCallable = callableFactory.createUnaryCallable(deleteRegionHealthCheckTransportSettings, settings.deleteRegionHealthCheckSettings(), clientContext);
        this.getRegionHealthCheckCallable = callableFactory.createUnaryCallable(getRegionHealthCheckTransportSettings, settings.getRegionHealthCheckSettings(), clientContext);
        this.insertRegionHealthCheckCallable = callableFactory.createUnaryCallable(insertRegionHealthCheckTransportSettings, settings.insertRegionHealthCheckSettings(), clientContext);
        this.listRegionHealthChecksCallable = callableFactory.createUnaryCallable(listRegionHealthChecksTransportSettings, settings.listRegionHealthChecksSettings(), clientContext);
        this.listRegionHealthChecksPagedCallable = callableFactory.createPagedCallable(listRegionHealthChecksTransportSettings, settings.listRegionHealthChecksSettings(), clientContext);
        this.patchRegionHealthCheckCallable = callableFactory.createUnaryCallable(patchRegionHealthCheckTransportSettings, settings.patchRegionHealthCheckSettings(), clientContext);
        this.updateRegionHealthCheckCallable = callableFactory.createUnaryCallable(updateRegionHealthCheckTransportSettings, settings.updateRegionHealthCheckSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckCallable() {
        return this.deleteRegionHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckCallable() {
        return this.getRegionHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckCallable() {
        return this.insertRegionHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionHealthChecksHttpRequest, RegionHealthCheckClient.ListRegionHealthChecksPagedResponse> listRegionHealthChecksPagedCallable() {
        return this.listRegionHealthChecksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionHealthChecksHttpRequest, HealthCheckList> listRegionHealthChecksCallable() {
        return this.listRegionHealthChecksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckCallable() {
        return this.patchRegionHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckCallable() {
        return this.updateRegionHealthCheckCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

