/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class LicenseResourceCommitment
implements ApiMessage {
    private final String amount;
    private final String coresPerLicense;
    private final String license;
    private static final LicenseResourceCommitment DEFAULT_INSTANCE = new LicenseResourceCommitment();

    private LicenseResourceCommitment() {
        this.amount = null;
        this.coresPerLicense = null;
        this.license = null;
    }

    private LicenseResourceCommitment(String amount, String coresPerLicense, String license) {
        this.amount = amount;
        this.coresPerLicense = coresPerLicense;
        this.license = license;
    }

    public Object getFieldValue(String fieldName) {
        if ("amount".equals(fieldName)) {
            return this.amount;
        }
        if ("coresPerLicense".equals(fieldName)) {
            return this.coresPerLicense;
        }
        if ("license".equals(fieldName)) {
            return this.license;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getCoresPerLicense() {
        return this.coresPerLicense;
    }

    public String getLicense() {
        return this.license;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LicenseResourceCommitment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static LicenseResourceCommitment getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "LicenseResourceCommitment{amount=" + this.amount + ", coresPerLicense=" + this.coresPerLicense + ", license=" + this.license + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LicenseResourceCommitment) {
            LicenseResourceCommitment that = (LicenseResourceCommitment)o;
            return Objects.equals(this.amount, that.getAmount()) && Objects.equals(this.coresPerLicense, that.getCoresPerLicense()) && Objects.equals(this.license, that.getLicense());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.coresPerLicense, this.license);
    }

    public static class Builder {
        private String amount;
        private String coresPerLicense;
        private String license;

        Builder() {
        }

        public Builder mergeFrom(LicenseResourceCommitment other) {
            if (other == LicenseResourceCommitment.getDefaultInstance()) {
                return this;
            }
            if (other.getAmount() != null) {
                this.amount = other.amount;
            }
            if (other.getCoresPerLicense() != null) {
                this.coresPerLicense = other.coresPerLicense;
            }
            if (other.getLicense() != null) {
                this.license = other.license;
            }
            return this;
        }

        Builder(LicenseResourceCommitment source) {
            this.amount = source.amount;
            this.coresPerLicense = source.coresPerLicense;
            this.license = source.license;
        }

        public String getAmount() {
            return this.amount;
        }

        public Builder setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public String getCoresPerLicense() {
            return this.coresPerLicense;
        }

        public Builder setCoresPerLicense(String coresPerLicense) {
            this.coresPerLicense = coresPerLicense;
            return this;
        }

        public String getLicense() {
            return this.license;
        }

        public Builder setLicense(String license) {
            this.license = license;
            return this;
        }

        public LicenseResourceCommitment build() {
            return new LicenseResourceCommitment(this.amount, this.coresPerLicense, this.license);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAmount(this.amount);
            newBuilder.setCoresPerLicense(this.coresPerLicense);
            newBuilder.setLicense(this.license);
            return newBuilder;
        }
    }
}

