/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HttpHeaderAction;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class WeightedBackendService
implements ApiMessage {
    private final String backendService;
    private final HttpHeaderAction headerAction;
    private final Integer weight;
    private static final WeightedBackendService DEFAULT_INSTANCE = new WeightedBackendService();

    private WeightedBackendService() {
        this.backendService = null;
        this.headerAction = null;
        this.weight = null;
    }

    private WeightedBackendService(String backendService, HttpHeaderAction headerAction, Integer weight) {
        this.backendService = backendService;
        this.headerAction = headerAction;
        this.weight = weight;
    }

    public Object getFieldValue(String fieldName) {
        if ("backendService".equals(fieldName)) {
            return this.backendService;
        }
        if ("headerAction".equals(fieldName)) {
            return this.headerAction;
        }
        if ("weight".equals(fieldName)) {
            return this.weight;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getBackendService() {
        return this.backendService;
    }

    public HttpHeaderAction getHeaderAction() {
        return this.headerAction;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(WeightedBackendService prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static WeightedBackendService getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "WeightedBackendService{backendService=" + this.backendService + ", headerAction=" + this.headerAction + ", weight=" + this.weight + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WeightedBackendService) {
            WeightedBackendService that = (WeightedBackendService)o;
            return Objects.equals(this.backendService, that.getBackendService()) && Objects.equals(this.headerAction, that.getHeaderAction()) && Objects.equals(this.weight, that.getWeight());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendService, this.headerAction, this.weight);
    }

    public static class Builder {
        private String backendService;
        private HttpHeaderAction headerAction;
        private Integer weight;

        Builder() {
        }

        public Builder mergeFrom(WeightedBackendService other) {
            if (other == WeightedBackendService.getDefaultInstance()) {
                return this;
            }
            if (other.getBackendService() != null) {
                this.backendService = other.backendService;
            }
            if (other.getHeaderAction() != null) {
                this.headerAction = other.headerAction;
            }
            if (other.getWeight() != null) {
                this.weight = other.weight;
            }
            return this;
        }

        Builder(WeightedBackendService source) {
            this.backendService = source.backendService;
            this.headerAction = source.headerAction;
            this.weight = source.weight;
        }

        public String getBackendService() {
            return this.backendService;
        }

        public Builder setBackendService(String backendService) {
            this.backendService = backendService;
            return this;
        }

        public HttpHeaderAction getHeaderAction() {
            return this.headerAction;
        }

        public Builder setHeaderAction(HttpHeaderAction headerAction) {
            this.headerAction = headerAction;
            return this;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public Builder setWeight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public WeightedBackendService build() {
            return new WeightedBackendService(this.backendService, this.headerAction, this.weight);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setBackendService(this.backendService);
            newBuilder.setHeaderAction(this.headerAction);
            newBuilder.setWeight(this.weight);
            return newBuilder;
        }
    }
}

