/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendServiceLogConfig
implements ApiMessage {
    private final Boolean enable;
    private final Float sampleRate;
    private static final BackendServiceLogConfig DEFAULT_INSTANCE = new BackendServiceLogConfig();

    private BackendServiceLogConfig() {
        this.enable = null;
        this.sampleRate = null;
    }

    private BackendServiceLogConfig(Boolean enable, Float sampleRate) {
        this.enable = enable;
        this.sampleRate = sampleRate;
    }

    public Object getFieldValue(String fieldName) {
        if ("enable".equals(fieldName)) {
            return this.enable;
        }
        if ("sampleRate".equals(fieldName)) {
            return this.sampleRate;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public Float getSampleRate() {
        return this.sampleRate;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendServiceLogConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendServiceLogConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendServiceLogConfig{enable=" + this.enable + ", sampleRate=" + this.sampleRate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendServiceLogConfig) {
            BackendServiceLogConfig that = (BackendServiceLogConfig)o;
            return Objects.equals(this.enable, that.getEnable()) && Objects.equals(this.sampleRate, that.getSampleRate());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.enable, this.sampleRate);
    }

    public static class Builder {
        private Boolean enable;
        private Float sampleRate;

        Builder() {
        }

        public Builder mergeFrom(BackendServiceLogConfig other) {
            if (other == BackendServiceLogConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getEnable() != null) {
                this.enable = other.enable;
            }
            if (other.getSampleRate() != null) {
                this.sampleRate = other.sampleRate;
            }
            return this;
        }

        Builder(BackendServiceLogConfig source) {
            this.enable = source.enable;
            this.sampleRate = source.sampleRate;
        }

        public Boolean getEnable() {
            return this.enable;
        }

        public Builder setEnable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public Float getSampleRate() {
            return this.sampleRate;
        }

        public Builder setSampleRate(Float sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public BackendServiceLogConfig build() {
            return new BackendServiceLogConfig(this.enable, this.sampleRate);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEnable(this.enable);
            newBuilder.setSampleRate(this.sampleRate);
            return newBuilder;
        }
    }
}

