/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.core.ApiFunction;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.compute.deprecated.DeprecationStatus;
import com.google.cloud.compute.deprecated.RegionId;
import com.google.cloud.compute.deprecated.ZoneId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public class Zone
implements Serializable {
    static final Function<com.google.api.services.compute.model.Zone, Zone> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.Zone, Zone>(){

        public Zone apply(com.google.api.services.compute.model.Zone pb) {
            return Zone.fromPb(pb);
        }
    };
    static final Function<Zone, com.google.api.services.compute.model.Zone> TO_PB_FUNCTION = new Function<Zone, com.google.api.services.compute.model.Zone>(){

        public com.google.api.services.compute.model.Zone apply(Zone region) {
            return region.toPb();
        }
    };
    private static final long serialVersionUID = 6113636504417213010L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone((org.threeten.bp.ZoneId)ZoneOffset.UTC);
    private final ZoneId zoneId;
    private final String generatedId;
    private final Long creationTimestamp;
    private final String description;
    private final Status status;
    private final RegionId region;
    private final DeprecationStatus<ZoneId> deprecationStatus;

    private Zone(Builder builder) {
        this.zoneId = builder.zoneId;
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.status = builder.status;
        this.region = builder.region;
        this.deprecationStatus = builder.deprecationStatus;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Status getStatus() {
        return this.status;
    }

    public RegionId getRegion() {
        return this.region;
    }

    public DeprecationStatus<ZoneId> getDeprecationStatus() {
        return this.deprecationStatus;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("zoneId", (Object)this.zoneId).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("description", (Object)this.description).add("status", (Object)this.status).add("region", (Object)this.region).add("deprecationStatus", this.deprecationStatus).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.zoneId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(Zone.class) && Objects.equals(this.toPb(), ((Zone)obj).toPb());
    }

    com.google.api.services.compute.model.Zone toPb() {
        com.google.api.services.compute.model.Zone zonePb = new com.google.api.services.compute.model.Zone();
        if (this.generatedId != null) {
            zonePb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            zonePb.setCreationTimestamp(TIMESTAMP_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((long)this.creationTimestamp)));
        }
        zonePb.setName(this.zoneId.getZone());
        zonePb.setDescription(this.description);
        zonePb.setSelfLink(this.zoneId.getSelfLink());
        if (this.status != null) {
            zonePb.setStatus(this.status.name());
        }
        if (this.region != null) {
            zonePb.setRegion(this.region.getSelfLink());
        }
        if (this.deprecationStatus != null) {
            zonePb.setDeprecated(this.deprecationStatus.toPb());
        }
        return zonePb;
    }

    static Builder builder() {
        return new Builder();
    }

    static Zone fromPb(com.google.api.services.compute.model.Zone zonePb) {
        Builder builder = Zone.builder();
        builder.setZoneId(ZoneId.fromUrl(zonePb.getSelfLink()));
        if (zonePb.getId() != null) {
            builder.setGeneratedId(zonePb.getId().toString());
        }
        if (zonePb.getCreationTimestamp() != null) {
            builder.setCreationTimestamp(((Instant)TIMESTAMP_FORMATTER.parse((CharSequence)zonePb.getCreationTimestamp(), Instant.FROM)).toEpochMilli());
        }
        builder.setDescription(zonePb.getDescription());
        if (zonePb.getStatus() != null) {
            builder.setStatus(Status.valueOf(zonePb.getStatus()));
        }
        if (zonePb.getRegion() != null) {
            builder.setRegion(RegionId.fromUrl(zonePb.getRegion()));
        }
        if (zonePb.getDeprecated() != null) {
            builder.setDeprecationStatus(DeprecationStatus.fromPb(zonePb.getDeprecated(), ZoneId.FROM_URL_FUNCTION));
        }
        return builder.build();
    }

    static final class Builder {
        private ZoneId zoneId;
        private String generatedId;
        private Long creationTimestamp;
        private String description;
        private Status status;
        private RegionId region;
        private DeprecationStatus<ZoneId> deprecationStatus;

        private Builder() {
        }

        Builder setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        Builder setRegion(RegionId region) {
            this.region = region;
            return this;
        }

        Builder setDeprecationStatus(DeprecationStatus<ZoneId> deprecationStatus) {
            this.deprecationStatus = deprecationStatus;
            return this;
        }

        Zone build() {
            return new Zone(this);
        }
    }

    public static final class Status
    extends StringEnumValue {
        private static final long serialVersionUID = -1052872318386811804L;
        private static final ApiFunction<String, Status> CONSTRUCTOR = new ApiFunction<String, Status>(){

            public Status apply(String constant) {
                return new Status(constant);
            }
        };
        private static final StringEnumType<Status> type = new StringEnumType(Status.class, CONSTRUCTOR);
        public static final Status UP = (Status)((Object)type.createAndRegister("UP"));
        public static final Status DOWN = (Status)((Object)type.createAndRegister("DOWN"));

        private Status(String constant) {
            super(constant);
        }

        public static Status valueOfStrict(String constant) {
            return (Status)((Object)type.valueOfStrict(constant));
        }

        public static Status valueOf(String constant) {
            return (Status)((Object)type.valueOf(constant));
        }

        public static Status[] values() {
            return (Status[])type.values();
        }
    }
}

