/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Expr;
import com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SecurityPolicyRuleMatcher
implements ApiMessage {
    private final SecurityPolicyRuleMatcherConfig config;
    private final Expr expr;
    private final String versionedExpr;
    private static final SecurityPolicyRuleMatcher DEFAULT_INSTANCE = new SecurityPolicyRuleMatcher();

    private SecurityPolicyRuleMatcher() {
        this.config = null;
        this.expr = null;
        this.versionedExpr = null;
    }

    private SecurityPolicyRuleMatcher(SecurityPolicyRuleMatcherConfig config, Expr expr, String versionedExpr) {
        this.config = config;
        this.expr = expr;
        this.versionedExpr = versionedExpr;
    }

    public Object getFieldValue(String fieldName) {
        if ("config".equals(fieldName)) {
            return this.config;
        }
        if ("expr".equals(fieldName)) {
            return this.expr;
        }
        if ("versionedExpr".equals(fieldName)) {
            return this.versionedExpr;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public SecurityPolicyRuleMatcherConfig getConfig() {
        return this.config;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public String getVersionedExpr() {
        return this.versionedExpr;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SecurityPolicyRuleMatcher prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SecurityPolicyRuleMatcher getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SecurityPolicyRuleMatcher{config=" + this.config + ", expr=" + this.expr + ", versionedExpr=" + this.versionedExpr + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecurityPolicyRuleMatcher) {
            SecurityPolicyRuleMatcher that = (SecurityPolicyRuleMatcher)o;
            return Objects.equals(this.config, that.getConfig()) && Objects.equals(this.expr, that.getExpr()) && Objects.equals(this.versionedExpr, that.getVersionedExpr());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.config, this.expr, this.versionedExpr);
    }

    public static class Builder {
        private SecurityPolicyRuleMatcherConfig config;
        private Expr expr;
        private String versionedExpr;

        Builder() {
        }

        public Builder mergeFrom(SecurityPolicyRuleMatcher other) {
            if (other == SecurityPolicyRuleMatcher.getDefaultInstance()) {
                return this;
            }
            if (other.getConfig() != null) {
                this.config = other.config;
            }
            if (other.getExpr() != null) {
                this.expr = other.expr;
            }
            if (other.getVersionedExpr() != null) {
                this.versionedExpr = other.versionedExpr;
            }
            return this;
        }

        Builder(SecurityPolicyRuleMatcher source) {
            this.config = source.config;
            this.expr = source.expr;
            this.versionedExpr = source.versionedExpr;
        }

        public SecurityPolicyRuleMatcherConfig getConfig() {
            return this.config;
        }

        public Builder setConfig(SecurityPolicyRuleMatcherConfig config) {
            this.config = config;
            return this;
        }

        public Expr getExpr() {
            return this.expr;
        }

        public Builder setExpr(Expr expr) {
            this.expr = expr;
            return this;
        }

        public String getVersionedExpr() {
            return this.versionedExpr;
        }

        public Builder setVersionedExpr(String versionedExpr) {
            this.versionedExpr = versionedExpr;
            return this;
        }

        public SecurityPolicyRuleMatcher build() {
            return new SecurityPolicyRuleMatcher(this.config, this.expr, this.versionedExpr);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setConfig(this.config);
            newBuilder.setExpr(this.expr);
            newBuilder.setVersionedExpr(this.versionedExpr);
            return newBuilder;
        }
    }
}

