/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionUrlMapName
implements ResourceName {
    private final String project;
    private final String region;
    private final String urlMap;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/urlMaps/{urlMap}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionUrlMapName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.urlMap = (String)Preconditions.checkNotNull((Object)builder.getUrlMap());
    }

    public static ProjectRegionUrlMapName of(String project, String region, String urlMap) {
        return ProjectRegionUrlMapName.newBuilder().setProject(project).setRegion(region).setUrlMap(urlMap).build();
    }

    public static String format(String project, String region, String urlMap) {
        return ProjectRegionUrlMapName.of(project, region, urlMap).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getUrlMap() {
        return this.urlMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionUrlMapName projectRegionUrlMapName = this;
            synchronized (projectRegionUrlMapName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"urlMap", (Object)this.urlMap);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionUrlMapName> newFactory() {
        return new ResourceNameFactory<ProjectRegionUrlMapName>(){

            public ProjectRegionUrlMapName parse(String formattedString) {
                return ProjectRegionUrlMapName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionUrlMapName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionUrlMapName.parse: formattedString not in valid format");
        return ProjectRegionUrlMapName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("urlMap"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "urlMap", this.urlMap});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionUrlMapName) {
            ProjectRegionUrlMapName that = (ProjectRegionUrlMapName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.urlMap, that.getUrlMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.urlMap);
    }

    public static class Builder {
        private String project;
        private String region;
        private String urlMap;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getUrlMap() {
            return this.urlMap;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setUrlMap(String urlMap) {
            this.urlMap = urlMap;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionUrlMapName projectRegionUrlMapName) {
            this.project = projectRegionUrlMapName.project;
            this.region = projectRegionUrlMapName.region;
            this.urlMap = projectRegionUrlMapName.urlMap;
        }

        public ProjectRegionUrlMapName build() {
            return new ProjectRegionUrlMapName(this);
        }
    }
}

