/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendServiceFailoverPolicy
implements ApiMessage {
    private final Boolean disableConnectionDrainOnFailover;
    private final Boolean dropTrafficIfUnhealthy;
    private final Float failoverRatio;
    private static final BackendServiceFailoverPolicy DEFAULT_INSTANCE = new BackendServiceFailoverPolicy();

    private BackendServiceFailoverPolicy() {
        this.disableConnectionDrainOnFailover = null;
        this.dropTrafficIfUnhealthy = null;
        this.failoverRatio = null;
    }

    private BackendServiceFailoverPolicy(Boolean disableConnectionDrainOnFailover, Boolean dropTrafficIfUnhealthy, Float failoverRatio) {
        this.disableConnectionDrainOnFailover = disableConnectionDrainOnFailover;
        this.dropTrafficIfUnhealthy = dropTrafficIfUnhealthy;
        this.failoverRatio = failoverRatio;
    }

    public Object getFieldValue(String fieldName) {
        if ("disableConnectionDrainOnFailover".equals(fieldName)) {
            return this.disableConnectionDrainOnFailover;
        }
        if ("dropTrafficIfUnhealthy".equals(fieldName)) {
            return this.dropTrafficIfUnhealthy;
        }
        if ("failoverRatio".equals(fieldName)) {
            return this.failoverRatio;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getDisableConnectionDrainOnFailover() {
        return this.disableConnectionDrainOnFailover;
    }

    public Boolean getDropTrafficIfUnhealthy() {
        return this.dropTrafficIfUnhealthy;
    }

    public Float getFailoverRatio() {
        return this.failoverRatio;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendServiceFailoverPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendServiceFailoverPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendServiceFailoverPolicy{disableConnectionDrainOnFailover=" + this.disableConnectionDrainOnFailover + ", dropTrafficIfUnhealthy=" + this.dropTrafficIfUnhealthy + ", failoverRatio=" + this.failoverRatio + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendServiceFailoverPolicy) {
            BackendServiceFailoverPolicy that = (BackendServiceFailoverPolicy)o;
            return Objects.equals(this.disableConnectionDrainOnFailover, that.getDisableConnectionDrainOnFailover()) && Objects.equals(this.dropTrafficIfUnhealthy, that.getDropTrafficIfUnhealthy()) && Objects.equals(this.failoverRatio, that.getFailoverRatio());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.disableConnectionDrainOnFailover, this.dropTrafficIfUnhealthy, this.failoverRatio);
    }

    public static class Builder {
        private Boolean disableConnectionDrainOnFailover;
        private Boolean dropTrafficIfUnhealthy;
        private Float failoverRatio;

        Builder() {
        }

        public Builder mergeFrom(BackendServiceFailoverPolicy other) {
            if (other == BackendServiceFailoverPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getDisableConnectionDrainOnFailover() != null) {
                this.disableConnectionDrainOnFailover = other.disableConnectionDrainOnFailover;
            }
            if (other.getDropTrafficIfUnhealthy() != null) {
                this.dropTrafficIfUnhealthy = other.dropTrafficIfUnhealthy;
            }
            if (other.getFailoverRatio() != null) {
                this.failoverRatio = other.failoverRatio;
            }
            return this;
        }

        Builder(BackendServiceFailoverPolicy source) {
            this.disableConnectionDrainOnFailover = source.disableConnectionDrainOnFailover;
            this.dropTrafficIfUnhealthy = source.dropTrafficIfUnhealthy;
            this.failoverRatio = source.failoverRatio;
        }

        public Boolean getDisableConnectionDrainOnFailover() {
            return this.disableConnectionDrainOnFailover;
        }

        public Builder setDisableConnectionDrainOnFailover(Boolean disableConnectionDrainOnFailover) {
            this.disableConnectionDrainOnFailover = disableConnectionDrainOnFailover;
            return this;
        }

        public Boolean getDropTrafficIfUnhealthy() {
            return this.dropTrafficIfUnhealthy;
        }

        public Builder setDropTrafficIfUnhealthy(Boolean dropTrafficIfUnhealthy) {
            this.dropTrafficIfUnhealthy = dropTrafficIfUnhealthy;
            return this;
        }

        public Float getFailoverRatio() {
            return this.failoverRatio;
        }

        public Builder setFailoverRatio(Float failoverRatio) {
            this.failoverRatio = failoverRatio;
            return this;
        }

        public BackendServiceFailoverPolicy build() {
            return new BackendServiceFailoverPolicy(this.disableConnectionDrainOnFailover, this.dropTrafficIfUnhealthy, this.failoverRatio);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDisableConnectionDrainOnFailover(this.disableConnectionDrainOnFailover);
            newBuilder.setDropTrafficIfUnhealthy(this.dropTrafficIfUnhealthy);
            newBuilder.setFailoverRatio(this.failoverRatio);
            return newBuilder;
        }
    }
}

