/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteLicenseHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyLicenseHttpRequest;
import com.google.cloud.compute.v1.GetLicenseHttpRequest;
import com.google.cloud.compute.v1.InsertLicenseHttpRequest;
import com.google.cloud.compute.v1.License;
import com.google.cloud.compute.v1.LicenseClient;
import com.google.cloud.compute.v1.LicensesListResponse;
import com.google.cloud.compute.v1.ListLicensesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectGlobalLicenseName;
import com.google.cloud.compute.v1.ProjectGlobalLicenseResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetIamPolicyLicenseHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsLicenseHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonLicenseCallableFactory;
import com.google.cloud.compute.v1.stub.LicenseStub;
import com.google.cloud.compute.v1.stub.LicenseStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonLicenseStub
extends LicenseStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteLicenseHttpRequest, Operation> deleteLicenseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses/{license}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalLicenseName.newFactory()).setResourceNameField("license").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetLicenseHttpRequest, License> getLicenseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses/{license}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalLicenseName.newFactory()).setResourceNameField("license").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)License.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyLicenseHttpRequest, Policy> getIamPolicyLicenseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalLicenseResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertLicenseHttpRequest, Operation> insertLicenseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListLicensesHttpRequest, LicensesListResponse> listLicensesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)LicensesListResponse.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyLicenseHttpRequest, Policy> setIamPolicyLicenseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalLicenseResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.licenses.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/licenses/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalLicenseResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteLicenseHttpRequest, Operation> deleteLicenseCallable;
    private final UnaryCallable<GetLicenseHttpRequest, License> getLicenseCallable;
    private final UnaryCallable<GetIamPolicyLicenseHttpRequest, Policy> getIamPolicyLicenseCallable;
    private final UnaryCallable<InsertLicenseHttpRequest, Operation> insertLicenseCallable;
    private final UnaryCallable<ListLicensesHttpRequest, LicensesListResponse> listLicensesCallable;
    private final UnaryCallable<ListLicensesHttpRequest, LicenseClient.ListLicensesPagedResponse> listLicensesPagedCallable;
    private final UnaryCallable<SetIamPolicyLicenseHttpRequest, Policy> setIamPolicyLicenseCallable;
    private final UnaryCallable<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonLicenseStub create(LicenseStubSettings settings) throws IOException {
        return new HttpJsonLicenseStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonLicenseStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonLicenseStub(LicenseStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonLicenseStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonLicenseStub(LicenseStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonLicenseStub(LicenseStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonLicenseCallableFactory());
    }

    protected HttpJsonLicenseStub(LicenseStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteLicenseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteLicenseMethodDescriptor).build();
        HttpJsonCallSettings getLicenseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLicenseMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyLicenseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyLicenseMethodDescriptor).build();
        HttpJsonCallSettings insertLicenseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertLicenseMethodDescriptor).build();
        HttpJsonCallSettings listLicensesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLicensesMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyLicenseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyLicenseMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsLicenseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsLicenseMethodDescriptor).build();
        this.deleteLicenseCallable = callableFactory.createUnaryCallable(deleteLicenseTransportSettings, settings.deleteLicenseSettings(), clientContext);
        this.getLicenseCallable = callableFactory.createUnaryCallable(getLicenseTransportSettings, settings.getLicenseSettings(), clientContext);
        this.getIamPolicyLicenseCallable = callableFactory.createUnaryCallable(getIamPolicyLicenseTransportSettings, settings.getIamPolicyLicenseSettings(), clientContext);
        this.insertLicenseCallable = callableFactory.createUnaryCallable(insertLicenseTransportSettings, settings.insertLicenseSettings(), clientContext);
        this.listLicensesCallable = callableFactory.createUnaryCallable(listLicensesTransportSettings, settings.listLicensesSettings(), clientContext);
        this.listLicensesPagedCallable = callableFactory.createPagedCallable(listLicensesTransportSettings, settings.listLicensesSettings(), clientContext);
        this.setIamPolicyLicenseCallable = callableFactory.createUnaryCallable(setIamPolicyLicenseTransportSettings, settings.setIamPolicyLicenseSettings(), clientContext);
        this.testIamPermissionsLicenseCallable = callableFactory.createUnaryCallable(testIamPermissionsLicenseTransportSettings, settings.testIamPermissionsLicenseSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteLicenseHttpRequest, Operation> deleteLicenseCallable() {
        return this.deleteLicenseCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetLicenseHttpRequest, License> getLicenseCallable() {
        return this.getLicenseCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicyLicenseHttpRequest, Policy> getIamPolicyLicenseCallable() {
        return this.getIamPolicyLicenseCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertLicenseHttpRequest, Operation> insertLicenseCallable() {
        return this.insertLicenseCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListLicensesHttpRequest, LicenseClient.ListLicensesPagedResponse> listLicensesPagedCallable() {
        return this.listLicensesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListLicensesHttpRequest, LicensesListResponse> listLicensesCallable() {
        return this.listLicensesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicyLicenseHttpRequest, Policy> setIamPolicyLicenseCallable() {
        return this.setIamPolicyLicenseCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseCallable() {
        return this.testIamPermissionsLicenseCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

