/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class UrlMapsScopedList
implements ApiMessage {
    private final List<UrlMap> urlMaps;
    private final Warning warning;
    private static final UrlMapsScopedList DEFAULT_INSTANCE = new UrlMapsScopedList();

    private UrlMapsScopedList() {
        this.urlMaps = null;
        this.warning = null;
    }

    private UrlMapsScopedList(List<UrlMap> urlMaps, Warning warning) {
        this.urlMaps = urlMaps;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("urlMaps".equals(fieldName)) {
            return this.urlMaps;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<UrlMap> getUrlMapsList() {
        return this.urlMaps;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(UrlMapsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static UrlMapsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "UrlMapsScopedList{urlMaps=" + this.urlMaps + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UrlMapsScopedList) {
            UrlMapsScopedList that = (UrlMapsScopedList)o;
            return Objects.equals(this.urlMaps, that.getUrlMapsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.urlMaps, this.warning);
    }

    public static class Builder {
        private List<UrlMap> urlMaps;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(UrlMapsScopedList other) {
            if (other == UrlMapsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getUrlMapsList() != null) {
                this.urlMaps = other.urlMaps;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(UrlMapsScopedList source) {
            this.urlMaps = source.urlMaps;
            this.warning = source.warning;
        }

        public List<UrlMap> getUrlMapsList() {
            return this.urlMaps;
        }

        public Builder addAllUrlMaps(List<UrlMap> urlMaps) {
            if (this.urlMaps == null) {
                this.urlMaps = new LinkedList<UrlMap>();
            }
            this.urlMaps.addAll(urlMaps);
            return this;
        }

        public Builder addUrlMaps(UrlMap urlMaps) {
            if (this.urlMaps == null) {
                this.urlMaps = new LinkedList<UrlMap>();
            }
            this.urlMaps.add(urlMaps);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public UrlMapsScopedList build() {
            return new UrlMapsScopedList(this.urlMaps, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllUrlMaps(this.urlMaps);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

