/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionAddressName
implements ResourceName {
    private final String address;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/addresses/{address}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionAddressName(Builder builder) {
        this.address = (String)Preconditions.checkNotNull((Object)builder.getAddress());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionAddressName of(String address, String project, String region) {
        return ProjectRegionAddressName.newBuilder().setAddress(address).setProject(project).setRegion(region).build();
    }

    public static String format(String address, String project, String region) {
        return ProjectRegionAddressName.of(address, project, region).toString();
    }

    public String getAddress() {
        return this.address;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionAddressName projectRegionAddressName = this;
            synchronized (projectRegionAddressName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"address", (Object)this.address);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionAddressName> newFactory() {
        return new ResourceNameFactory<ProjectRegionAddressName>(){

            public ProjectRegionAddressName parse(String formattedString) {
                return ProjectRegionAddressName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionAddressName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionAddressName.parse: formattedString not in valid format");
        return ProjectRegionAddressName.of((String)matchMap.get("address"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"address", this.address, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionAddressName) {
            ProjectRegionAddressName that = (ProjectRegionAddressName)o;
            return Objects.equals(this.address, that.getAddress()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.project, this.region);
    }

    public static class Builder {
        private String address;
        private String project;
        private String region;

        public String getAddress() {
            return this.address;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionAddressName projectRegionAddressName) {
            this.address = projectRegionAddressName.address;
            this.project = projectRegionAddressName.project;
            this.region = projectRegionAddressName.region;
        }

        public ProjectRegionAddressName build() {
            return new ProjectRegionAddressName(this);
        }
    }
}

