/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListForwardingRulesHttpRequest;
import com.google.cloud.compute.v1.DeleteForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleAggregatedList;
import com.google.cloud.compute.v1.ForwardingRuleClient;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.ForwardingRulesScopedList;
import com.google.cloud.compute.v1.GetForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.InsertForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ListForwardingRulesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetTargetForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.stub.ForwardingRuleStub;
import com.google.cloud.compute.v1.stub.HttpJsonForwardingRuleStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ForwardingRuleStubSettings
extends StubSettings<ForwardingRuleStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse> aggregatedListForwardingRulesSettings;
    private final UnaryCallSettings<DeleteForwardingRuleHttpRequest, Operation> deleteForwardingRuleSettings;
    private final UnaryCallSettings<GetForwardingRuleHttpRequest, ForwardingRule> getForwardingRuleSettings;
    private final UnaryCallSettings<InsertForwardingRuleHttpRequest, Operation> insertForwardingRuleSettings;
    private final PagedCallSettings<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRuleClient.ListForwardingRulesPagedResponse> listForwardingRulesSettings;
    private final UnaryCallSettings<SetTargetForwardingRuleHttpRequest, Operation> setTargetForwardingRuleSettings;
    private static final PagedListDescriptor<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList> AGGREGATED_LIST_FORWARDING_RULES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListForwardingRulesHttpRequest injectToken(AggregatedListForwardingRulesHttpRequest payload, String token) {
            return AggregatedListForwardingRulesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListForwardingRulesHttpRequest injectPageSize(AggregatedListForwardingRulesHttpRequest payload, int pageSize) {
            return AggregatedListForwardingRulesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListForwardingRulesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ForwardingRuleAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ForwardingRulesScopedList> extractResources(ForwardingRuleAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> LIST_FORWARDING_RULES_PAGE_STR_DESC = new PagedListDescriptor<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule>(){

        public String emptyToken() {
            return "";
        }

        public ListForwardingRulesHttpRequest injectToken(ListForwardingRulesHttpRequest payload, String token) {
            return ListForwardingRulesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListForwardingRulesHttpRequest injectPageSize(ListForwardingRulesHttpRequest payload, int pageSize) {
            return ListForwardingRulesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListForwardingRulesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ForwardingRuleList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ForwardingRule> extractResources(ForwardingRuleList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse> AGGREGATED_LIST_FORWARDING_RULES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse>(){

        public ApiFuture<ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList> callable, AggregatedListForwardingRulesHttpRequest request, ApiCallContext context, ApiFuture<ForwardingRuleAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_FORWARDING_RULES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse.createAsync((PageContext<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRuleClient.ListForwardingRulesPagedResponse> LIST_FORWARDING_RULES_PAGE_STR_FACT = new PagedListResponseFactory<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRuleClient.ListForwardingRulesPagedResponse>(){

        public ApiFuture<ForwardingRuleClient.ListForwardingRulesPagedResponse> getFuturePagedResponse(UnaryCallable<ListForwardingRulesHttpRequest, ForwardingRuleList> callable, ListForwardingRulesHttpRequest request, ApiCallContext context, ApiFuture<ForwardingRuleList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FORWARDING_RULES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ForwardingRuleClient.ListForwardingRulesPagedResponse.createAsync((PageContext<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse> aggregatedListForwardingRulesSettings() {
        return this.aggregatedListForwardingRulesSettings;
    }

    public UnaryCallSettings<DeleteForwardingRuleHttpRequest, Operation> deleteForwardingRuleSettings() {
        return this.deleteForwardingRuleSettings;
    }

    public UnaryCallSettings<GetForwardingRuleHttpRequest, ForwardingRule> getForwardingRuleSettings() {
        return this.getForwardingRuleSettings;
    }

    public UnaryCallSettings<InsertForwardingRuleHttpRequest, Operation> insertForwardingRuleSettings() {
        return this.insertForwardingRuleSettings;
    }

    public PagedCallSettings<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRuleClient.ListForwardingRulesPagedResponse> listForwardingRulesSettings() {
        return this.listForwardingRulesSettings;
    }

    public UnaryCallSettings<SetTargetForwardingRuleHttpRequest, Operation> setTargetForwardingRuleSettings() {
        return this.setTargetForwardingRuleSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ForwardingRuleStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonForwardingRuleStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ForwardingRuleStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ForwardingRuleStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ForwardingRuleStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListForwardingRulesSettings = settingsBuilder.aggregatedListForwardingRulesSettings().build();
        this.deleteForwardingRuleSettings = settingsBuilder.deleteForwardingRuleSettings().build();
        this.getForwardingRuleSettings = settingsBuilder.getForwardingRuleSettings().build();
        this.insertForwardingRuleSettings = settingsBuilder.insertForwardingRuleSettings().build();
        this.listForwardingRulesSettings = settingsBuilder.listForwardingRulesSettings().build();
        this.setTargetForwardingRuleSettings = settingsBuilder.setTargetForwardingRuleSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ForwardingRuleStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse> aggregatedListForwardingRulesSettings;
        private final UnaryCallSettings.Builder<DeleteForwardingRuleHttpRequest, Operation> deleteForwardingRuleSettings;
        private final UnaryCallSettings.Builder<GetForwardingRuleHttpRequest, ForwardingRule> getForwardingRuleSettings;
        private final UnaryCallSettings.Builder<InsertForwardingRuleHttpRequest, Operation> insertForwardingRuleSettings;
        private final PagedCallSettings.Builder<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRuleClient.ListForwardingRulesPagedResponse> listForwardingRulesSettings;
        private final UnaryCallSettings.Builder<SetTargetForwardingRuleHttpRequest, Operation> setTargetForwardingRuleSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListForwardingRulesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_FORWARDING_RULES_PAGE_STR_FACT);
            this.deleteForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listForwardingRulesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FORWARDING_RULES_PAGE_STR_FACT);
            this.setTargetForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListForwardingRulesSettings, this.deleteForwardingRuleSettings, this.getForwardingRuleSettings, this.insertForwardingRuleSettings, this.listForwardingRulesSettings, this.setTargetForwardingRuleSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ForwardingRuleStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ForwardingRuleStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ForwardingRuleStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ForwardingRuleStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListForwardingRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listForwardingRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setTargetForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ForwardingRuleStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListForwardingRulesSettings = settings.aggregatedListForwardingRulesSettings.toBuilder();
            this.deleteForwardingRuleSettings = settings.deleteForwardingRuleSettings.toBuilder();
            this.getForwardingRuleSettings = settings.getForwardingRuleSettings.toBuilder();
            this.insertForwardingRuleSettings = settings.insertForwardingRuleSettings.toBuilder();
            this.listForwardingRulesSettings = settings.listForwardingRulesSettings.toBuilder();
            this.setTargetForwardingRuleSettings = settings.setTargetForwardingRuleSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListForwardingRulesSettings, this.deleteForwardingRuleSettings, this.getForwardingRuleSettings, this.insertForwardingRuleSettings, this.listForwardingRulesSettings, this.setTargetForwardingRuleSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRuleClient.AggregatedListForwardingRulesPagedResponse> aggregatedListForwardingRulesSettings() {
            return this.aggregatedListForwardingRulesSettings;
        }

        public UnaryCallSettings.Builder<DeleteForwardingRuleHttpRequest, Operation> deleteForwardingRuleSettings() {
            return this.deleteForwardingRuleSettings;
        }

        public UnaryCallSettings.Builder<GetForwardingRuleHttpRequest, ForwardingRule> getForwardingRuleSettings() {
            return this.getForwardingRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertForwardingRuleHttpRequest, Operation> insertForwardingRuleSettings() {
            return this.insertForwardingRuleSettings;
        }

        public PagedCallSettings.Builder<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRuleClient.ListForwardingRulesPagedResponse> listForwardingRulesSettings() {
            return this.listForwardingRulesSettings;
        }

        public UnaryCallSettings.Builder<SetTargetForwardingRuleHttpRequest, Operation> setTargetForwardingRuleSettings() {
            return this.setTargetForwardingRuleSettings;
        }

        public ForwardingRuleStubSettings build() throws IOException {
            return new ForwardingRuleStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

