/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalImageName
implements ResourceName {
    private final String image;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/images/{image}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalImageName(Builder builder) {
        this.image = (String)Preconditions.checkNotNull((Object)builder.getImage());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalImageName of(String image, String project) {
        return ProjectGlobalImageName.newBuilder().setImage(image).setProject(project).build();
    }

    public static String format(String image, String project) {
        return ProjectGlobalImageName.of(image, project).toString();
    }

    public String getImage() {
        return this.image;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalImageName projectGlobalImageName = this;
            synchronized (projectGlobalImageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"image", (Object)this.image);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalImageName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalImageName>(){

            public ProjectGlobalImageName parse(String formattedString) {
                return ProjectGlobalImageName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalImageName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalImageName.parse: formattedString not in valid format");
        return ProjectGlobalImageName.of((String)matchMap.get("image"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"image", this.image, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalImageName) {
            ProjectGlobalImageName that = (ProjectGlobalImageName)o;
            return Objects.equals(this.image, that.getImage()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.image, this.project);
    }

    public static class Builder {
        private String image;
        private String project;

        public String getImage() {
            return this.image;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalImageName projectGlobalImageName) {
            this.image = projectGlobalImageName.image;
            this.project = projectGlobalImageName.project;
        }

        public ProjectGlobalImageName build() {
            return new ProjectGlobalImageName(this);
        }
    }
}

