/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class OperationsScopedList
implements ApiMessage {
    private final List<Operation> operations;
    private final Warning warning;
    private static final OperationsScopedList DEFAULT_INSTANCE = new OperationsScopedList();

    private OperationsScopedList() {
        this.operations = null;
        this.warning = null;
    }

    private OperationsScopedList(List<Operation> operations, Warning warning) {
        this.operations = operations;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("operations".equals(fieldName)) {
            return this.operations;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Operation> getOperationsList() {
        return this.operations;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OperationsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static OperationsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "OperationsScopedList{operations=" + this.operations + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OperationsScopedList) {
            OperationsScopedList that = (OperationsScopedList)o;
            return Objects.equals(this.operations, that.getOperationsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.operations, this.warning);
    }

    public static class Builder {
        private List<Operation> operations;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(OperationsScopedList other) {
            if (other == OperationsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getOperationsList() != null) {
                this.operations = other.operations;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(OperationsScopedList source) {
            this.operations = source.operations;
            this.warning = source.warning;
        }

        public List<Operation> getOperationsList() {
            return this.operations;
        }

        public Builder addAllOperations(List<Operation> operations) {
            if (this.operations == null) {
                this.operations = new LinkedList<Operation>();
            }
            this.operations.addAll(operations);
            return this;
        }

        public Builder addOperations(Operation operations) {
            if (this.operations == null) {
                this.operations = new LinkedList<Operation>();
            }
            this.operations.add(operations);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public OperationsScopedList build() {
            return new OperationsScopedList(this.operations, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllOperations(this.operations);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

