/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry;
import com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectDiagnostics
implements ApiMessage {
    private final List<InterconnectDiagnosticsARPEntry> arpCaches;
    private final List<InterconnectDiagnosticsLinkStatus> links;
    private final String macAddress;
    private static final InterconnectDiagnostics DEFAULT_INSTANCE = new InterconnectDiagnostics();

    private InterconnectDiagnostics() {
        this.arpCaches = null;
        this.links = null;
        this.macAddress = null;
    }

    private InterconnectDiagnostics(List<InterconnectDiagnosticsARPEntry> arpCaches, List<InterconnectDiagnosticsLinkStatus> links, String macAddress) {
        this.arpCaches = arpCaches;
        this.links = links;
        this.macAddress = macAddress;
    }

    public Object getFieldValue(String fieldName) {
        if ("arpCaches".equals(fieldName)) {
            return this.arpCaches;
        }
        if ("links".equals(fieldName)) {
            return this.links;
        }
        if ("macAddress".equals(fieldName)) {
            return this.macAddress;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<InterconnectDiagnosticsARPEntry> getArpCachesList() {
        return this.arpCaches;
    }

    public List<InterconnectDiagnosticsLinkStatus> getLinksList() {
        return this.links;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectDiagnostics prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectDiagnostics getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectDiagnostics{arpCaches=" + this.arpCaches + ", links=" + this.links + ", macAddress=" + this.macAddress + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectDiagnostics) {
            InterconnectDiagnostics that = (InterconnectDiagnostics)o;
            return Objects.equals(this.arpCaches, that.getArpCachesList()) && Objects.equals(this.links, that.getLinksList()) && Objects.equals(this.macAddress, that.getMacAddress());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.arpCaches, this.links, this.macAddress);
    }

    public static class Builder {
        private List<InterconnectDiagnosticsARPEntry> arpCaches;
        private List<InterconnectDiagnosticsLinkStatus> links;
        private String macAddress;

        Builder() {
        }

        public Builder mergeFrom(InterconnectDiagnostics other) {
            if (other == InterconnectDiagnostics.getDefaultInstance()) {
                return this;
            }
            if (other.getArpCachesList() != null) {
                this.arpCaches = other.arpCaches;
            }
            if (other.getLinksList() != null) {
                this.links = other.links;
            }
            if (other.getMacAddress() != null) {
                this.macAddress = other.macAddress;
            }
            return this;
        }

        Builder(InterconnectDiagnostics source) {
            this.arpCaches = source.arpCaches;
            this.links = source.links;
            this.macAddress = source.macAddress;
        }

        public List<InterconnectDiagnosticsARPEntry> getArpCachesList() {
            return this.arpCaches;
        }

        public Builder addAllArpCaches(List<InterconnectDiagnosticsARPEntry> arpCaches) {
            if (this.arpCaches == null) {
                this.arpCaches = new LinkedList<InterconnectDiagnosticsARPEntry>();
            }
            this.arpCaches.addAll(arpCaches);
            return this;
        }

        public Builder addArpCaches(InterconnectDiagnosticsARPEntry arpCaches) {
            if (this.arpCaches == null) {
                this.arpCaches = new LinkedList<InterconnectDiagnosticsARPEntry>();
            }
            this.arpCaches.add(arpCaches);
            return this;
        }

        public List<InterconnectDiagnosticsLinkStatus> getLinksList() {
            return this.links;
        }

        public Builder addAllLinks(List<InterconnectDiagnosticsLinkStatus> links) {
            if (this.links == null) {
                this.links = new LinkedList<InterconnectDiagnosticsLinkStatus>();
            }
            this.links.addAll(links);
            return this;
        }

        public Builder addLinks(InterconnectDiagnosticsLinkStatus links) {
            if (this.links == null) {
                this.links = new LinkedList<InterconnectDiagnosticsLinkStatus>();
            }
            this.links.add(links);
            return this;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public Builder setMacAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public InterconnectDiagnostics build() {
            return new InterconnectDiagnostics(this.arpCaches, this.links, this.macAddress);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllArpCaches(this.arpCaches);
            newBuilder.addAllLinks(this.links);
            newBuilder.setMacAddress(this.macAddress);
            return newBuilder;
        }
    }
}

