/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Operation;
import com.google.cloud.Clock;
import com.google.cloud.WaitForOption;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ZoneOperationId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Operation
implements Serializable {
    private static final long serialVersionUID = -8979001444590023899L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private transient Compute compute;
    private final ComputeOptions options;
    private final String generatedId;
    private final OperationId operationId;
    private final String clientOperationId;
    private final String operationType;
    private final String targetLink;
    private final String targetId;
    private final Status status;
    private final String statusMessage;
    private final String user;
    private final Integer progress;
    private final Long insertTime;
    private final Long startTime;
    private final Long endTime;
    private final List<OperationError> errors;
    private final List<OperationWarning> warnings;
    private final Integer httpErrorStatusCode;
    private final String httpErrorMessage;
    private final String description;

    private Operation(Builder builder) {
        this.compute = (Compute)Preconditions.checkNotNull((Object)builder.compute);
        this.options = (ComputeOptions)this.compute.getOptions();
        this.generatedId = builder.generatedId;
        this.operationId = (OperationId)Preconditions.checkNotNull((Object)builder.operationId);
        this.clientOperationId = builder.clientOperationId;
        this.operationType = builder.operationType;
        this.targetLink = builder.targetLink;
        this.targetId = builder.targetId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.user = builder.user;
        this.progress = builder.progress;
        this.insertTime = builder.insertTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errors = builder.errors != null ? ImmutableList.copyOf((Collection)builder.errors) : null;
        this.warnings = builder.warnings != null ? ImmutableList.copyOf((Collection)builder.warnings) : null;
        this.httpErrorStatusCode = builder.httpErrorStatusCode;
        this.httpErrorMessage = builder.httpErrorMessage;
        this.description = builder.description;
    }

    public Compute getCompute() {
        return this.compute;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public <T extends OperationId> T getOperationId() {
        return (T)this.operationId;
    }

    String getClientOperationId() {
        return this.clientOperationId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getTargetLink() {
        return this.targetLink;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getUser() {
        return this.user;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public Long getInsertTime() {
        return this.insertTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public List<OperationError> getErrors() {
        return this.errors;
    }

    public List<OperationWarning> getWarnings() {
        return this.warnings;
    }

    public Integer getHttpErrorStatusCode() {
        return this.httpErrorStatusCode;
    }

    public String getHttpErrorMessage() {
        return this.httpErrorMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean exists() {
        return this.reload(Compute.OperationOption.fields(new Compute.OperationField[0])) != null;
    }

    public boolean isDone() {
        Operation operation = this.compute.getOperation(this.operationId, Compute.OperationOption.fields(Compute.OperationField.STATUS));
        return operation == null || operation.getStatus() == Status.DONE;
    }

    public Operation waitFor(WaitForOption ... waitOptions) throws InterruptedException, TimeoutException {
        WaitForOption.Timeout timeout = WaitForOption.Timeout.getOrDefault((WaitForOption[])waitOptions);
        WaitForOption.CheckingPeriod checkingPeriod = WaitForOption.CheckingPeriod.getOrDefault((WaitForOption[])waitOptions);
        long timeoutMillis = timeout.getTimeoutMillis();
        Clock clock = this.options.getClock();
        long startTime = clock.millis();
        while (!this.isDone()) {
            if (timeoutMillis != -1L && clock.millis() - startTime >= timeoutMillis) {
                throw new TimeoutException();
            }
            checkingPeriod.sleep();
        }
        return this.reload(new Compute.OperationOption[0]);
    }

    public Operation reload(Compute.OperationOption ... options) {
        return this.compute.getOperation(this.operationId, options);
    }

    public boolean delete() {
        return this.compute.deleteOperation(this.operationId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("operationsId", (Object)this.operationId).add("clientOperationId", (Object)this.clientOperationId).add("operationType", (Object)this.operationType).add("targetLink", (Object)this.targetLink).add("targetId", (Object)this.targetId).add("status", (Object)this.status).add("statusMessage", (Object)this.statusMessage).add("user", (Object)this.user).add("progress", (Object)this.progress).add("insertTime", (Object)this.insertTime).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("errors", this.errors).add("warnings", this.warnings).add("httpErrorStatusCode", (Object)this.httpErrorStatusCode).add("httpErrorMessage", (Object)this.httpErrorMessage).add("description", (Object)this.description).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.operationId);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Operation.class)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    com.google.api.services.compute.model.Operation toPb() {
        com.google.api.services.compute.model.Operation operationPb = new com.google.api.services.compute.model.Operation();
        if (this.generatedId != null) {
            operationPb.setId(new BigInteger(this.generatedId));
        }
        operationPb.setName(this.operationId.getOperation());
        operationPb.setClientOperationId(this.clientOperationId);
        switch (this.operationId.getType()) {
            case REGION: {
                operationPb.setRegion(((RegionOperationId)this.getOperationId()).getRegionId().getSelfLink());
                break;
            }
            case ZONE: {
                operationPb.setZone(((ZoneOperationId)this.getOperationId()).getZoneId().getSelfLink());
            }
        }
        if (this.operationType != null) {
            operationPb.setOperationType(this.operationType);
        }
        operationPb.setTargetLink(this.targetLink);
        if (this.targetId != null) {
            operationPb.setTargetId(new BigInteger(this.targetId));
        }
        if (this.status != null) {
            operationPb.setStatus(this.status.name());
        }
        operationPb.setStatusMessage(this.statusMessage);
        operationPb.setUser(this.user);
        operationPb.setProgress(this.progress);
        if (this.insertTime != null) {
            operationPb.setInsertTime(TIMESTAMP_FORMATTER.print(this.insertTime.longValue()));
        }
        if (this.startTime != null) {
            operationPb.setStartTime(TIMESTAMP_FORMATTER.print(this.startTime.longValue()));
        }
        if (this.endTime != null) {
            operationPb.setEndTime(TIMESTAMP_FORMATTER.print(this.endTime.longValue()));
        }
        if (this.errors != null) {
            operationPb.setError(new Operation.Error().setErrors(Lists.transform(this.errors, OperationError.TO_PB_FUNCTION)));
        }
        if (this.warnings != null) {
            operationPb.setWarnings(Lists.transform(this.warnings, OperationWarning.TO_PB_FUNCTION));
        }
        operationPb.setHttpErrorStatusCode(this.httpErrorStatusCode);
        operationPb.setHttpErrorMessage(this.httpErrorMessage);
        operationPb.setSelfLink(this.operationId.getSelfLink());
        operationPb.setDescription(this.description);
        return operationPb;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Operation fromPb(Compute compute, com.google.api.services.compute.model.Operation operationPb) {
        return new Builder(compute, operationPb).build();
    }

    static final class Builder {
        private Compute compute;
        private String generatedId;
        private OperationId operationId;
        private String clientOperationId;
        private String operationType;
        private String targetLink;
        private String targetId;
        private Status status;
        private String statusMessage;
        private String user;
        private Integer progress;
        private Long insertTime;
        private Long startTime;
        private Long endTime;
        private List<OperationError> errors;
        private List<OperationWarning> warnings;
        private Integer httpErrorStatusCode;
        private String httpErrorMessage;
        private String description;

        Builder(Compute compute) {
            this.compute = compute;
        }

        Builder(Compute compute, com.google.api.services.compute.model.Operation operationPb) {
            this.compute = compute;
            if (operationPb.getId() != null) {
                this.generatedId = operationPb.getId().toString();
            }
            this.operationId = RegionOperationId.matchesUrl(operationPb.getSelfLink()) ? RegionOperationId.fromUrl(operationPb.getSelfLink()) : (ZoneOperationId.matchesUrl(operationPb.getSelfLink()) ? ZoneOperationId.fromUrl(operationPb.getSelfLink()) : GlobalOperationId.fromUrl(operationPb.getSelfLink()));
            this.clientOperationId = operationPb.getClientOperationId();
            this.operationType = operationPb.getOperationType();
            this.targetLink = operationPb.getTargetLink();
            if (operationPb.getTargetId() != null) {
                this.targetId = operationPb.getTargetId().toString();
            }
            if (operationPb.getStatus() != null) {
                this.status = Status.valueOf(operationPb.getStatus());
            }
            this.statusMessage = operationPb.getStatusMessage();
            this.user = operationPb.getUser();
            this.progress = operationPb.getProgress();
            if (operationPb.getInsertTime() != null) {
                this.insertTime = TIMESTAMP_FORMATTER.parseMillis(operationPb.getInsertTime());
            }
            if (operationPb.getStartTime() != null) {
                this.startTime = TIMESTAMP_FORMATTER.parseMillis(operationPb.getStartTime());
            }
            if (operationPb.getEndTime() != null) {
                this.endTime = TIMESTAMP_FORMATTER.parseMillis(operationPb.getEndTime());
            }
            if (operationPb.getError() != null && operationPb.getError().getErrors() != null) {
                this.errors = Lists.transform((List)operationPb.getError().getErrors(), OperationError.FROM_PB_FUNCTION);
            }
            if (operationPb.getWarnings() != null) {
                this.warnings = Lists.transform((List)operationPb.getWarnings(), OperationWarning.FROM_PB_FUNCTION);
            }
            this.httpErrorStatusCode = operationPb.getHttpErrorStatusCode();
            this.httpErrorMessage = operationPb.getHttpErrorMessage();
            this.description = operationPb.getDescription();
        }

        Builder getGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setOperationId(OperationId operationId) {
            this.operationId = (OperationId)Preconditions.checkNotNull((Object)operationId);
            return this;
        }

        Builder setClientOperationId(String clientOperationId) {
            this.clientOperationId = clientOperationId;
            return this;
        }

        Builder setOperationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        Builder setTargetLink(String targetLink) {
            this.targetLink = targetLink;
            return this;
        }

        Builder setTargetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        Builder setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        Builder setUser(String user) {
            this.user = user;
            return this;
        }

        Builder setProgress(Integer progress) {
            this.progress = progress;
            return this;
        }

        Builder setInsertTime(Long insertTime) {
            this.insertTime = insertTime;
            return this;
        }

        Builder setStartTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        Builder setEndTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        Builder setErrors(List<OperationError> errors) {
            this.errors = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(errors)));
            return this;
        }

        Builder setWarnings(List<OperationWarning> warnings) {
            this.warnings = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(warnings)));
            return this;
        }

        Builder setHttpErrorStatusCode(Integer httpErrorStatusCode) {
            this.httpErrorStatusCode = httpErrorStatusCode;
            return this;
        }

        Builder setHttpErrorMessage(String httpErrorMessage) {
            this.httpErrorMessage = httpErrorMessage;
            return this;
        }

        Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        Operation build() {
            return new Operation(this);
        }
    }

    public static final class OperationWarning
    implements Serializable {
        static final Function<Operation.Warnings, OperationWarning> FROM_PB_FUNCTION = new Function<Operation.Warnings, OperationWarning>(){

            public OperationWarning apply(Operation.Warnings pb) {
                return OperationWarning.fromPb(pb);
            }
        };
        static final Function<OperationWarning, Operation.Warnings> TO_PB_FUNCTION = new Function<OperationWarning, Operation.Warnings>(){

            public Operation.Warnings apply(OperationWarning operation) {
                return operation.toPb();
            }
        };
        private static final long serialVersionUID = 4917326627380228928L;
        private final String code;
        private final String message;
        private final Map<String, String> metadata;

        OperationWarning(String code, String message, Map<String, String> metadata) {
            this.code = code;
            this.metadata = metadata != null ? ImmutableMap.copyOf(metadata) : null;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        Operation.Warnings toPb() {
            Operation.Warnings warningPb = new Operation.Warnings().setCode(this.code).setMessage(this.message);
            if (this.metadata != null) {
                ArrayList metadataPb = Lists.newArrayListWithCapacity((int)this.metadata.size());
                for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                    metadataPb.add(new Operation.Warnings.Data().setKey(entry.getKey()).setValue(entry.getValue()));
                }
                warningPb.setData((List)metadataPb);
            }
            return warningPb;
        }

        static OperationWarning fromPb(Operation.Warnings warningPb) {
            HashMap metadata = null;
            if (warningPb.getData() != null) {
                metadata = Maps.newHashMapWithExpectedSize((int)warningPb.getData().size());
                for (Operation.Warnings.Data data : warningPb.getData()) {
                    metadata.put(data.getKey(), data.getValue());
                }
            }
            return new OperationWarning(warningPb.getCode(), warningPb.getMessage(), metadata);
        }

        public boolean equals(Object obj) {
            return obj instanceof OperationWarning && Objects.equals(this.code, ((OperationWarning)obj).code) && Objects.equals(this.message, ((OperationWarning)obj).message) && Objects.equals(this.metadata, ((OperationWarning)obj).metadata);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("message", (Object)this.message).add("metadata", this.metadata).toString();
        }

        public int hashCode() {
            return Objects.hash(this.code, this.message, this.metadata);
        }
    }

    public static final class OperationError
    implements Serializable {
        static final Function<Operation.Error.Errors, OperationError> FROM_PB_FUNCTION = new Function<Operation.Error.Errors, OperationError>(){

            public OperationError apply(Operation.Error.Errors pb) {
                return OperationError.fromPb(pb);
            }
        };
        static final Function<OperationError, Operation.Error.Errors> TO_PB_FUNCTION = new Function<OperationError, Operation.Error.Errors>(){

            public Operation.Error.Errors apply(OperationError operation) {
                return operation.toPb();
            }
        };
        private static final long serialVersionUID = -1155314394806515873L;
        private final String code;
        private final String location;
        private final String message;

        OperationError(String code, String location, String message) {
            this.code = code;
            this.location = location;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMessage() {
            return this.message;
        }

        Operation.Error.Errors toPb() {
            return new Operation.Error.Errors().setCode(this.code).setLocation(this.location).setMessage(this.message);
        }

        static OperationError fromPb(Operation.Error.Errors errorPb) {
            return new OperationError(errorPb.getCode(), errorPb.getLocation(), errorPb.getMessage());
        }

        public boolean equals(Object obj) {
            return obj instanceof OperationError && Objects.equals(this.code, ((OperationError)obj).code) && Objects.equals(this.message, ((OperationError)obj).message) && Objects.equals(this.location, ((OperationError)obj).location);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("location", (Object)this.location).add("message", (Object)this.message).toString();
        }

        public int hashCode() {
            return Objects.hash(this.code, this.location, this.message);
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        DONE;

    }
}

