/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.AuditSettings;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkAuditRequest;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkAudit;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkAuditName;
import com.google.cloud.cloudsecuritycompliance.v1.GenerateFrameworkAuditScopeReportRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GenerateFrameworkAuditScopeReportResponse;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkAuditRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkAuditsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkAuditsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.LocationName;
import com.google.cloud.cloudsecuritycompliance.v1.OperationMetadata;
import com.google.cloud.cloudsecuritycompliance.v1.OrganizationLocationName;
import com.google.cloud.cloudsecuritycompliance.v1.stub.AuditStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.AuditStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AuditClient
implements BackgroundResource {
    private final AuditSettings settings;
    private final AuditStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AuditClient create() throws IOException {
        return AuditClient.create(AuditSettings.newBuilder().build());
    }

    public static final AuditClient create(AuditSettings settings) throws IOException {
        return new AuditClient(settings);
    }

    public static final AuditClient create(AuditStub stub) {
        return new AuditClient(stub);
    }

    protected AuditClient(AuditSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AuditStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AuditClient(AuditStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AuditSettings getSettings() {
        return this.settings;
    }

    public AuditStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final GenerateFrameworkAuditScopeReportResponse generateFrameworkAuditScopeReport(String scope, GenerateFrameworkAuditScopeReportRequest.Format reportFormat, String complianceFramework) {
        GenerateFrameworkAuditScopeReportRequest request = GenerateFrameworkAuditScopeReportRequest.newBuilder().setScope(scope).setReportFormat(reportFormat).setComplianceFramework(complianceFramework).build();
        return this.generateFrameworkAuditScopeReport(request);
    }

    public final GenerateFrameworkAuditScopeReportResponse generateFrameworkAuditScopeReport(GenerateFrameworkAuditScopeReportRequest request) {
        return (GenerateFrameworkAuditScopeReportResponse)this.generateFrameworkAuditScopeReportCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateFrameworkAuditScopeReportRequest, GenerateFrameworkAuditScopeReportResponse> generateFrameworkAuditScopeReportCallable() {
        return this.stub.generateFrameworkAuditScopeReportCallable();
    }

    public final OperationFuture<FrameworkAudit, OperationMetadata> createFrameworkAuditAsync(LocationName parent, FrameworkAudit frameworkAudit, String frameworkAuditId) {
        CreateFrameworkAuditRequest request = CreateFrameworkAuditRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFrameworkAudit(frameworkAudit).setFrameworkAuditId(frameworkAuditId).build();
        return this.createFrameworkAuditAsync(request);
    }

    public final OperationFuture<FrameworkAudit, OperationMetadata> createFrameworkAuditAsync(OrganizationLocationName parent, FrameworkAudit frameworkAudit, String frameworkAuditId) {
        CreateFrameworkAuditRequest request = CreateFrameworkAuditRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFrameworkAudit(frameworkAudit).setFrameworkAuditId(frameworkAuditId).build();
        return this.createFrameworkAuditAsync(request);
    }

    public final OperationFuture<FrameworkAudit, OperationMetadata> createFrameworkAuditAsync(String parent, FrameworkAudit frameworkAudit, String frameworkAuditId) {
        CreateFrameworkAuditRequest request = CreateFrameworkAuditRequest.newBuilder().setParent(parent).setFrameworkAudit(frameworkAudit).setFrameworkAuditId(frameworkAuditId).build();
        return this.createFrameworkAuditAsync(request);
    }

    public final OperationFuture<FrameworkAudit, OperationMetadata> createFrameworkAuditAsync(CreateFrameworkAuditRequest request) {
        return this.createFrameworkAuditOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFrameworkAuditRequest, FrameworkAudit, OperationMetadata> createFrameworkAuditOperationCallable() {
        return this.stub.createFrameworkAuditOperationCallable();
    }

    public final UnaryCallable<CreateFrameworkAuditRequest, Operation> createFrameworkAuditCallable() {
        return this.stub.createFrameworkAuditCallable();
    }

    public final ListFrameworkAuditsPagedResponse listFrameworkAudits(LocationName parent) {
        ListFrameworkAuditsRequest request = ListFrameworkAuditsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworkAudits(request);
    }

    public final ListFrameworkAuditsPagedResponse listFrameworkAudits(OrganizationLocationName parent) {
        ListFrameworkAuditsRequest request = ListFrameworkAuditsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworkAudits(request);
    }

    public final ListFrameworkAuditsPagedResponse listFrameworkAudits(String parent) {
        ListFrameworkAuditsRequest request = ListFrameworkAuditsRequest.newBuilder().setParent(parent).build();
        return this.listFrameworkAudits(request);
    }

    public final ListFrameworkAuditsPagedResponse listFrameworkAudits(ListFrameworkAuditsRequest request) {
        return (ListFrameworkAuditsPagedResponse)((Object)this.listFrameworkAuditsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFrameworkAuditsRequest, ListFrameworkAuditsPagedResponse> listFrameworkAuditsPagedCallable() {
        return this.stub.listFrameworkAuditsPagedCallable();
    }

    public final UnaryCallable<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse> listFrameworkAuditsCallable() {
        return this.stub.listFrameworkAuditsCallable();
    }

    public final FrameworkAudit getFrameworkAudit(FrameworkAuditName name) {
        GetFrameworkAuditRequest request = GetFrameworkAuditRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFrameworkAudit(request);
    }

    public final FrameworkAudit getFrameworkAudit(String name) {
        GetFrameworkAuditRequest request = GetFrameworkAuditRequest.newBuilder().setName(name).build();
        return this.getFrameworkAudit(request);
    }

    public final FrameworkAudit getFrameworkAudit(GetFrameworkAuditRequest request) {
        return (FrameworkAudit)this.getFrameworkAuditCallable().call((Object)request);
    }

    public final UnaryCallable<GetFrameworkAuditRequest, FrameworkAudit> getFrameworkAuditCallable() {
        return this.stub.getFrameworkAuditCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFrameworkAuditsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit, ListFrameworkAuditsPage, ListFrameworkAuditsFixedSizeCollection> {
        private ListFrameworkAuditsFixedSizeCollection(List<ListFrameworkAuditsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFrameworkAuditsFixedSizeCollection createEmptyCollection() {
            return new ListFrameworkAuditsFixedSizeCollection(null, 0);
        }

        protected ListFrameworkAuditsFixedSizeCollection createCollection(List<ListFrameworkAuditsPage> pages, int collectionSize) {
            return new ListFrameworkAuditsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFrameworkAuditsPage
    extends AbstractPage<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit, ListFrameworkAuditsPage> {
        private ListFrameworkAuditsPage(PageContext<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit> context, ListFrameworkAuditsResponse response) {
            super(context, (Object)response);
        }

        private static ListFrameworkAuditsPage createEmptyPage() {
            return new ListFrameworkAuditsPage(null, null);
        }

        protected ListFrameworkAuditsPage createPage(PageContext<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit> context, ListFrameworkAuditsResponse response) {
            return new ListFrameworkAuditsPage(context, response);
        }

        public ApiFuture<ListFrameworkAuditsPage> createPageAsync(PageContext<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit> context, ApiFuture<ListFrameworkAuditsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFrameworkAuditsPagedResponse
    extends AbstractPagedListResponse<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit, ListFrameworkAuditsPage, ListFrameworkAuditsFixedSizeCollection> {
        public static ApiFuture<ListFrameworkAuditsPagedResponse> createAsync(PageContext<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit> context, ApiFuture<ListFrameworkAuditsResponse> futureResponse) {
            ApiFuture<ListFrameworkAuditsPage> futurePage = ListFrameworkAuditsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFrameworkAuditsPagedResponse((ListFrameworkAuditsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFrameworkAuditsPagedResponse(ListFrameworkAuditsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFrameworkAuditsFixedSizeCollection.createEmptyCollection());
        }
    }
}

