/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControlDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeploymentClient;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.OperationMetadata;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.GrpcDeploymentStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.HttpJsonDeploymentStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeploymentStubSettings
extends StubSettings<DeploymentStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentSettings;
    private final OperationCallSettings<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationSettings;
    private final UnaryCallSettings<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentSettings;
    private final OperationCallSettings<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationSettings;
    private final UnaryCallSettings<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentSettings;
    private final PagedCallSettings<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsSettings;
    private final UnaryCallSettings<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentSettings;
    private final PagedCallSettings<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DeploymentClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment> LIST_FRAMEWORK_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListFrameworkDeploymentsRequest injectToken(ListFrameworkDeploymentsRequest payload, String token) {
            return ListFrameworkDeploymentsRequest.newBuilder((ListFrameworkDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListFrameworkDeploymentsRequest injectPageSize(ListFrameworkDeploymentsRequest payload, int pageSize) {
            return ListFrameworkDeploymentsRequest.newBuilder((ListFrameworkDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFrameworkDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFrameworkDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FrameworkDeployment> extractResources(ListFrameworkDeploymentsResponse payload) {
            return payload.getFrameworkDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment> LIST_CLOUD_CONTROL_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListCloudControlDeploymentsRequest injectToken(ListCloudControlDeploymentsRequest payload, String token) {
            return ListCloudControlDeploymentsRequest.newBuilder((ListCloudControlDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListCloudControlDeploymentsRequest injectPageSize(ListCloudControlDeploymentsRequest payload, int pageSize) {
            return ListCloudControlDeploymentsRequest.newBuilder((ListCloudControlDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCloudControlDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCloudControlDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CloudControlDeployment> extractResources(ListCloudControlDeploymentsResponse payload) {
            return payload.getCloudControlDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, DeploymentClient.ListFrameworkDeploymentsPagedResponse> LIST_FRAMEWORK_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, DeploymentClient.ListFrameworkDeploymentsPagedResponse>(){

        public ApiFuture<DeploymentClient.ListFrameworkDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> callable, ListFrameworkDeploymentsRequest request, ApiCallContext context, ApiFuture<ListFrameworkDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FRAMEWORK_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeploymentClient.ListFrameworkDeploymentsPagedResponse.createAsync((PageContext<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, DeploymentClient.ListCloudControlDeploymentsPagedResponse> LIST_CLOUD_CONTROL_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, DeploymentClient.ListCloudControlDeploymentsPagedResponse>(){

        public ApiFuture<DeploymentClient.ListCloudControlDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> callable, ListCloudControlDeploymentsRequest request, ApiCallContext context, ApiFuture<ListCloudControlDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLOUD_CONTROL_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeploymentClient.ListCloudControlDeploymentsPagedResponse.createAsync((PageContext<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DeploymentClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DeploymentClient.ListLocationsPagedResponse>(){

        public ApiFuture<DeploymentClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeploymentClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentSettings() {
        return this.createFrameworkDeploymentSettings;
    }

    public OperationCallSettings<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationSettings() {
        return this.createFrameworkDeploymentOperationSettings;
    }

    public UnaryCallSettings<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentSettings() {
        return this.deleteFrameworkDeploymentSettings;
    }

    public OperationCallSettings<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationSettings() {
        return this.deleteFrameworkDeploymentOperationSettings;
    }

    public UnaryCallSettings<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentSettings() {
        return this.getFrameworkDeploymentSettings;
    }

    public PagedCallSettings<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsSettings() {
        return this.listFrameworkDeploymentsSettings;
    }

    public UnaryCallSettings<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentSettings() {
        return this.getCloudControlDeploymentSettings;
    }

    public PagedCallSettings<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsSettings() {
        return this.listCloudControlDeploymentsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DeploymentClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DeploymentStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDeploymentStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDeploymentStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudsecuritycompliance";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudsecuritycompliance.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsecuritycompliance.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeploymentStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeploymentStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeploymentStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DeploymentStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeploymentStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createFrameworkDeploymentSettings = settingsBuilder.createFrameworkDeploymentSettings().build();
        this.createFrameworkDeploymentOperationSettings = settingsBuilder.createFrameworkDeploymentOperationSettings().build();
        this.deleteFrameworkDeploymentSettings = settingsBuilder.deleteFrameworkDeploymentSettings().build();
        this.deleteFrameworkDeploymentOperationSettings = settingsBuilder.deleteFrameworkDeploymentOperationSettings().build();
        this.getFrameworkDeploymentSettings = settingsBuilder.getFrameworkDeploymentSettings().build();
        this.listFrameworkDeploymentsSettings = settingsBuilder.listFrameworkDeploymentsSettings().build();
        this.getCloudControlDeploymentSettings = settingsBuilder.getCloudControlDeploymentSettings().build();
        this.listCloudControlDeploymentsSettings = settingsBuilder.listCloudControlDeploymentsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeploymentStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentSettings;
        private final OperationCallSettings.Builder<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentSettings;
        private final OperationCallSettings.Builder<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentSettings;
        private final PagedCallSettings.Builder<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsSettings;
        private final UnaryCallSettings.Builder<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentSettings;
        private final PagedCallSettings.Builder<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DeploymentClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createFrameworkDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFrameworkDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFrameworkDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFrameworkDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.getFrameworkDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFrameworkDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FRAMEWORK_DEPLOYMENTS_PAGE_STR_FACT);
            this.getCloudControlDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCloudControlDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLOUD_CONTROL_DEPLOYMENTS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFrameworkDeploymentSettings, this.deleteFrameworkDeploymentSettings, this.getFrameworkDeploymentSettings, this.listFrameworkDeploymentsSettings, this.getCloudControlDeploymentSettings, this.listCloudControlDeploymentsSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DeploymentStubSettings settings) {
            super((StubSettings)settings);
            this.createFrameworkDeploymentSettings = settings.createFrameworkDeploymentSettings.toBuilder();
            this.createFrameworkDeploymentOperationSettings = settings.createFrameworkDeploymentOperationSettings.toBuilder();
            this.deleteFrameworkDeploymentSettings = settings.deleteFrameworkDeploymentSettings.toBuilder();
            this.deleteFrameworkDeploymentOperationSettings = settings.deleteFrameworkDeploymentOperationSettings.toBuilder();
            this.getFrameworkDeploymentSettings = settings.getFrameworkDeploymentSettings.toBuilder();
            this.listFrameworkDeploymentsSettings = settings.listFrameworkDeploymentsSettings.toBuilder();
            this.getCloudControlDeploymentSettings = settings.getCloudControlDeploymentSettings.toBuilder();
            this.listCloudControlDeploymentsSettings = settings.listCloudControlDeploymentsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFrameworkDeploymentSettings, this.deleteFrameworkDeploymentSettings, this.getFrameworkDeploymentSettings, this.listFrameworkDeploymentsSettings, this.getCloudControlDeploymentSettings, this.listCloudControlDeploymentsSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeploymentStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeploymentStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeploymentStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeploymentStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DeploymentStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DeploymentStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeploymentStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeploymentStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createFrameworkDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteFrameworkDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getFrameworkDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listFrameworkDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCloudControlDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCloudControlDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFrameworkDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FrameworkDeployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteFrameworkDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentSettings() {
            return this.createFrameworkDeploymentSettings;
        }

        public OperationCallSettings.Builder<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationSettings() {
            return this.createFrameworkDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentSettings() {
            return this.deleteFrameworkDeploymentSettings;
        }

        public OperationCallSettings.Builder<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationSettings() {
            return this.deleteFrameworkDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentSettings() {
            return this.getFrameworkDeploymentSettings;
        }

        public PagedCallSettings.Builder<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsSettings() {
            return this.listFrameworkDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentSettings() {
            return this.getCloudControlDeploymentSettings;
        }

        public PagedCallSettings.Builder<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsSettings() {
            return this.listCloudControlDeploymentsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DeploymentClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DeploymentStubSettings build() throws IOException {
            return new DeploymentStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

