/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementServiceClient;
import com.google.cloud.commerce.consumer.procurement.v1.GetOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.Order;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderMetadata;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStubSettings;
import com.google.cloud.commerce.consumer.procurement.v1.stub.GrpcConsumerProcurementServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcConsumerProcurementServiceStub
extends ConsumerProcurementServiceStub {
    private static final MethodDescriptor<PlaceOrderRequest, Operation> placeOrderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/PlaceOrder").setRequestMarshaller(ProtoUtils.marshaller((Message)PlaceOrderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetOrderRequest, Order> getOrderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/GetOrder").setRequestMarshaller(ProtoUtils.marshaller((Message)GetOrderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Order.getDefaultInstance())).build();
    private static final MethodDescriptor<ListOrdersRequest, ListOrdersResponse> listOrdersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/ListOrders").setRequestMarshaller(ProtoUtils.marshaller((Message)ListOrdersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListOrdersResponse.getDefaultInstance())).build();
    private final UnaryCallable<PlaceOrderRequest, Operation> placeOrderCallable;
    private final OperationCallable<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationCallable;
    private final UnaryCallable<GetOrderRequest, Order> getOrderCallable;
    private final UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable;
    private final UnaryCallable<ListOrdersRequest, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConsumerProcurementServiceStub create(ConsumerProcurementServiceStubSettings settings) throws IOException {
        return new GrpcConsumerProcurementServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConsumerProcurementServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConsumerProcurementServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConsumerProcurementServiceCallableFactory());
    }

    protected GrpcConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings placeOrderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(placeOrderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getOrderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getOrderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listOrdersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listOrdersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.placeOrderCallable = callableFactory.createUnaryCallable(placeOrderTransportSettings, settings.placeOrderSettings(), clientContext);
        this.placeOrderOperationCallable = callableFactory.createOperationCallable(placeOrderTransportSettings, settings.placeOrderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getOrderCallable = callableFactory.createUnaryCallable(getOrderTransportSettings, settings.getOrderSettings(), clientContext);
        this.listOrdersCallable = callableFactory.createUnaryCallable(listOrdersTransportSettings, settings.listOrdersSettings(), clientContext);
        this.listOrdersPagedCallable = callableFactory.createPagedCallable(listOrdersTransportSettings, settings.listOrdersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<PlaceOrderRequest, Operation> placeOrderCallable() {
        return this.placeOrderCallable;
    }

    @Override
    public OperationCallable<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationCallable() {
        return this.placeOrderOperationCallable;
    }

    @Override
    public UnaryCallable<GetOrderRequest, Order> getOrderCallable() {
        return this.getOrderCallable;
    }

    @Override
    public UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable() {
        return this.listOrdersCallable;
    }

    @Override
    public UnaryCallable<ListOrdersRequest, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersPagedCallable() {
        return this.listOrdersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

