/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateRetrohuntRequest;
import com.google.cloud.chronicle.v1.CreateRuleRequest;
import com.google.cloud.chronicle.v1.DeleteRuleRequest;
import com.google.cloud.chronicle.v1.GetRetrohuntRequest;
import com.google.cloud.chronicle.v1.GetRuleDeploymentRequest;
import com.google.cloud.chronicle.v1.GetRuleRequest;
import com.google.cloud.chronicle.v1.ListRetrohuntsRequest;
import com.google.cloud.chronicle.v1.ListRetrohuntsResponse;
import com.google.cloud.chronicle.v1.ListRuleDeploymentsRequest;
import com.google.cloud.chronicle.v1.ListRuleDeploymentsResponse;
import com.google.cloud.chronicle.v1.ListRuleRevisionsRequest;
import com.google.cloud.chronicle.v1.ListRuleRevisionsResponse;
import com.google.cloud.chronicle.v1.ListRulesRequest;
import com.google.cloud.chronicle.v1.ListRulesResponse;
import com.google.cloud.chronicle.v1.Retrohunt;
import com.google.cloud.chronicle.v1.RetrohuntMetadata;
import com.google.cloud.chronicle.v1.Rule;
import com.google.cloud.chronicle.v1.RuleDeployment;
import com.google.cloud.chronicle.v1.RuleServiceClient;
import com.google.cloud.chronicle.v1.UpdateRuleDeploymentRequest;
import com.google.cloud.chronicle.v1.UpdateRuleRequest;
import com.google.cloud.chronicle.v1.stub.GrpcRuleServiceStub;
import com.google.cloud.chronicle.v1.stub.HttpJsonRuleServiceStub;
import com.google.cloud.chronicle.v1.stub.RuleServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RuleServiceStubSettings
extends StubSettings<RuleServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateRuleRequest, Rule> createRuleSettings;
    private final UnaryCallSettings<GetRuleRequest, Rule> getRuleSettings;
    private final PagedCallSettings<ListRulesRequest, ListRulesResponse, RuleServiceClient.ListRulesPagedResponse> listRulesSettings;
    private final UnaryCallSettings<UpdateRuleRequest, Rule> updateRuleSettings;
    private final UnaryCallSettings<DeleteRuleRequest, Empty> deleteRuleSettings;
    private final PagedCallSettings<ListRuleRevisionsRequest, ListRuleRevisionsResponse, RuleServiceClient.ListRuleRevisionsPagedResponse> listRuleRevisionsSettings;
    private final UnaryCallSettings<CreateRetrohuntRequest, Operation> createRetrohuntSettings;
    private final OperationCallSettings<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationSettings;
    private final UnaryCallSettings<GetRetrohuntRequest, Retrohunt> getRetrohuntSettings;
    private final PagedCallSettings<ListRetrohuntsRequest, ListRetrohuntsResponse, RuleServiceClient.ListRetrohuntsPagedResponse> listRetrohuntsSettings;
    private final UnaryCallSettings<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentSettings;
    private final PagedCallSettings<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleServiceClient.ListRuleDeploymentsPagedResponse> listRuleDeploymentsSettings;
    private final UnaryCallSettings<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentSettings;
    private static final PagedListDescriptor<ListRulesRequest, ListRulesResponse, Rule> LIST_RULES_PAGE_STR_DESC = new PagedListDescriptor<ListRulesRequest, ListRulesResponse, Rule>(){

        public String emptyToken() {
            return "";
        }

        public ListRulesRequest injectToken(ListRulesRequest payload, String token) {
            return ListRulesRequest.newBuilder((ListRulesRequest)payload).setPageToken(token).build();
        }

        public ListRulesRequest injectPageSize(ListRulesRequest payload, int pageSize) {
            return ListRulesRequest.newBuilder((ListRulesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRulesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRulesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Rule> extractResources(ListRulesResponse payload) {
            return payload.getRulesList();
        }
    };
    private static final PagedListDescriptor<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule> LIST_RULE_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule>(){

        public String emptyToken() {
            return "";
        }

        public ListRuleRevisionsRequest injectToken(ListRuleRevisionsRequest payload, String token) {
            return ListRuleRevisionsRequest.newBuilder((ListRuleRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListRuleRevisionsRequest injectPageSize(ListRuleRevisionsRequest payload, int pageSize) {
            return ListRuleRevisionsRequest.newBuilder((ListRuleRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRuleRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRuleRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Rule> extractResources(ListRuleRevisionsResponse payload) {
            return payload.getRulesList();
        }
    };
    private static final PagedListDescriptor<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt> LIST_RETROHUNTS_PAGE_STR_DESC = new PagedListDescriptor<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt>(){

        public String emptyToken() {
            return "";
        }

        public ListRetrohuntsRequest injectToken(ListRetrohuntsRequest payload, String token) {
            return ListRetrohuntsRequest.newBuilder((ListRetrohuntsRequest)payload).setPageToken(token).build();
        }

        public ListRetrohuntsRequest injectPageSize(ListRetrohuntsRequest payload, int pageSize) {
            return ListRetrohuntsRequest.newBuilder((ListRetrohuntsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRetrohuntsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRetrohuntsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Retrohunt> extractResources(ListRetrohuntsResponse payload) {
            return payload.getRetrohuntsList();
        }
    };
    private static final PagedListDescriptor<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment> LIST_RULE_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListRuleDeploymentsRequest injectToken(ListRuleDeploymentsRequest payload, String token) {
            return ListRuleDeploymentsRequest.newBuilder((ListRuleDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListRuleDeploymentsRequest injectPageSize(ListRuleDeploymentsRequest payload, int pageSize) {
            return ListRuleDeploymentsRequest.newBuilder((ListRuleDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRuleDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRuleDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RuleDeployment> extractResources(ListRuleDeploymentsResponse payload) {
            return payload.getRuleDeploymentsList();
        }
    };
    private static final PagedListResponseFactory<ListRulesRequest, ListRulesResponse, RuleServiceClient.ListRulesPagedResponse> LIST_RULES_PAGE_STR_FACT = new PagedListResponseFactory<ListRulesRequest, ListRulesResponse, RuleServiceClient.ListRulesPagedResponse>(){

        public ApiFuture<RuleServiceClient.ListRulesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRulesRequest, ListRulesResponse> callable, ListRulesRequest request, ApiCallContext context, ApiFuture<ListRulesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RULES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuleServiceClient.ListRulesPagedResponse.createAsync((PageContext<ListRulesRequest, ListRulesResponse, Rule>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRuleRevisionsRequest, ListRuleRevisionsResponse, RuleServiceClient.ListRuleRevisionsPagedResponse> LIST_RULE_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRuleRevisionsRequest, ListRuleRevisionsResponse, RuleServiceClient.ListRuleRevisionsPagedResponse>(){

        public ApiFuture<RuleServiceClient.ListRuleRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRuleRevisionsRequest, ListRuleRevisionsResponse> callable, ListRuleRevisionsRequest request, ApiCallContext context, ApiFuture<ListRuleRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RULE_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuleServiceClient.ListRuleRevisionsPagedResponse.createAsync((PageContext<ListRuleRevisionsRequest, ListRuleRevisionsResponse, Rule>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRetrohuntsRequest, ListRetrohuntsResponse, RuleServiceClient.ListRetrohuntsPagedResponse> LIST_RETROHUNTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRetrohuntsRequest, ListRetrohuntsResponse, RuleServiceClient.ListRetrohuntsPagedResponse>(){

        public ApiFuture<RuleServiceClient.ListRetrohuntsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRetrohuntsRequest, ListRetrohuntsResponse> callable, ListRetrohuntsRequest request, ApiCallContext context, ApiFuture<ListRetrohuntsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RETROHUNTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuleServiceClient.ListRetrohuntsPagedResponse.createAsync((PageContext<ListRetrohuntsRequest, ListRetrohuntsResponse, Retrohunt>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleServiceClient.ListRuleDeploymentsPagedResponse> LIST_RULE_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleServiceClient.ListRuleDeploymentsPagedResponse>(){

        public ApiFuture<RuleServiceClient.ListRuleDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse> callable, ListRuleDeploymentsRequest request, ApiCallContext context, ApiFuture<ListRuleDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RULE_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuleServiceClient.ListRuleDeploymentsPagedResponse.createAsync((PageContext<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleDeployment>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateRuleRequest, Rule> createRuleSettings() {
        return this.createRuleSettings;
    }

    public UnaryCallSettings<GetRuleRequest, Rule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public PagedCallSettings<ListRulesRequest, ListRulesResponse, RuleServiceClient.ListRulesPagedResponse> listRulesSettings() {
        return this.listRulesSettings;
    }

    public UnaryCallSettings<UpdateRuleRequest, Rule> updateRuleSettings() {
        return this.updateRuleSettings;
    }

    public UnaryCallSettings<DeleteRuleRequest, Empty> deleteRuleSettings() {
        return this.deleteRuleSettings;
    }

    public PagedCallSettings<ListRuleRevisionsRequest, ListRuleRevisionsResponse, RuleServiceClient.ListRuleRevisionsPagedResponse> listRuleRevisionsSettings() {
        return this.listRuleRevisionsSettings;
    }

    public UnaryCallSettings<CreateRetrohuntRequest, Operation> createRetrohuntSettings() {
        return this.createRetrohuntSettings;
    }

    public OperationCallSettings<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationSettings() {
        return this.createRetrohuntOperationSettings;
    }

    public UnaryCallSettings<GetRetrohuntRequest, Retrohunt> getRetrohuntSettings() {
        return this.getRetrohuntSettings;
    }

    public PagedCallSettings<ListRetrohuntsRequest, ListRetrohuntsResponse, RuleServiceClient.ListRetrohuntsPagedResponse> listRetrohuntsSettings() {
        return this.listRetrohuntsSettings;
    }

    public UnaryCallSettings<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentSettings() {
        return this.getRuleDeploymentSettings;
    }

    public PagedCallSettings<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleServiceClient.ListRuleDeploymentsPagedResponse> listRuleDeploymentsSettings() {
        return this.listRuleDeploymentsSettings;
    }

    public UnaryCallSettings<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentSettings() {
        return this.updateRuleDeploymentSettings;
    }

    public RuleServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRuleServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRuleServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "chronicle";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "chronicle.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "chronicle.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RuleServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RuleServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RuleServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RuleServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RuleServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createRuleSettings = settingsBuilder.createRuleSettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.listRulesSettings = settingsBuilder.listRulesSettings().build();
        this.updateRuleSettings = settingsBuilder.updateRuleSettings().build();
        this.deleteRuleSettings = settingsBuilder.deleteRuleSettings().build();
        this.listRuleRevisionsSettings = settingsBuilder.listRuleRevisionsSettings().build();
        this.createRetrohuntSettings = settingsBuilder.createRetrohuntSettings().build();
        this.createRetrohuntOperationSettings = settingsBuilder.createRetrohuntOperationSettings().build();
        this.getRetrohuntSettings = settingsBuilder.getRetrohuntSettings().build();
        this.listRetrohuntsSettings = settingsBuilder.listRetrohuntsSettings().build();
        this.getRuleDeploymentSettings = settingsBuilder.getRuleDeploymentSettings().build();
        this.listRuleDeploymentsSettings = settingsBuilder.listRuleDeploymentsSettings().build();
        this.updateRuleDeploymentSettings = settingsBuilder.updateRuleDeploymentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RuleServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateRuleRequest, Rule> createRuleSettings;
        private final UnaryCallSettings.Builder<GetRuleRequest, Rule> getRuleSettings;
        private final PagedCallSettings.Builder<ListRulesRequest, ListRulesResponse, RuleServiceClient.ListRulesPagedResponse> listRulesSettings;
        private final UnaryCallSettings.Builder<UpdateRuleRequest, Rule> updateRuleSettings;
        private final UnaryCallSettings.Builder<DeleteRuleRequest, Empty> deleteRuleSettings;
        private final PagedCallSettings.Builder<ListRuleRevisionsRequest, ListRuleRevisionsResponse, RuleServiceClient.ListRuleRevisionsPagedResponse> listRuleRevisionsSettings;
        private final UnaryCallSettings.Builder<CreateRetrohuntRequest, Operation> createRetrohuntSettings;
        private final OperationCallSettings.Builder<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationSettings;
        private final UnaryCallSettings.Builder<GetRetrohuntRequest, Retrohunt> getRetrohuntSettings;
        private final PagedCallSettings.Builder<ListRetrohuntsRequest, ListRetrohuntsResponse, RuleServiceClient.ListRetrohuntsPagedResponse> listRetrohuntsSettings;
        private final UnaryCallSettings.Builder<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentSettings;
        private final PagedCallSettings.Builder<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleServiceClient.ListRuleDeploymentsPagedResponse> listRuleDeploymentsSettings;
        private final UnaryCallSettings.Builder<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRulesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RULES_PAGE_STR_FACT);
            this.updateRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuleRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RULE_REVISIONS_PAGE_STR_FACT);
            this.createRetrohuntSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRetrohuntOperationSettings = OperationCallSettings.newBuilder();
            this.getRetrohuntSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRetrohuntsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RETROHUNTS_PAGE_STR_FACT);
            this.getRuleDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuleDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RULE_DEPLOYMENTS_PAGE_STR_FACT);
            this.updateRuleDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRuleSettings, this.getRuleSettings, this.listRulesSettings, this.updateRuleSettings, this.deleteRuleSettings, this.listRuleRevisionsSettings, this.createRetrohuntSettings, this.getRetrohuntSettings, this.listRetrohuntsSettings, this.getRuleDeploymentSettings, this.listRuleDeploymentsSettings, this.updateRuleDeploymentSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(RuleServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createRuleSettings = settings.createRuleSettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.listRulesSettings = settings.listRulesSettings.toBuilder();
            this.updateRuleSettings = settings.updateRuleSettings.toBuilder();
            this.deleteRuleSettings = settings.deleteRuleSettings.toBuilder();
            this.listRuleRevisionsSettings = settings.listRuleRevisionsSettings.toBuilder();
            this.createRetrohuntSettings = settings.createRetrohuntSettings.toBuilder();
            this.createRetrohuntOperationSettings = settings.createRetrohuntOperationSettings.toBuilder();
            this.getRetrohuntSettings = settings.getRetrohuntSettings.toBuilder();
            this.listRetrohuntsSettings = settings.listRetrohuntsSettings.toBuilder();
            this.getRuleDeploymentSettings = settings.getRuleDeploymentSettings.toBuilder();
            this.listRuleDeploymentsSettings = settings.listRuleDeploymentsSettings.toBuilder();
            this.updateRuleDeploymentSettings = settings.updateRuleDeploymentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRuleSettings, this.getRuleSettings, this.listRulesSettings, this.updateRuleSettings, this.deleteRuleSettings, this.listRuleRevisionsSettings, this.createRetrohuntSettings, this.getRetrohuntSettings, this.listRetrohuntsSettings, this.getRuleDeploymentSettings, this.listRuleDeploymentsSettings, this.updateRuleDeploymentSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RuleServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RuleServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RuleServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RuleServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RuleServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RuleServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RuleServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RuleServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.deleteRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listRuleRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.createRetrohuntSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.getRetrohuntSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRetrohuntsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listRuleDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateRuleDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.createRetrohuntOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Retrohunt.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RetrohuntMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(900000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateRuleRequest, Rule> createRuleSettings() {
            return this.createRuleSettings;
        }

        public UnaryCallSettings.Builder<GetRuleRequest, Rule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public PagedCallSettings.Builder<ListRulesRequest, ListRulesResponse, RuleServiceClient.ListRulesPagedResponse> listRulesSettings() {
            return this.listRulesSettings;
        }

        public UnaryCallSettings.Builder<UpdateRuleRequest, Rule> updateRuleSettings() {
            return this.updateRuleSettings;
        }

        public UnaryCallSettings.Builder<DeleteRuleRequest, Empty> deleteRuleSettings() {
            return this.deleteRuleSettings;
        }

        public PagedCallSettings.Builder<ListRuleRevisionsRequest, ListRuleRevisionsResponse, RuleServiceClient.ListRuleRevisionsPagedResponse> listRuleRevisionsSettings() {
            return this.listRuleRevisionsSettings;
        }

        public UnaryCallSettings.Builder<CreateRetrohuntRequest, Operation> createRetrohuntSettings() {
            return this.createRetrohuntSettings;
        }

        public OperationCallSettings.Builder<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationSettings() {
            return this.createRetrohuntOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRetrohuntRequest, Retrohunt> getRetrohuntSettings() {
            return this.getRetrohuntSettings;
        }

        public PagedCallSettings.Builder<ListRetrohuntsRequest, ListRetrohuntsResponse, RuleServiceClient.ListRetrohuntsPagedResponse> listRetrohuntsSettings() {
            return this.listRetrohuntsSettings;
        }

        public UnaryCallSettings.Builder<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentSettings() {
            return this.getRuleDeploymentSettings;
        }

        public PagedCallSettings.Builder<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse, RuleServiceClient.ListRuleDeploymentsPagedResponse> listRuleDeploymentsSettings() {
            return this.listRuleDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentSettings() {
            return this.updateRuleDeploymentSettings;
        }

        public RuleServiceStubSettings build() throws IOException {
            return new RuleServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(600000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_4_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

