/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.channel.v1.ActivateEntitlementRequest;
import com.google.cloud.channel.v1.CancelEntitlementRequest;
import com.google.cloud.channel.v1.ChangeOfferRequest;
import com.google.cloud.channel.v1.ChangeParametersRequest;
import com.google.cloud.channel.v1.ChangeRenewalSettingsRequest;
import com.google.cloud.channel.v1.ChannelPartnerLink;
import com.google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest;
import com.google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse;
import com.google.cloud.channel.v1.CloudChannelServiceSettings;
import com.google.cloud.channel.v1.CreateChannelPartnerLinkRequest;
import com.google.cloud.channel.v1.CreateCustomerRequest;
import com.google.cloud.channel.v1.CreateEntitlementRequest;
import com.google.cloud.channel.v1.Customer;
import com.google.cloud.channel.v1.CustomerName;
import com.google.cloud.channel.v1.DeleteCustomerRequest;
import com.google.cloud.channel.v1.Entitlement;
import com.google.cloud.channel.v1.GetChannelPartnerLinkRequest;
import com.google.cloud.channel.v1.GetCustomerRequest;
import com.google.cloud.channel.v1.GetEntitlementRequest;
import com.google.cloud.channel.v1.ListChannelPartnerLinksRequest;
import com.google.cloud.channel.v1.ListChannelPartnerLinksResponse;
import com.google.cloud.channel.v1.ListCustomersRequest;
import com.google.cloud.channel.v1.ListCustomersResponse;
import com.google.cloud.channel.v1.ListEntitlementsRequest;
import com.google.cloud.channel.v1.ListEntitlementsResponse;
import com.google.cloud.channel.v1.ListOffersRequest;
import com.google.cloud.channel.v1.ListOffersResponse;
import com.google.cloud.channel.v1.ListProductsRequest;
import com.google.cloud.channel.v1.ListProductsResponse;
import com.google.cloud.channel.v1.ListPurchasableOffersRequest;
import com.google.cloud.channel.v1.ListPurchasableOffersResponse;
import com.google.cloud.channel.v1.ListPurchasableSkusRequest;
import com.google.cloud.channel.v1.ListPurchasableSkusResponse;
import com.google.cloud.channel.v1.ListSkusRequest;
import com.google.cloud.channel.v1.ListSkusResponse;
import com.google.cloud.channel.v1.ListSubscribersRequest;
import com.google.cloud.channel.v1.ListSubscribersResponse;
import com.google.cloud.channel.v1.ListTransferableOffersRequest;
import com.google.cloud.channel.v1.ListTransferableOffersResponse;
import com.google.cloud.channel.v1.ListTransferableSkusRequest;
import com.google.cloud.channel.v1.ListTransferableSkusResponse;
import com.google.cloud.channel.v1.LookupOfferRequest;
import com.google.cloud.channel.v1.Offer;
import com.google.cloud.channel.v1.OperationMetadata;
import com.google.cloud.channel.v1.Product;
import com.google.cloud.channel.v1.ProvisionCloudIdentityRequest;
import com.google.cloud.channel.v1.PurchasableOffer;
import com.google.cloud.channel.v1.PurchasableSku;
import com.google.cloud.channel.v1.RegisterSubscriberRequest;
import com.google.cloud.channel.v1.RegisterSubscriberResponse;
import com.google.cloud.channel.v1.Sku;
import com.google.cloud.channel.v1.StartPaidServiceRequest;
import com.google.cloud.channel.v1.SuspendEntitlementRequest;
import com.google.cloud.channel.v1.TransferEntitlementsRequest;
import com.google.cloud.channel.v1.TransferEntitlementsResponse;
import com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest;
import com.google.cloud.channel.v1.TransferableOffer;
import com.google.cloud.channel.v1.TransferableSku;
import com.google.cloud.channel.v1.UnregisterSubscriberRequest;
import com.google.cloud.channel.v1.UnregisterSubscriberResponse;
import com.google.cloud.channel.v1.UpdateChannelPartnerLinkRequest;
import com.google.cloud.channel.v1.UpdateCustomerRequest;
import com.google.cloud.channel.v1.stub.CloudChannelServiceStub;
import com.google.cloud.channel.v1.stub.CloudChannelServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudChannelServiceClient
implements BackgroundResource {
    private final CloudChannelServiceSettings settings;
    private final CloudChannelServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CloudChannelServiceClient create() throws IOException {
        return CloudChannelServiceClient.create(CloudChannelServiceSettings.newBuilder().build());
    }

    public static final CloudChannelServiceClient create(CloudChannelServiceSettings settings) throws IOException {
        return new CloudChannelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudChannelServiceClient create(CloudChannelServiceStub stub) {
        return new CloudChannelServiceClient(stub);
    }

    protected CloudChannelServiceClient(CloudChannelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudChannelServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudChannelServiceClient(CloudChannelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CloudChannelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudChannelServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListCustomersPagedResponse listCustomers(ListCustomersRequest request) {
        return (ListCustomersPagedResponse)((Object)this.listCustomersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomersRequest, ListCustomersPagedResponse> listCustomersPagedCallable() {
        return this.stub.listCustomersPagedCallable();
    }

    public final UnaryCallable<ListCustomersRequest, ListCustomersResponse> listCustomersCallable() {
        return this.stub.listCustomersCallable();
    }

    public final Customer getCustomer(CustomerName name) {
        GetCustomerRequest request = GetCustomerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomer(request);
    }

    public final Customer getCustomer(String name) {
        GetCustomerRequest request = GetCustomerRequest.newBuilder().setName(name).build();
        return this.getCustomer(request);
    }

    public final Customer getCustomer(GetCustomerRequest request) {
        return (Customer)this.getCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerRequest, Customer> getCustomerCallable() {
        return this.stub.getCustomerCallable();
    }

    public final CheckCloudIdentityAccountsExistResponse checkCloudIdentityAccountsExist(CheckCloudIdentityAccountsExistRequest request) {
        return (CheckCloudIdentityAccountsExistResponse)this.checkCloudIdentityAccountsExistCallable().call((Object)request);
    }

    public final UnaryCallable<CheckCloudIdentityAccountsExistRequest, CheckCloudIdentityAccountsExistResponse> checkCloudIdentityAccountsExistCallable() {
        return this.stub.checkCloudIdentityAccountsExistCallable();
    }

    public final Customer createCustomer(CreateCustomerRequest request) {
        return (Customer)this.createCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomerRequest, Customer> createCustomerCallable() {
        return this.stub.createCustomerCallable();
    }

    public final Customer updateCustomer(UpdateCustomerRequest request) {
        return (Customer)this.updateCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCustomerRequest, Customer> updateCustomerCallable() {
        return this.stub.updateCustomerCallable();
    }

    public final void deleteCustomer(CustomerName name) {
        DeleteCustomerRequest request = DeleteCustomerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCustomer(request);
    }

    public final void deleteCustomer(String name) {
        DeleteCustomerRequest request = DeleteCustomerRequest.newBuilder().setName(name).build();
        this.deleteCustomer(request);
    }

    public final void deleteCustomer(DeleteCustomerRequest request) {
        this.deleteCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCustomerRequest, Empty> deleteCustomerCallable() {
        return this.stub.deleteCustomerCallable();
    }

    public final OperationFuture<Customer, OperationMetadata> provisionCloudIdentityAsync(ProvisionCloudIdentityRequest request) {
        return this.provisionCloudIdentityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ProvisionCloudIdentityRequest, Customer, OperationMetadata> provisionCloudIdentityOperationCallable() {
        return this.stub.provisionCloudIdentityOperationCallable();
    }

    public final UnaryCallable<ProvisionCloudIdentityRequest, Operation> provisionCloudIdentityCallable() {
        return this.stub.provisionCloudIdentityCallable();
    }

    public final ListEntitlementsPagedResponse listEntitlements(ListEntitlementsRequest request) {
        return (ListEntitlementsPagedResponse)((Object)this.listEntitlementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsPagedResponse> listEntitlementsPagedCallable() {
        return this.stub.listEntitlementsPagedCallable();
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> listEntitlementsCallable() {
        return this.stub.listEntitlementsCallable();
    }

    public final ListTransferableSkusPagedResponse listTransferableSkus(ListTransferableSkusRequest request) {
        return (ListTransferableSkusPagedResponse)((Object)this.listTransferableSkusPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferableSkusRequest, ListTransferableSkusPagedResponse> listTransferableSkusPagedCallable() {
        return this.stub.listTransferableSkusPagedCallable();
    }

    public final UnaryCallable<ListTransferableSkusRequest, ListTransferableSkusResponse> listTransferableSkusCallable() {
        return this.stub.listTransferableSkusCallable();
    }

    public final ListTransferableOffersPagedResponse listTransferableOffers(ListTransferableOffersRequest request) {
        return (ListTransferableOffersPagedResponse)((Object)this.listTransferableOffersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferableOffersRequest, ListTransferableOffersPagedResponse> listTransferableOffersPagedCallable() {
        return this.stub.listTransferableOffersPagedCallable();
    }

    public final UnaryCallable<ListTransferableOffersRequest, ListTransferableOffersResponse> listTransferableOffersCallable() {
        return this.stub.listTransferableOffersCallable();
    }

    public final Entitlement getEntitlement(GetEntitlementRequest request) {
        return (Entitlement)this.getEntitlementCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntitlementRequest, Entitlement> getEntitlementCallable() {
        return this.stub.getEntitlementCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> createEntitlementAsync(CreateEntitlementRequest request) {
        return this.createEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationCallable() {
        return this.stub.createEntitlementOperationCallable();
    }

    public final UnaryCallable<CreateEntitlementRequest, Operation> createEntitlementCallable() {
        return this.stub.createEntitlementCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> changeParametersAsync(ChangeParametersRequest request) {
        return this.changeParametersOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ChangeParametersRequest, Entitlement, OperationMetadata> changeParametersOperationCallable() {
        return this.stub.changeParametersOperationCallable();
    }

    public final UnaryCallable<ChangeParametersRequest, Operation> changeParametersCallable() {
        return this.stub.changeParametersCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> changeRenewalSettingsAsync(ChangeRenewalSettingsRequest request) {
        return this.changeRenewalSettingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ChangeRenewalSettingsRequest, Entitlement, OperationMetadata> changeRenewalSettingsOperationCallable() {
        return this.stub.changeRenewalSettingsOperationCallable();
    }

    public final UnaryCallable<ChangeRenewalSettingsRequest, Operation> changeRenewalSettingsCallable() {
        return this.stub.changeRenewalSettingsCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> changeOfferAsync(ChangeOfferRequest request) {
        return this.changeOfferOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ChangeOfferRequest, Entitlement, OperationMetadata> changeOfferOperationCallable() {
        return this.stub.changeOfferOperationCallable();
    }

    public final UnaryCallable<ChangeOfferRequest, Operation> changeOfferCallable() {
        return this.stub.changeOfferCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> startPaidServiceAsync(StartPaidServiceRequest request) {
        return this.startPaidServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartPaidServiceRequest, Entitlement, OperationMetadata> startPaidServiceOperationCallable() {
        return this.stub.startPaidServiceOperationCallable();
    }

    public final UnaryCallable<StartPaidServiceRequest, Operation> startPaidServiceCallable() {
        return this.stub.startPaidServiceCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> suspendEntitlementAsync(SuspendEntitlementRequest request) {
        return this.suspendEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SuspendEntitlementRequest, Entitlement, OperationMetadata> suspendEntitlementOperationCallable() {
        return this.stub.suspendEntitlementOperationCallable();
    }

    public final UnaryCallable<SuspendEntitlementRequest, Operation> suspendEntitlementCallable() {
        return this.stub.suspendEntitlementCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> cancelEntitlementAsync(CancelEntitlementRequest request) {
        return this.cancelEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelEntitlementRequest, Empty, OperationMetadata> cancelEntitlementOperationCallable() {
        return this.stub.cancelEntitlementOperationCallable();
    }

    public final UnaryCallable<CancelEntitlementRequest, Operation> cancelEntitlementCallable() {
        return this.stub.cancelEntitlementCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> activateEntitlementAsync(ActivateEntitlementRequest request) {
        return this.activateEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ActivateEntitlementRequest, Entitlement, OperationMetadata> activateEntitlementOperationCallable() {
        return this.stub.activateEntitlementOperationCallable();
    }

    public final UnaryCallable<ActivateEntitlementRequest, Operation> activateEntitlementCallable() {
        return this.stub.activateEntitlementCallable();
    }

    public final OperationFuture<TransferEntitlementsResponse, OperationMetadata> transferEntitlementsAsync(TransferEntitlementsRequest request) {
        return this.transferEntitlementsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TransferEntitlementsRequest, TransferEntitlementsResponse, OperationMetadata> transferEntitlementsOperationCallable() {
        return this.stub.transferEntitlementsOperationCallable();
    }

    public final UnaryCallable<TransferEntitlementsRequest, Operation> transferEntitlementsCallable() {
        return this.stub.transferEntitlementsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> transferEntitlementsToGoogleAsync(TransferEntitlementsToGoogleRequest request) {
        return this.transferEntitlementsToGoogleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TransferEntitlementsToGoogleRequest, Empty, OperationMetadata> transferEntitlementsToGoogleOperationCallable() {
        return this.stub.transferEntitlementsToGoogleOperationCallable();
    }

    public final UnaryCallable<TransferEntitlementsToGoogleRequest, Operation> transferEntitlementsToGoogleCallable() {
        return this.stub.transferEntitlementsToGoogleCallable();
    }

    public final ListChannelPartnerLinksPagedResponse listChannelPartnerLinks(ListChannelPartnerLinksRequest request) {
        return (ListChannelPartnerLinksPagedResponse)((Object)this.listChannelPartnerLinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChannelPartnerLinksRequest, ListChannelPartnerLinksPagedResponse> listChannelPartnerLinksPagedCallable() {
        return this.stub.listChannelPartnerLinksPagedCallable();
    }

    public final UnaryCallable<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse> listChannelPartnerLinksCallable() {
        return this.stub.listChannelPartnerLinksCallable();
    }

    public final ChannelPartnerLink getChannelPartnerLink(GetChannelPartnerLinkRequest request) {
        return (ChannelPartnerLink)this.getChannelPartnerLinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetChannelPartnerLinkRequest, ChannelPartnerLink> getChannelPartnerLinkCallable() {
        return this.stub.getChannelPartnerLinkCallable();
    }

    public final ChannelPartnerLink createChannelPartnerLink(CreateChannelPartnerLinkRequest request) {
        return (ChannelPartnerLink)this.createChannelPartnerLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateChannelPartnerLinkRequest, ChannelPartnerLink> createChannelPartnerLinkCallable() {
        return this.stub.createChannelPartnerLinkCallable();
    }

    public final ChannelPartnerLink updateChannelPartnerLink(UpdateChannelPartnerLinkRequest request) {
        return (ChannelPartnerLink)this.updateChannelPartnerLinkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateChannelPartnerLinkRequest, ChannelPartnerLink> updateChannelPartnerLinkCallable() {
        return this.stub.updateChannelPartnerLinkCallable();
    }

    public final Offer lookupOffer(LookupOfferRequest request) {
        return (Offer)this.lookupOfferCallable().call((Object)request);
    }

    public final UnaryCallable<LookupOfferRequest, Offer> lookupOfferCallable() {
        return this.stub.lookupOfferCallable();
    }

    public final ListProductsPagedResponse listProducts(ListProductsRequest request) {
        return (ListProductsPagedResponse)((Object)this.listProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsRequest, ListProductsPagedResponse> listProductsPagedCallable() {
        return this.stub.listProductsPagedCallable();
    }

    public final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.stub.listProductsCallable();
    }

    public final ListSkusPagedResponse listSkus(ListSkusRequest request) {
        return (ListSkusPagedResponse)((Object)this.listSkusPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSkusRequest, ListSkusPagedResponse> listSkusPagedCallable() {
        return this.stub.listSkusPagedCallable();
    }

    public final UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable() {
        return this.stub.listSkusCallable();
    }

    public final ListOffersPagedResponse listOffers(ListOffersRequest request) {
        return (ListOffersPagedResponse)((Object)this.listOffersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOffersRequest, ListOffersPagedResponse> listOffersPagedCallable() {
        return this.stub.listOffersPagedCallable();
    }

    public final UnaryCallable<ListOffersRequest, ListOffersResponse> listOffersCallable() {
        return this.stub.listOffersCallable();
    }

    public final ListPurchasableSkusPagedResponse listPurchasableSkus(ListPurchasableSkusRequest request) {
        return (ListPurchasableSkusPagedResponse)((Object)this.listPurchasableSkusPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPurchasableSkusRequest, ListPurchasableSkusPagedResponse> listPurchasableSkusPagedCallable() {
        return this.stub.listPurchasableSkusPagedCallable();
    }

    public final UnaryCallable<ListPurchasableSkusRequest, ListPurchasableSkusResponse> listPurchasableSkusCallable() {
        return this.stub.listPurchasableSkusCallable();
    }

    public final ListPurchasableOffersPagedResponse listPurchasableOffers(ListPurchasableOffersRequest request) {
        return (ListPurchasableOffersPagedResponse)((Object)this.listPurchasableOffersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPurchasableOffersRequest, ListPurchasableOffersPagedResponse> listPurchasableOffersPagedCallable() {
        return this.stub.listPurchasableOffersPagedCallable();
    }

    public final UnaryCallable<ListPurchasableOffersRequest, ListPurchasableOffersResponse> listPurchasableOffersCallable() {
        return this.stub.listPurchasableOffersCallable();
    }

    public final RegisterSubscriberResponse registerSubscriber(RegisterSubscriberRequest request) {
        return (RegisterSubscriberResponse)this.registerSubscriberCallable().call((Object)request);
    }

    public final UnaryCallable<RegisterSubscriberRequest, RegisterSubscriberResponse> registerSubscriberCallable() {
        return this.stub.registerSubscriberCallable();
    }

    public final UnregisterSubscriberResponse unregisterSubscriber(UnregisterSubscriberRequest request) {
        return (UnregisterSubscriberResponse)this.unregisterSubscriberCallable().call((Object)request);
    }

    public final UnaryCallable<UnregisterSubscriberRequest, UnregisterSubscriberResponse> unregisterSubscriberCallable() {
        return this.stub.unregisterSubscriberCallable();
    }

    public final ListSubscribersPagedResponse listSubscribers(ListSubscribersRequest request) {
        return (ListSubscribersPagedResponse)((Object)this.listSubscribersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubscribersRequest, ListSubscribersPagedResponse> listSubscribersPagedCallable() {
        return this.stub.listSubscribersPagedCallable();
    }

    public final UnaryCallable<ListSubscribersRequest, ListSubscribersResponse> listSubscribersCallable() {
        return this.stub.listSubscribersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSubscribersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubscribersRequest, ListSubscribersResponse, String, ListSubscribersPage, ListSubscribersFixedSizeCollection> {
        private ListSubscribersFixedSizeCollection(List<ListSubscribersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubscribersFixedSizeCollection createEmptyCollection() {
            return new ListSubscribersFixedSizeCollection(null, 0);
        }

        protected ListSubscribersFixedSizeCollection createCollection(List<ListSubscribersPage> pages, int collectionSize) {
            return new ListSubscribersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubscribersPage
    extends AbstractPage<ListSubscribersRequest, ListSubscribersResponse, String, ListSubscribersPage> {
        private ListSubscribersPage(PageContext<ListSubscribersRequest, ListSubscribersResponse, String> context, ListSubscribersResponse response) {
            super(context, (Object)response);
        }

        private static ListSubscribersPage createEmptyPage() {
            return new ListSubscribersPage(null, null);
        }

        protected ListSubscribersPage createPage(PageContext<ListSubscribersRequest, ListSubscribersResponse, String> context, ListSubscribersResponse response) {
            return new ListSubscribersPage(context, response);
        }

        public ApiFuture<ListSubscribersPage> createPageAsync(PageContext<ListSubscribersRequest, ListSubscribersResponse, String> context, ApiFuture<ListSubscribersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubscribersPagedResponse
    extends AbstractPagedListResponse<ListSubscribersRequest, ListSubscribersResponse, String, ListSubscribersPage, ListSubscribersFixedSizeCollection> {
        public static ApiFuture<ListSubscribersPagedResponse> createAsync(PageContext<ListSubscribersRequest, ListSubscribersResponse, String> context, ApiFuture<ListSubscribersResponse> futureResponse) {
            ApiFuture<ListSubscribersPage> futurePage = ListSubscribersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSubscribersPagedResponse((ListSubscribersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSubscribersPagedResponse(ListSubscribersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubscribersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPurchasableOffersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer, ListPurchasableOffersPage, ListPurchasableOffersFixedSizeCollection> {
        private ListPurchasableOffersFixedSizeCollection(List<ListPurchasableOffersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPurchasableOffersFixedSizeCollection createEmptyCollection() {
            return new ListPurchasableOffersFixedSizeCollection(null, 0);
        }

        protected ListPurchasableOffersFixedSizeCollection createCollection(List<ListPurchasableOffersPage> pages, int collectionSize) {
            return new ListPurchasableOffersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPurchasableOffersPage
    extends AbstractPage<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer, ListPurchasableOffersPage> {
        private ListPurchasableOffersPage(PageContext<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer> context, ListPurchasableOffersResponse response) {
            super(context, (Object)response);
        }

        private static ListPurchasableOffersPage createEmptyPage() {
            return new ListPurchasableOffersPage(null, null);
        }

        protected ListPurchasableOffersPage createPage(PageContext<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer> context, ListPurchasableOffersResponse response) {
            return new ListPurchasableOffersPage(context, response);
        }

        public ApiFuture<ListPurchasableOffersPage> createPageAsync(PageContext<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer> context, ApiFuture<ListPurchasableOffersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPurchasableOffersPagedResponse
    extends AbstractPagedListResponse<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer, ListPurchasableOffersPage, ListPurchasableOffersFixedSizeCollection> {
        public static ApiFuture<ListPurchasableOffersPagedResponse> createAsync(PageContext<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer> context, ApiFuture<ListPurchasableOffersResponse> futureResponse) {
            ApiFuture<ListPurchasableOffersPage> futurePage = ListPurchasableOffersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPurchasableOffersPagedResponse((ListPurchasableOffersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPurchasableOffersPagedResponse(ListPurchasableOffersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPurchasableOffersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPurchasableSkusFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku, ListPurchasableSkusPage, ListPurchasableSkusFixedSizeCollection> {
        private ListPurchasableSkusFixedSizeCollection(List<ListPurchasableSkusPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPurchasableSkusFixedSizeCollection createEmptyCollection() {
            return new ListPurchasableSkusFixedSizeCollection(null, 0);
        }

        protected ListPurchasableSkusFixedSizeCollection createCollection(List<ListPurchasableSkusPage> pages, int collectionSize) {
            return new ListPurchasableSkusFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPurchasableSkusPage
    extends AbstractPage<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku, ListPurchasableSkusPage> {
        private ListPurchasableSkusPage(PageContext<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku> context, ListPurchasableSkusResponse response) {
            super(context, (Object)response);
        }

        private static ListPurchasableSkusPage createEmptyPage() {
            return new ListPurchasableSkusPage(null, null);
        }

        protected ListPurchasableSkusPage createPage(PageContext<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku> context, ListPurchasableSkusResponse response) {
            return new ListPurchasableSkusPage(context, response);
        }

        public ApiFuture<ListPurchasableSkusPage> createPageAsync(PageContext<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku> context, ApiFuture<ListPurchasableSkusResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPurchasableSkusPagedResponse
    extends AbstractPagedListResponse<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku, ListPurchasableSkusPage, ListPurchasableSkusFixedSizeCollection> {
        public static ApiFuture<ListPurchasableSkusPagedResponse> createAsync(PageContext<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku> context, ApiFuture<ListPurchasableSkusResponse> futureResponse) {
            ApiFuture<ListPurchasableSkusPage> futurePage = ListPurchasableSkusPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPurchasableSkusPagedResponse((ListPurchasableSkusPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPurchasableSkusPagedResponse(ListPurchasableSkusPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPurchasableSkusFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOffersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOffersRequest, ListOffersResponse, Offer, ListOffersPage, ListOffersFixedSizeCollection> {
        private ListOffersFixedSizeCollection(List<ListOffersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOffersFixedSizeCollection createEmptyCollection() {
            return new ListOffersFixedSizeCollection(null, 0);
        }

        protected ListOffersFixedSizeCollection createCollection(List<ListOffersPage> pages, int collectionSize) {
            return new ListOffersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOffersPage
    extends AbstractPage<ListOffersRequest, ListOffersResponse, Offer, ListOffersPage> {
        private ListOffersPage(PageContext<ListOffersRequest, ListOffersResponse, Offer> context, ListOffersResponse response) {
            super(context, (Object)response);
        }

        private static ListOffersPage createEmptyPage() {
            return new ListOffersPage(null, null);
        }

        protected ListOffersPage createPage(PageContext<ListOffersRequest, ListOffersResponse, Offer> context, ListOffersResponse response) {
            return new ListOffersPage(context, response);
        }

        public ApiFuture<ListOffersPage> createPageAsync(PageContext<ListOffersRequest, ListOffersResponse, Offer> context, ApiFuture<ListOffersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOffersPagedResponse
    extends AbstractPagedListResponse<ListOffersRequest, ListOffersResponse, Offer, ListOffersPage, ListOffersFixedSizeCollection> {
        public static ApiFuture<ListOffersPagedResponse> createAsync(PageContext<ListOffersRequest, ListOffersResponse, Offer> context, ApiFuture<ListOffersResponse> futureResponse) {
            ApiFuture<ListOffersPage> futurePage = ListOffersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOffersPagedResponse((ListOffersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOffersPagedResponse(ListOffersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOffersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSkusFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage, ListSkusFixedSizeCollection> {
        private ListSkusFixedSizeCollection(List<ListSkusPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSkusFixedSizeCollection createEmptyCollection() {
            return new ListSkusFixedSizeCollection(null, 0);
        }

        protected ListSkusFixedSizeCollection createCollection(List<ListSkusPage> pages, int collectionSize) {
            return new ListSkusFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSkusPage
    extends AbstractPage<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage> {
        private ListSkusPage(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ListSkusResponse response) {
            super(context, (Object)response);
        }

        private static ListSkusPage createEmptyPage() {
            return new ListSkusPage(null, null);
        }

        protected ListSkusPage createPage(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ListSkusResponse response) {
            return new ListSkusPage(context, response);
        }

        public ApiFuture<ListSkusPage> createPageAsync(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ApiFuture<ListSkusResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSkusPagedResponse
    extends AbstractPagedListResponse<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage, ListSkusFixedSizeCollection> {
        public static ApiFuture<ListSkusPagedResponse> createAsync(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ApiFuture<ListSkusResponse> futureResponse) {
            ApiFuture<ListSkusPage> futurePage = ListSkusPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSkusPagedResponse((ListSkusPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSkusPagedResponse(ListSkusPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSkusFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        private ListProductsFixedSizeCollection(List<ListProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsFixedSizeCollection createEmptyCollection() {
            return new ListProductsFixedSizeCollection(null, 0);
        }

        protected ListProductsFixedSizeCollection createCollection(List<ListProductsPage> pages, int collectionSize) {
            return new ListProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsPage
    extends AbstractPage<ListProductsRequest, ListProductsResponse, Product, ListProductsPage> {
        private ListProductsPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsPage createEmptyPage() {
            return new ListProductsPage(null, null);
        }

        protected ListProductsPage createPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            return new ListProductsPage(context, response);
        }

        public ApiFuture<ListProductsPage> createPageAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsPagedResponse
    extends AbstractPagedListResponse<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        public static ApiFuture<ListProductsPagedResponse> createAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            ApiFuture<ListProductsPage> futurePage = ListProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProductsPagedResponse((ListProductsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProductsPagedResponse(ListProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChannelPartnerLinksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink, ListChannelPartnerLinksPage, ListChannelPartnerLinksFixedSizeCollection> {
        private ListChannelPartnerLinksFixedSizeCollection(List<ListChannelPartnerLinksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChannelPartnerLinksFixedSizeCollection createEmptyCollection() {
            return new ListChannelPartnerLinksFixedSizeCollection(null, 0);
        }

        protected ListChannelPartnerLinksFixedSizeCollection createCollection(List<ListChannelPartnerLinksPage> pages, int collectionSize) {
            return new ListChannelPartnerLinksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChannelPartnerLinksPage
    extends AbstractPage<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink, ListChannelPartnerLinksPage> {
        private ListChannelPartnerLinksPage(PageContext<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink> context, ListChannelPartnerLinksResponse response) {
            super(context, (Object)response);
        }

        private static ListChannelPartnerLinksPage createEmptyPage() {
            return new ListChannelPartnerLinksPage(null, null);
        }

        protected ListChannelPartnerLinksPage createPage(PageContext<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink> context, ListChannelPartnerLinksResponse response) {
            return new ListChannelPartnerLinksPage(context, response);
        }

        public ApiFuture<ListChannelPartnerLinksPage> createPageAsync(PageContext<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink> context, ApiFuture<ListChannelPartnerLinksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChannelPartnerLinksPagedResponse
    extends AbstractPagedListResponse<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink, ListChannelPartnerLinksPage, ListChannelPartnerLinksFixedSizeCollection> {
        public static ApiFuture<ListChannelPartnerLinksPagedResponse> createAsync(PageContext<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink> context, ApiFuture<ListChannelPartnerLinksResponse> futureResponse) {
            ApiFuture<ListChannelPartnerLinksPage> futurePage = ListChannelPartnerLinksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChannelPartnerLinksPagedResponse((ListChannelPartnerLinksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChannelPartnerLinksPagedResponse(ListChannelPartnerLinksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChannelPartnerLinksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTransferableOffersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer, ListTransferableOffersPage, ListTransferableOffersFixedSizeCollection> {
        private ListTransferableOffersFixedSizeCollection(List<ListTransferableOffersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferableOffersFixedSizeCollection createEmptyCollection() {
            return new ListTransferableOffersFixedSizeCollection(null, 0);
        }

        protected ListTransferableOffersFixedSizeCollection createCollection(List<ListTransferableOffersPage> pages, int collectionSize) {
            return new ListTransferableOffersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferableOffersPage
    extends AbstractPage<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer, ListTransferableOffersPage> {
        private ListTransferableOffersPage(PageContext<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer> context, ListTransferableOffersResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferableOffersPage createEmptyPage() {
            return new ListTransferableOffersPage(null, null);
        }

        protected ListTransferableOffersPage createPage(PageContext<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer> context, ListTransferableOffersResponse response) {
            return new ListTransferableOffersPage(context, response);
        }

        public ApiFuture<ListTransferableOffersPage> createPageAsync(PageContext<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer> context, ApiFuture<ListTransferableOffersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferableOffersPagedResponse
    extends AbstractPagedListResponse<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer, ListTransferableOffersPage, ListTransferableOffersFixedSizeCollection> {
        public static ApiFuture<ListTransferableOffersPagedResponse> createAsync(PageContext<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer> context, ApiFuture<ListTransferableOffersResponse> futureResponse) {
            ApiFuture<ListTransferableOffersPage> futurePage = ListTransferableOffersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTransferableOffersPagedResponse((ListTransferableOffersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferableOffersPagedResponse(ListTransferableOffersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferableOffersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTransferableSkusFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku, ListTransferableSkusPage, ListTransferableSkusFixedSizeCollection> {
        private ListTransferableSkusFixedSizeCollection(List<ListTransferableSkusPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTransferableSkusFixedSizeCollection createEmptyCollection() {
            return new ListTransferableSkusFixedSizeCollection(null, 0);
        }

        protected ListTransferableSkusFixedSizeCollection createCollection(List<ListTransferableSkusPage> pages, int collectionSize) {
            return new ListTransferableSkusFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTransferableSkusPage
    extends AbstractPage<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku, ListTransferableSkusPage> {
        private ListTransferableSkusPage(PageContext<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku> context, ListTransferableSkusResponse response) {
            super(context, (Object)response);
        }

        private static ListTransferableSkusPage createEmptyPage() {
            return new ListTransferableSkusPage(null, null);
        }

        protected ListTransferableSkusPage createPage(PageContext<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku> context, ListTransferableSkusResponse response) {
            return new ListTransferableSkusPage(context, response);
        }

        public ApiFuture<ListTransferableSkusPage> createPageAsync(PageContext<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku> context, ApiFuture<ListTransferableSkusResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTransferableSkusPagedResponse
    extends AbstractPagedListResponse<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku, ListTransferableSkusPage, ListTransferableSkusFixedSizeCollection> {
        public static ApiFuture<ListTransferableSkusPagedResponse> createAsync(PageContext<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku> context, ApiFuture<ListTransferableSkusResponse> futureResponse) {
            ApiFuture<ListTransferableSkusPage> futurePage = ListTransferableSkusPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTransferableSkusPagedResponse((ListTransferableSkusPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTransferableSkusPagedResponse(ListTransferableSkusPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTransferableSkusFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntitlementsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        private ListEntitlementsFixedSizeCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntitlementsFixedSizeCollection createEmptyCollection() {
            return new ListEntitlementsFixedSizeCollection(null, 0);
        }

        protected ListEntitlementsFixedSizeCollection createCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            return new ListEntitlementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntitlementsPage
    extends AbstractPage<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage> {
        private ListEntitlementsPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntitlementsPage createEmptyPage() {
            return new ListEntitlementsPage(null, null);
        }

        protected ListEntitlementsPage createPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            return new ListEntitlementsPage(context, response);
        }

        public ApiFuture<ListEntitlementsPage> createPageAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntitlementsPagedResponse
    extends AbstractPagedListResponse<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        public static ApiFuture<ListEntitlementsPagedResponse> createAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            ApiFuture<ListEntitlementsPage> futurePage = ListEntitlementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntitlementsPagedResponse((ListEntitlementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntitlementsPagedResponse(ListEntitlementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntitlementsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCustomersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomersRequest, ListCustomersResponse, Customer, ListCustomersPage, ListCustomersFixedSizeCollection> {
        private ListCustomersFixedSizeCollection(List<ListCustomersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomersFixedSizeCollection createEmptyCollection() {
            return new ListCustomersFixedSizeCollection(null, 0);
        }

        protected ListCustomersFixedSizeCollection createCollection(List<ListCustomersPage> pages, int collectionSize) {
            return new ListCustomersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomersPage
    extends AbstractPage<ListCustomersRequest, ListCustomersResponse, Customer, ListCustomersPage> {
        private ListCustomersPage(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ListCustomersResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomersPage createEmptyPage() {
            return new ListCustomersPage(null, null);
        }

        protected ListCustomersPage createPage(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ListCustomersResponse response) {
            return new ListCustomersPage(context, response);
        }

        public ApiFuture<ListCustomersPage> createPageAsync(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ApiFuture<ListCustomersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomersPagedResponse
    extends AbstractPagedListResponse<ListCustomersRequest, ListCustomersResponse, Customer, ListCustomersPage, ListCustomersFixedSizeCollection> {
        public static ApiFuture<ListCustomersPagedResponse> createAsync(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ApiFuture<ListCustomersResponse> futureResponse) {
            ApiFuture<ListCustomersPage> futurePage = ListCustomersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomersPagedResponse((ListCustomersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomersPagedResponse(ListCustomersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomersFixedSizeCollection.createEmptyCollection());
        }
    }
}

