/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.certificatemanager.v1.Certificate;
import com.google.cloud.certificatemanager.v1.CertificateIssuanceConfig;
import com.google.cloud.certificatemanager.v1.CertificateIssuanceConfigName;
import com.google.cloud.certificatemanager.v1.CertificateManagerSettings;
import com.google.cloud.certificatemanager.v1.CertificateMap;
import com.google.cloud.certificatemanager.v1.CertificateMapEntry;
import com.google.cloud.certificatemanager.v1.CertificateMapEntryName;
import com.google.cloud.certificatemanager.v1.CertificateMapName;
import com.google.cloud.certificatemanager.v1.CertificateName;
import com.google.cloud.certificatemanager.v1.CreateCertificateIssuanceConfigRequest;
import com.google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.CreateCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.CreateCertificateRequest;
import com.google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateIssuanceConfigRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateRequest;
import com.google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.DnsAuthorization;
import com.google.cloud.certificatemanager.v1.DnsAuthorizationName;
import com.google.cloud.certificatemanager.v1.GetCertificateIssuanceConfigRequest;
import com.google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.GetCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.GetCertificateRequest;
import com.google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsResponse;
import com.google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateMapEntriesResponse;
import com.google.cloud.certificatemanager.v1.ListCertificateMapsRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateMapsResponse;
import com.google.cloud.certificatemanager.v1.ListCertificatesRequest;
import com.google.cloud.certificatemanager.v1.ListCertificatesResponse;
import com.google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest;
import com.google.cloud.certificatemanager.v1.ListDnsAuthorizationsResponse;
import com.google.cloud.certificatemanager.v1.LocationName;
import com.google.cloud.certificatemanager.v1.OperationMetadata;
import com.google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.UpdateCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.UpdateCertificateRequest;
import com.google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.stub.CertificateManagerStub;
import com.google.cloud.certificatemanager.v1.stub.CertificateManagerStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CertificateManagerClient
implements BackgroundResource {
    private final CertificateManagerSettings settings;
    private final CertificateManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CertificateManagerClient create() throws IOException {
        return CertificateManagerClient.create(CertificateManagerSettings.newBuilder().build());
    }

    public static final CertificateManagerClient create(CertificateManagerSettings settings) throws IOException {
        return new CertificateManagerClient(settings);
    }

    public static final CertificateManagerClient create(CertificateManagerStub stub) {
        return new CertificateManagerClient(stub);
    }

    protected CertificateManagerClient(CertificateManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CertificateManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CertificateManagerClient(CertificateManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CertificateManagerSettings getSettings() {
        return this.settings;
    }

    public CertificateManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListCertificatesPagedResponse listCertificates(LocationName parent) {
        ListCertificatesRequest request = ListCertificatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificates(request);
    }

    public final ListCertificatesPagedResponse listCertificates(String parent) {
        ListCertificatesRequest request = ListCertificatesRequest.newBuilder().setParent(parent).build();
        return this.listCertificates(request);
    }

    public final ListCertificatesPagedResponse listCertificates(ListCertificatesRequest request) {
        return (ListCertificatesPagedResponse)((Object)this.listCertificatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificatesRequest, ListCertificatesPagedResponse> listCertificatesPagedCallable() {
        return this.stub.listCertificatesPagedCallable();
    }

    public final UnaryCallable<ListCertificatesRequest, ListCertificatesResponse> listCertificatesCallable() {
        return this.stub.listCertificatesCallable();
    }

    public final Certificate getCertificate(CertificateName name) {
        GetCertificateRequest request = GetCertificateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificate(request);
    }

    public final Certificate getCertificate(String name) {
        GetCertificateRequest request = GetCertificateRequest.newBuilder().setName(name).build();
        return this.getCertificate(request);
    }

    public final Certificate getCertificate(GetCertificateRequest request) {
        return (Certificate)this.getCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateRequest, Certificate> getCertificateCallable() {
        return this.stub.getCertificateCallable();
    }

    public final OperationFuture<Certificate, OperationMetadata> createCertificateAsync(LocationName parent, Certificate certificate, String certificateId) {
        CreateCertificateRequest request = CreateCertificateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificate(certificate).setCertificateId(certificateId).build();
        return this.createCertificateAsync(request);
    }

    public final OperationFuture<Certificate, OperationMetadata> createCertificateAsync(String parent, Certificate certificate, String certificateId) {
        CreateCertificateRequest request = CreateCertificateRequest.newBuilder().setParent(parent).setCertificate(certificate).setCertificateId(certificateId).build();
        return this.createCertificateAsync(request);
    }

    public final OperationFuture<Certificate, OperationMetadata> createCertificateAsync(CreateCertificateRequest request) {
        return this.createCertificateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCertificateRequest, Certificate, OperationMetadata> createCertificateOperationCallable() {
        return this.stub.createCertificateOperationCallable();
    }

    public final UnaryCallable<CreateCertificateRequest, Operation> createCertificateCallable() {
        return this.stub.createCertificateCallable();
    }

    public final OperationFuture<Certificate, OperationMetadata> updateCertificateAsync(Certificate certificate, FieldMask updateMask) {
        UpdateCertificateRequest request = UpdateCertificateRequest.newBuilder().setCertificate(certificate).setUpdateMask(updateMask).build();
        return this.updateCertificateAsync(request);
    }

    public final OperationFuture<Certificate, OperationMetadata> updateCertificateAsync(UpdateCertificateRequest request) {
        return this.updateCertificateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCertificateRequest, Certificate, OperationMetadata> updateCertificateOperationCallable() {
        return this.stub.updateCertificateOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateRequest, Operation> updateCertificateCallable() {
        return this.stub.updateCertificateCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateAsync(CertificateName name) {
        DeleteCertificateRequest request = DeleteCertificateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCertificateAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateAsync(String name) {
        DeleteCertificateRequest request = DeleteCertificateRequest.newBuilder().setName(name).build();
        return this.deleteCertificateAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateAsync(DeleteCertificateRequest request) {
        return this.deleteCertificateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCertificateRequest, Empty, OperationMetadata> deleteCertificateOperationCallable() {
        return this.stub.deleteCertificateOperationCallable();
    }

    public final UnaryCallable<DeleteCertificateRequest, Operation> deleteCertificateCallable() {
        return this.stub.deleteCertificateCallable();
    }

    public final ListCertificateMapsPagedResponse listCertificateMaps(LocationName parent) {
        ListCertificateMapsRequest request = ListCertificateMapsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateMaps(request);
    }

    public final ListCertificateMapsPagedResponse listCertificateMaps(String parent) {
        ListCertificateMapsRequest request = ListCertificateMapsRequest.newBuilder().setParent(parent).build();
        return this.listCertificateMaps(request);
    }

    public final ListCertificateMapsPagedResponse listCertificateMaps(ListCertificateMapsRequest request) {
        return (ListCertificateMapsPagedResponse)((Object)this.listCertificateMapsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateMapsRequest, ListCertificateMapsPagedResponse> listCertificateMapsPagedCallable() {
        return this.stub.listCertificateMapsPagedCallable();
    }

    public final UnaryCallable<ListCertificateMapsRequest, ListCertificateMapsResponse> listCertificateMapsCallable() {
        return this.stub.listCertificateMapsCallable();
    }

    public final CertificateMap getCertificateMap(CertificateMapName name) {
        GetCertificateMapRequest request = GetCertificateMapRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateMap(request);
    }

    public final CertificateMap getCertificateMap(String name) {
        GetCertificateMapRequest request = GetCertificateMapRequest.newBuilder().setName(name).build();
        return this.getCertificateMap(request);
    }

    public final CertificateMap getCertificateMap(GetCertificateMapRequest request) {
        return (CertificateMap)this.getCertificateMapCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateMapRequest, CertificateMap> getCertificateMapCallable() {
        return this.stub.getCertificateMapCallable();
    }

    public final OperationFuture<CertificateMap, OperationMetadata> createCertificateMapAsync(LocationName parent, CertificateMap certificateMap, String certificateMapId) {
        CreateCertificateMapRequest request = CreateCertificateMapRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateMap(certificateMap).setCertificateMapId(certificateMapId).build();
        return this.createCertificateMapAsync(request);
    }

    public final OperationFuture<CertificateMap, OperationMetadata> createCertificateMapAsync(String parent, CertificateMap certificateMap, String certificateMapId) {
        CreateCertificateMapRequest request = CreateCertificateMapRequest.newBuilder().setParent(parent).setCertificateMap(certificateMap).setCertificateMapId(certificateMapId).build();
        return this.createCertificateMapAsync(request);
    }

    public final OperationFuture<CertificateMap, OperationMetadata> createCertificateMapAsync(CreateCertificateMapRequest request) {
        return this.createCertificateMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCertificateMapRequest, CertificateMap, OperationMetadata> createCertificateMapOperationCallable() {
        return this.stub.createCertificateMapOperationCallable();
    }

    public final UnaryCallable<CreateCertificateMapRequest, Operation> createCertificateMapCallable() {
        return this.stub.createCertificateMapCallable();
    }

    public final OperationFuture<CertificateMap, OperationMetadata> updateCertificateMapAsync(CertificateMap certificateMap, FieldMask updateMask) {
        UpdateCertificateMapRequest request = UpdateCertificateMapRequest.newBuilder().setCertificateMap(certificateMap).setUpdateMask(updateMask).build();
        return this.updateCertificateMapAsync(request);
    }

    public final OperationFuture<CertificateMap, OperationMetadata> updateCertificateMapAsync(UpdateCertificateMapRequest request) {
        return this.updateCertificateMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCertificateMapRequest, CertificateMap, OperationMetadata> updateCertificateMapOperationCallable() {
        return this.stub.updateCertificateMapOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateMapRequest, Operation> updateCertificateMapCallable() {
        return this.stub.updateCertificateMapCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateMapAsync(CertificateMapName name) {
        DeleteCertificateMapRequest request = DeleteCertificateMapRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCertificateMapAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateMapAsync(String name) {
        DeleteCertificateMapRequest request = DeleteCertificateMapRequest.newBuilder().setName(name).build();
        return this.deleteCertificateMapAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateMapAsync(DeleteCertificateMapRequest request) {
        return this.deleteCertificateMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCertificateMapRequest, Empty, OperationMetadata> deleteCertificateMapOperationCallable() {
        return this.stub.deleteCertificateMapOperationCallable();
    }

    public final UnaryCallable<DeleteCertificateMapRequest, Operation> deleteCertificateMapCallable() {
        return this.stub.deleteCertificateMapCallable();
    }

    public final ListCertificateMapEntriesPagedResponse listCertificateMapEntries(CertificateMapName parent) {
        ListCertificateMapEntriesRequest request = ListCertificateMapEntriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateMapEntries(request);
    }

    public final ListCertificateMapEntriesPagedResponse listCertificateMapEntries(String parent) {
        ListCertificateMapEntriesRequest request = ListCertificateMapEntriesRequest.newBuilder().setParent(parent).build();
        return this.listCertificateMapEntries(request);
    }

    public final ListCertificateMapEntriesPagedResponse listCertificateMapEntries(ListCertificateMapEntriesRequest request) {
        return (ListCertificateMapEntriesPagedResponse)((Object)this.listCertificateMapEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateMapEntriesRequest, ListCertificateMapEntriesPagedResponse> listCertificateMapEntriesPagedCallable() {
        return this.stub.listCertificateMapEntriesPagedCallable();
    }

    public final UnaryCallable<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse> listCertificateMapEntriesCallable() {
        return this.stub.listCertificateMapEntriesCallable();
    }

    public final CertificateMapEntry getCertificateMapEntry(CertificateMapEntryName name) {
        GetCertificateMapEntryRequest request = GetCertificateMapEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateMapEntry(request);
    }

    public final CertificateMapEntry getCertificateMapEntry(String name) {
        GetCertificateMapEntryRequest request = GetCertificateMapEntryRequest.newBuilder().setName(name).build();
        return this.getCertificateMapEntry(request);
    }

    public final CertificateMapEntry getCertificateMapEntry(GetCertificateMapEntryRequest request) {
        return (CertificateMapEntry)this.getCertificateMapEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateMapEntryRequest, CertificateMapEntry> getCertificateMapEntryCallable() {
        return this.stub.getCertificateMapEntryCallable();
    }

    public final OperationFuture<CertificateMapEntry, OperationMetadata> createCertificateMapEntryAsync(CertificateMapName parent, CertificateMapEntry certificateMapEntry, String certificateMapEntryId) {
        CreateCertificateMapEntryRequest request = CreateCertificateMapEntryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateMapEntry(certificateMapEntry).setCertificateMapEntryId(certificateMapEntryId).build();
        return this.createCertificateMapEntryAsync(request);
    }

    public final OperationFuture<CertificateMapEntry, OperationMetadata> createCertificateMapEntryAsync(String parent, CertificateMapEntry certificateMapEntry, String certificateMapEntryId) {
        CreateCertificateMapEntryRequest request = CreateCertificateMapEntryRequest.newBuilder().setParent(parent).setCertificateMapEntry(certificateMapEntry).setCertificateMapEntryId(certificateMapEntryId).build();
        return this.createCertificateMapEntryAsync(request);
    }

    public final OperationFuture<CertificateMapEntry, OperationMetadata> createCertificateMapEntryAsync(CreateCertificateMapEntryRequest request) {
        return this.createCertificateMapEntryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> createCertificateMapEntryOperationCallable() {
        return this.stub.createCertificateMapEntryOperationCallable();
    }

    public final UnaryCallable<CreateCertificateMapEntryRequest, Operation> createCertificateMapEntryCallable() {
        return this.stub.createCertificateMapEntryCallable();
    }

    public final OperationFuture<CertificateMapEntry, OperationMetadata> updateCertificateMapEntryAsync(CertificateMapEntry certificateMapEntry, FieldMask updateMask) {
        UpdateCertificateMapEntryRequest request = UpdateCertificateMapEntryRequest.newBuilder().setCertificateMapEntry(certificateMapEntry).setUpdateMask(updateMask).build();
        return this.updateCertificateMapEntryAsync(request);
    }

    public final OperationFuture<CertificateMapEntry, OperationMetadata> updateCertificateMapEntryAsync(UpdateCertificateMapEntryRequest request) {
        return this.updateCertificateMapEntryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> updateCertificateMapEntryOperationCallable() {
        return this.stub.updateCertificateMapEntryOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateMapEntryRequest, Operation> updateCertificateMapEntryCallable() {
        return this.stub.updateCertificateMapEntryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateMapEntryAsync(CertificateMapEntryName name) {
        DeleteCertificateMapEntryRequest request = DeleteCertificateMapEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCertificateMapEntryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateMapEntryAsync(String name) {
        DeleteCertificateMapEntryRequest request = DeleteCertificateMapEntryRequest.newBuilder().setName(name).build();
        return this.deleteCertificateMapEntryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateMapEntryAsync(DeleteCertificateMapEntryRequest request) {
        return this.deleteCertificateMapEntryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCertificateMapEntryRequest, Empty, OperationMetadata> deleteCertificateMapEntryOperationCallable() {
        return this.stub.deleteCertificateMapEntryOperationCallable();
    }

    public final UnaryCallable<DeleteCertificateMapEntryRequest, Operation> deleteCertificateMapEntryCallable() {
        return this.stub.deleteCertificateMapEntryCallable();
    }

    public final ListDnsAuthorizationsPagedResponse listDnsAuthorizations(LocationName parent) {
        ListDnsAuthorizationsRequest request = ListDnsAuthorizationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDnsAuthorizations(request);
    }

    public final ListDnsAuthorizationsPagedResponse listDnsAuthorizations(String parent) {
        ListDnsAuthorizationsRequest request = ListDnsAuthorizationsRequest.newBuilder().setParent(parent).build();
        return this.listDnsAuthorizations(request);
    }

    public final ListDnsAuthorizationsPagedResponse listDnsAuthorizations(ListDnsAuthorizationsRequest request) {
        return (ListDnsAuthorizationsPagedResponse)((Object)this.listDnsAuthorizationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDnsAuthorizationsRequest, ListDnsAuthorizationsPagedResponse> listDnsAuthorizationsPagedCallable() {
        return this.stub.listDnsAuthorizationsPagedCallable();
    }

    public final UnaryCallable<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse> listDnsAuthorizationsCallable() {
        return this.stub.listDnsAuthorizationsCallable();
    }

    public final DnsAuthorization getDnsAuthorization(DnsAuthorizationName name) {
        GetDnsAuthorizationRequest request = GetDnsAuthorizationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDnsAuthorization(request);
    }

    public final DnsAuthorization getDnsAuthorization(String name) {
        GetDnsAuthorizationRequest request = GetDnsAuthorizationRequest.newBuilder().setName(name).build();
        return this.getDnsAuthorization(request);
    }

    public final DnsAuthorization getDnsAuthorization(GetDnsAuthorizationRequest request) {
        return (DnsAuthorization)this.getDnsAuthorizationCallable().call((Object)request);
    }

    public final UnaryCallable<GetDnsAuthorizationRequest, DnsAuthorization> getDnsAuthorizationCallable() {
        return this.stub.getDnsAuthorizationCallable();
    }

    public final OperationFuture<DnsAuthorization, OperationMetadata> createDnsAuthorizationAsync(LocationName parent, DnsAuthorization dnsAuthorization, String dnsAuthorizationId) {
        CreateDnsAuthorizationRequest request = CreateDnsAuthorizationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDnsAuthorization(dnsAuthorization).setDnsAuthorizationId(dnsAuthorizationId).build();
        return this.createDnsAuthorizationAsync(request);
    }

    public final OperationFuture<DnsAuthorization, OperationMetadata> createDnsAuthorizationAsync(String parent, DnsAuthorization dnsAuthorization, String dnsAuthorizationId) {
        CreateDnsAuthorizationRequest request = CreateDnsAuthorizationRequest.newBuilder().setParent(parent).setDnsAuthorization(dnsAuthorization).setDnsAuthorizationId(dnsAuthorizationId).build();
        return this.createDnsAuthorizationAsync(request);
    }

    public final OperationFuture<DnsAuthorization, OperationMetadata> createDnsAuthorizationAsync(CreateDnsAuthorizationRequest request) {
        return this.createDnsAuthorizationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> createDnsAuthorizationOperationCallable() {
        return this.stub.createDnsAuthorizationOperationCallable();
    }

    public final UnaryCallable<CreateDnsAuthorizationRequest, Operation> createDnsAuthorizationCallable() {
        return this.stub.createDnsAuthorizationCallable();
    }

    public final OperationFuture<DnsAuthorization, OperationMetadata> updateDnsAuthorizationAsync(DnsAuthorization dnsAuthorization, FieldMask updateMask) {
        UpdateDnsAuthorizationRequest request = UpdateDnsAuthorizationRequest.newBuilder().setDnsAuthorization(dnsAuthorization).setUpdateMask(updateMask).build();
        return this.updateDnsAuthorizationAsync(request);
    }

    public final OperationFuture<DnsAuthorization, OperationMetadata> updateDnsAuthorizationAsync(UpdateDnsAuthorizationRequest request) {
        return this.updateDnsAuthorizationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> updateDnsAuthorizationOperationCallable() {
        return this.stub.updateDnsAuthorizationOperationCallable();
    }

    public final UnaryCallable<UpdateDnsAuthorizationRequest, Operation> updateDnsAuthorizationCallable() {
        return this.stub.updateDnsAuthorizationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDnsAuthorizationAsync(DnsAuthorizationName name) {
        DeleteDnsAuthorizationRequest request = DeleteDnsAuthorizationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDnsAuthorizationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDnsAuthorizationAsync(String name) {
        DeleteDnsAuthorizationRequest request = DeleteDnsAuthorizationRequest.newBuilder().setName(name).build();
        return this.deleteDnsAuthorizationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDnsAuthorizationAsync(DeleteDnsAuthorizationRequest request) {
        return this.deleteDnsAuthorizationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDnsAuthorizationRequest, Empty, OperationMetadata> deleteDnsAuthorizationOperationCallable() {
        return this.stub.deleteDnsAuthorizationOperationCallable();
    }

    public final UnaryCallable<DeleteDnsAuthorizationRequest, Operation> deleteDnsAuthorizationCallable() {
        return this.stub.deleteDnsAuthorizationCallable();
    }

    public final ListCertificateIssuanceConfigsPagedResponse listCertificateIssuanceConfigs(LocationName parent) {
        ListCertificateIssuanceConfigsRequest request = ListCertificateIssuanceConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateIssuanceConfigs(request);
    }

    public final ListCertificateIssuanceConfigsPagedResponse listCertificateIssuanceConfigs(String parent) {
        ListCertificateIssuanceConfigsRequest request = ListCertificateIssuanceConfigsRequest.newBuilder().setParent(parent).build();
        return this.listCertificateIssuanceConfigs(request);
    }

    public final ListCertificateIssuanceConfigsPagedResponse listCertificateIssuanceConfigs(ListCertificateIssuanceConfigsRequest request) {
        return (ListCertificateIssuanceConfigsPagedResponse)((Object)this.listCertificateIssuanceConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsPagedResponse> listCertificateIssuanceConfigsPagedCallable() {
        return this.stub.listCertificateIssuanceConfigsPagedCallable();
    }

    public final UnaryCallable<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse> listCertificateIssuanceConfigsCallable() {
        return this.stub.listCertificateIssuanceConfigsCallable();
    }

    public final CertificateIssuanceConfig getCertificateIssuanceConfig(CertificateIssuanceConfigName name) {
        GetCertificateIssuanceConfigRequest request = GetCertificateIssuanceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateIssuanceConfig(request);
    }

    public final CertificateIssuanceConfig getCertificateIssuanceConfig(String name) {
        GetCertificateIssuanceConfigRequest request = GetCertificateIssuanceConfigRequest.newBuilder().setName(name).build();
        return this.getCertificateIssuanceConfig(request);
    }

    public final CertificateIssuanceConfig getCertificateIssuanceConfig(GetCertificateIssuanceConfigRequest request) {
        return (CertificateIssuanceConfig)this.getCertificateIssuanceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateIssuanceConfigRequest, CertificateIssuanceConfig> getCertificateIssuanceConfigCallable() {
        return this.stub.getCertificateIssuanceConfigCallable();
    }

    public final OperationFuture<CertificateIssuanceConfig, OperationMetadata> createCertificateIssuanceConfigAsync(LocationName parent, CertificateIssuanceConfig certificateIssuanceConfig, String certificateIssuanceConfigId) {
        CreateCertificateIssuanceConfigRequest request = CreateCertificateIssuanceConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateIssuanceConfig(certificateIssuanceConfig).setCertificateIssuanceConfigId(certificateIssuanceConfigId).build();
        return this.createCertificateIssuanceConfigAsync(request);
    }

    public final OperationFuture<CertificateIssuanceConfig, OperationMetadata> createCertificateIssuanceConfigAsync(String parent, CertificateIssuanceConfig certificateIssuanceConfig, String certificateIssuanceConfigId) {
        CreateCertificateIssuanceConfigRequest request = CreateCertificateIssuanceConfigRequest.newBuilder().setParent(parent).setCertificateIssuanceConfig(certificateIssuanceConfig).setCertificateIssuanceConfigId(certificateIssuanceConfigId).build();
        return this.createCertificateIssuanceConfigAsync(request);
    }

    public final OperationFuture<CertificateIssuanceConfig, OperationMetadata> createCertificateIssuanceConfigAsync(CreateCertificateIssuanceConfigRequest request) {
        return this.createCertificateIssuanceConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCertificateIssuanceConfigRequest, CertificateIssuanceConfig, OperationMetadata> createCertificateIssuanceConfigOperationCallable() {
        return this.stub.createCertificateIssuanceConfigOperationCallable();
    }

    public final UnaryCallable<CreateCertificateIssuanceConfigRequest, Operation> createCertificateIssuanceConfigCallable() {
        return this.stub.createCertificateIssuanceConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateIssuanceConfigAsync(CertificateIssuanceConfigName name) {
        DeleteCertificateIssuanceConfigRequest request = DeleteCertificateIssuanceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCertificateIssuanceConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateIssuanceConfigAsync(String name) {
        DeleteCertificateIssuanceConfigRequest request = DeleteCertificateIssuanceConfigRequest.newBuilder().setName(name).build();
        return this.deleteCertificateIssuanceConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateIssuanceConfigAsync(DeleteCertificateIssuanceConfigRequest request) {
        return this.deleteCertificateIssuanceConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCertificateIssuanceConfigRequest, Empty, OperationMetadata> deleteCertificateIssuanceConfigOperationCallable() {
        return this.stub.deleteCertificateIssuanceConfigOperationCallable();
    }

    public final UnaryCallable<DeleteCertificateIssuanceConfigRequest, Operation> deleteCertificateIssuanceConfigCallable() {
        return this.stub.deleteCertificateIssuanceConfigCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateIssuanceConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig, ListCertificateIssuanceConfigsPage, ListCertificateIssuanceConfigsFixedSizeCollection> {
        private ListCertificateIssuanceConfigsFixedSizeCollection(List<ListCertificateIssuanceConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateIssuanceConfigsFixedSizeCollection createEmptyCollection() {
            return new ListCertificateIssuanceConfigsFixedSizeCollection(null, 0);
        }

        protected ListCertificateIssuanceConfigsFixedSizeCollection createCollection(List<ListCertificateIssuanceConfigsPage> pages, int collectionSize) {
            return new ListCertificateIssuanceConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateIssuanceConfigsPage
    extends AbstractPage<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig, ListCertificateIssuanceConfigsPage> {
        private ListCertificateIssuanceConfigsPage(PageContext<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig> context, ListCertificateIssuanceConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateIssuanceConfigsPage createEmptyPage() {
            return new ListCertificateIssuanceConfigsPage(null, null);
        }

        protected ListCertificateIssuanceConfigsPage createPage(PageContext<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig> context, ListCertificateIssuanceConfigsResponse response) {
            return new ListCertificateIssuanceConfigsPage(context, response);
        }

        public ApiFuture<ListCertificateIssuanceConfigsPage> createPageAsync(PageContext<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig> context, ApiFuture<ListCertificateIssuanceConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateIssuanceConfigsPagedResponse
    extends AbstractPagedListResponse<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig, ListCertificateIssuanceConfigsPage, ListCertificateIssuanceConfigsFixedSizeCollection> {
        public static ApiFuture<ListCertificateIssuanceConfigsPagedResponse> createAsync(PageContext<ListCertificateIssuanceConfigsRequest, ListCertificateIssuanceConfigsResponse, CertificateIssuanceConfig> context, ApiFuture<ListCertificateIssuanceConfigsResponse> futureResponse) {
            ApiFuture<ListCertificateIssuanceConfigsPage> futurePage = ListCertificateIssuanceConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificateIssuanceConfigsPagedResponse((ListCertificateIssuanceConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateIssuanceConfigsPagedResponse(ListCertificateIssuanceConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateIssuanceConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDnsAuthorizationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization, ListDnsAuthorizationsPage, ListDnsAuthorizationsFixedSizeCollection> {
        private ListDnsAuthorizationsFixedSizeCollection(List<ListDnsAuthorizationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDnsAuthorizationsFixedSizeCollection createEmptyCollection() {
            return new ListDnsAuthorizationsFixedSizeCollection(null, 0);
        }

        protected ListDnsAuthorizationsFixedSizeCollection createCollection(List<ListDnsAuthorizationsPage> pages, int collectionSize) {
            return new ListDnsAuthorizationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDnsAuthorizationsPage
    extends AbstractPage<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization, ListDnsAuthorizationsPage> {
        private ListDnsAuthorizationsPage(PageContext<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization> context, ListDnsAuthorizationsResponse response) {
            super(context, (Object)response);
        }

        private static ListDnsAuthorizationsPage createEmptyPage() {
            return new ListDnsAuthorizationsPage(null, null);
        }

        protected ListDnsAuthorizationsPage createPage(PageContext<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization> context, ListDnsAuthorizationsResponse response) {
            return new ListDnsAuthorizationsPage(context, response);
        }

        public ApiFuture<ListDnsAuthorizationsPage> createPageAsync(PageContext<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization> context, ApiFuture<ListDnsAuthorizationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDnsAuthorizationsPagedResponse
    extends AbstractPagedListResponse<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization, ListDnsAuthorizationsPage, ListDnsAuthorizationsFixedSizeCollection> {
        public static ApiFuture<ListDnsAuthorizationsPagedResponse> createAsync(PageContext<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization> context, ApiFuture<ListDnsAuthorizationsResponse> futureResponse) {
            ApiFuture<ListDnsAuthorizationsPage> futurePage = ListDnsAuthorizationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDnsAuthorizationsPagedResponse((ListDnsAuthorizationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDnsAuthorizationsPagedResponse(ListDnsAuthorizationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDnsAuthorizationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateMapEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry, ListCertificateMapEntriesPage, ListCertificateMapEntriesFixedSizeCollection> {
        private ListCertificateMapEntriesFixedSizeCollection(List<ListCertificateMapEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateMapEntriesFixedSizeCollection createEmptyCollection() {
            return new ListCertificateMapEntriesFixedSizeCollection(null, 0);
        }

        protected ListCertificateMapEntriesFixedSizeCollection createCollection(List<ListCertificateMapEntriesPage> pages, int collectionSize) {
            return new ListCertificateMapEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateMapEntriesPage
    extends AbstractPage<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry, ListCertificateMapEntriesPage> {
        private ListCertificateMapEntriesPage(PageContext<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry> context, ListCertificateMapEntriesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateMapEntriesPage createEmptyPage() {
            return new ListCertificateMapEntriesPage(null, null);
        }

        protected ListCertificateMapEntriesPage createPage(PageContext<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry> context, ListCertificateMapEntriesResponse response) {
            return new ListCertificateMapEntriesPage(context, response);
        }

        public ApiFuture<ListCertificateMapEntriesPage> createPageAsync(PageContext<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry> context, ApiFuture<ListCertificateMapEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateMapEntriesPagedResponse
    extends AbstractPagedListResponse<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry, ListCertificateMapEntriesPage, ListCertificateMapEntriesFixedSizeCollection> {
        public static ApiFuture<ListCertificateMapEntriesPagedResponse> createAsync(PageContext<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry> context, ApiFuture<ListCertificateMapEntriesResponse> futureResponse) {
            ApiFuture<ListCertificateMapEntriesPage> futurePage = ListCertificateMapEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificateMapEntriesPagedResponse((ListCertificateMapEntriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateMapEntriesPagedResponse(ListCertificateMapEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateMapEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateMapsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap, ListCertificateMapsPage, ListCertificateMapsFixedSizeCollection> {
        private ListCertificateMapsFixedSizeCollection(List<ListCertificateMapsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateMapsFixedSizeCollection createEmptyCollection() {
            return new ListCertificateMapsFixedSizeCollection(null, 0);
        }

        protected ListCertificateMapsFixedSizeCollection createCollection(List<ListCertificateMapsPage> pages, int collectionSize) {
            return new ListCertificateMapsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateMapsPage
    extends AbstractPage<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap, ListCertificateMapsPage> {
        private ListCertificateMapsPage(PageContext<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap> context, ListCertificateMapsResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateMapsPage createEmptyPage() {
            return new ListCertificateMapsPage(null, null);
        }

        protected ListCertificateMapsPage createPage(PageContext<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap> context, ListCertificateMapsResponse response) {
            return new ListCertificateMapsPage(context, response);
        }

        public ApiFuture<ListCertificateMapsPage> createPageAsync(PageContext<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap> context, ApiFuture<ListCertificateMapsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateMapsPagedResponse
    extends AbstractPagedListResponse<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap, ListCertificateMapsPage, ListCertificateMapsFixedSizeCollection> {
        public static ApiFuture<ListCertificateMapsPagedResponse> createAsync(PageContext<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap> context, ApiFuture<ListCertificateMapsResponse> futureResponse) {
            ApiFuture<ListCertificateMapsPage> futurePage = ListCertificateMapsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificateMapsPagedResponse((ListCertificateMapsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateMapsPagedResponse(ListCertificateMapsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateMapsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage, ListCertificatesFixedSizeCollection> {
        private ListCertificatesFixedSizeCollection(List<ListCertificatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificatesFixedSizeCollection createEmptyCollection() {
            return new ListCertificatesFixedSizeCollection(null, 0);
        }

        protected ListCertificatesFixedSizeCollection createCollection(List<ListCertificatesPage> pages, int collectionSize) {
            return new ListCertificatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificatesPage
    extends AbstractPage<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage> {
        private ListCertificatesPage(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ListCertificatesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificatesPage createEmptyPage() {
            return new ListCertificatesPage(null, null);
        }

        protected ListCertificatesPage createPage(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ListCertificatesResponse response) {
            return new ListCertificatesPage(context, response);
        }

        public ApiFuture<ListCertificatesPage> createPageAsync(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ApiFuture<ListCertificatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificatesPagedResponse
    extends AbstractPagedListResponse<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage, ListCertificatesFixedSizeCollection> {
        public static ApiFuture<ListCertificatesPagedResponse> createAsync(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ApiFuture<ListCertificatesResponse> futureResponse) {
            ApiFuture<ListCertificatesPage> futurePage = ListCertificatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificatesPagedResponse((ListCertificatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificatesPagedResponse(ListCertificatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

