/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.BillingAccount;
import com.google.cloud.billing.v1.CloudBillingClient;
import com.google.cloud.billing.v1.CreateBillingAccountRequest;
import com.google.cloud.billing.v1.GetBillingAccountRequest;
import com.google.cloud.billing.v1.GetProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListBillingAccountsRequest;
import com.google.cloud.billing.v1.ListBillingAccountsResponse;
import com.google.cloud.billing.v1.ListProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListProjectBillingInfoResponse;
import com.google.cloud.billing.v1.ProjectBillingInfo;
import com.google.cloud.billing.v1.UpdateBillingAccountRequest;
import com.google.cloud.billing.v1.UpdateProjectBillingInfoRequest;
import com.google.cloud.billing.v1.stub.CloudBillingStub;
import com.google.cloud.billing.v1.stub.CloudBillingStubSettings;
import com.google.cloud.billing.v1.stub.HttpJsonCloudBillingCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCloudBillingStub
extends CloudBillingStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetBillingAccountRequest, BillingAccount> getBillingAccountMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/GetBillingAccount").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=billingAccounts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BillingAccount.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/ListBillingAccounts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/billingAccounts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBillingAccountsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/UpdateBillingAccount").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=billingAccounts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("account", (Message)request.getAccount(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BillingAccount.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateBillingAccountRequest, BillingAccount> createBillingAccountMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/CreateBillingAccount").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/billingAccounts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("billingAccount", (Message)request.getBillingAccount(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BillingAccount.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=billingAccounts/*}/projects", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListProjectBillingInfoResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/billingInfo", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProjectBillingInfo.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/billingInfo", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("projectBillingInfo", (Message)request.getProjectBillingInfo(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProjectBillingInfo.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=billingAccounts/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "options", (Object)request.getOptions());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=billingAccounts/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudBilling/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=billingAccounts/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetBillingAccountRequest, BillingAccount> getBillingAccountCallable;
    private final UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsCallable;
    private final UnaryCallable<ListBillingAccountsRequest, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsPagedCallable;
    private final UnaryCallable<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountCallable;
    private final UnaryCallable<CreateBillingAccountRequest, BillingAccount> createBillingAccountCallable;
    private final UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoCallable;
    private final UnaryCallable<ListProjectBillingInfoRequest, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoPagedCallable;
    private final UnaryCallable<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoCallable;
    private final UnaryCallable<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudBillingStub create(CloudBillingStubSettings settings) throws IOException {
        return new HttpJsonCloudBillingStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudBillingStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudBillingStub(CloudBillingStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudBillingStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudBillingStub(CloudBillingStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudBillingStub(CloudBillingStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudBillingCallableFactory());
    }

    protected HttpJsonCloudBillingStub(CloudBillingStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getBillingAccountTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBillingAccountMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listBillingAccountsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBillingAccountsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateBillingAccountTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateBillingAccountMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createBillingAccountTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBillingAccountMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listProjectBillingInfoTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listProjectBillingInfoMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getProjectBillingInfoTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProjectBillingInfoMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateProjectBillingInfoTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateProjectBillingInfoMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getBillingAccountCallable = callableFactory.createUnaryCallable(getBillingAccountTransportSettings, settings.getBillingAccountSettings(), clientContext);
        this.listBillingAccountsCallable = callableFactory.createUnaryCallable(listBillingAccountsTransportSettings, settings.listBillingAccountsSettings(), clientContext);
        this.listBillingAccountsPagedCallable = callableFactory.createPagedCallable(listBillingAccountsTransportSettings, settings.listBillingAccountsSettings(), clientContext);
        this.updateBillingAccountCallable = callableFactory.createUnaryCallable(updateBillingAccountTransportSettings, settings.updateBillingAccountSettings(), clientContext);
        this.createBillingAccountCallable = callableFactory.createUnaryCallable(createBillingAccountTransportSettings, settings.createBillingAccountSettings(), clientContext);
        this.listProjectBillingInfoCallable = callableFactory.createUnaryCallable(listProjectBillingInfoTransportSettings, settings.listProjectBillingInfoSettings(), clientContext);
        this.listProjectBillingInfoPagedCallable = callableFactory.createPagedCallable(listProjectBillingInfoTransportSettings, settings.listProjectBillingInfoSettings(), clientContext);
        this.getProjectBillingInfoCallable = callableFactory.createUnaryCallable(getProjectBillingInfoTransportSettings, settings.getProjectBillingInfoSettings(), clientContext);
        this.updateProjectBillingInfoCallable = callableFactory.createUnaryCallable(updateProjectBillingInfoTransportSettings, settings.updateProjectBillingInfoSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getBillingAccountMethodDescriptor);
        methodDescriptors.add(listBillingAccountsMethodDescriptor);
        methodDescriptors.add(updateBillingAccountMethodDescriptor);
        methodDescriptors.add(createBillingAccountMethodDescriptor);
        methodDescriptors.add(listProjectBillingInfoMethodDescriptor);
        methodDescriptors.add(getProjectBillingInfoMethodDescriptor);
        methodDescriptors.add(updateProjectBillingInfoMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetBillingAccountRequest, BillingAccount> getBillingAccountCallable() {
        return this.getBillingAccountCallable;
    }

    @Override
    public UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsCallable() {
        return this.listBillingAccountsCallable;
    }

    @Override
    public UnaryCallable<ListBillingAccountsRequest, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsPagedCallable() {
        return this.listBillingAccountsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountCallable() {
        return this.updateBillingAccountCallable;
    }

    @Override
    public UnaryCallable<CreateBillingAccountRequest, BillingAccount> createBillingAccountCallable() {
        return this.createBillingAccountCallable;
    }

    @Override
    public UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoCallable() {
        return this.listProjectBillingInfoCallable;
    }

    @Override
    public UnaryCallable<ListProjectBillingInfoRequest, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoPagedCallable() {
        return this.listProjectBillingInfoPagedCallable;
    }

    @Override
    public UnaryCallable<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoCallable() {
        return this.getProjectBillingInfoCallable;
    }

    @Override
    public UnaryCallable<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoCallable() {
        return this.updateProjectBillingInfoCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

