/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.SchemaBundleName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;

public final class SchemaBundle {
    private final com.google.bigtable.admin.v2.SchemaBundle proto;
    private final SchemaBundleName schemaBundleName;

    @InternalApi
    public static SchemaBundle fromProto(@Nonnull com.google.bigtable.admin.v2.SchemaBundle proto) {
        return new SchemaBundle(proto);
    }

    private SchemaBundle(@Nonnull com.google.bigtable.admin.v2.SchemaBundle proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"SchemaBundle must have a name");
        Preconditions.checkArgument((boolean)proto.hasProtoSchema(), (Object)"Schemabundle must have a proto_schema field");
        this.proto = proto;
        this.schemaBundleName = SchemaBundleName.parse((String)proto.getName());
    }

    public String getId() {
        return this.schemaBundleName.getSchemaBundle();
    }

    public String getTableId() {
        return this.schemaBundleName.getTable();
    }

    public ByteString getProtoSchema() {
        if (this.proto.hasProtoSchema()) {
            return this.proto.getProtoSchema().getProtoDescriptors();
        }
        throw new IllegalStateException("This SchemaBundle doesn't have a valid type specified");
    }

    @InternalApi
    public com.google.bigtable.admin.v2.SchemaBundle toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaBundle that = (SchemaBundle)o;
        return Objects.equal((Object)this.proto, (Object)that.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }
}

