/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BigtableInstanceAdminSettings {
    private static final Logger LOGGER = Logger.getLogger(BigtableInstanceAdminSettings.class.getName());
    private final String projectId;
    private final BigtableInstanceAdminStubSettings stubSettings;

    private BigtableInstanceAdminSettings(Builder builder) throws IOException {
        Preconditions.checkNotNull((Object)builder.projectId, (Object)"Project ID must be set");
        Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]);
        this.projectId = builder.projectId;
        this.stubSettings = builder.stubSettings.build();
    }

    @Nonnull
    public String getProjectId() {
        return this.projectId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.stubSettings.getCredentialsProvider();
    }

    @Nonnull
    public BigtableInstanceAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", (Object)this.projectId).add("createInstanceSettings", this.stubSettings.createInstanceSettings()).add("createInstanceOperationSettings", this.stubSettings.createInstanceOperationSettings()).add("getInstanceSettings", this.stubSettings.getInstanceSettings()).add("listInstancesSettings", this.stubSettings.listInstancesSettings()).add("partialUpdateInstanceSettings", this.stubSettings.partialUpdateInstanceSettings()).add("partialUpdateInstanceOperationSettings", this.stubSettings.partialUpdateInstanceOperationSettings()).add("deleteInstanceSettings", this.stubSettings.deleteInstanceSettings()).add("createClusterSettings", this.stubSettings.createClusterSettings()).add("createClusterOperationSettings", this.stubSettings.createClusterOperationSettings()).add("getClusterSettings", this.stubSettings.getClusterSettings()).add("listClustersSettings", this.stubSettings.listClustersSettings()).add("updateClusterSettings", this.stubSettings.updateClusterSettings()).add("updateClusterOperationSettings", this.stubSettings.updateClusterOperationSettings()).add("deleteClusterSettings", this.stubSettings.deleteClusterSettings()).add("createAppProfileSettings", this.stubSettings.createAppProfileSettings()).add("getAppProfileSettings", this.stubSettings.getAppProfileSettings()).add("listAppProfilesSettings", this.stubSettings.listAppProfilesSettings()).add("updateAppProfileSettings", this.stubSettings.updateAppProfileSettings()).add("updateAppProfileOperationSettings", this.stubSettings.updateAppProfileOperationSettings()).add("deleteAppProfileSettings", this.stubSettings.deleteAppProfileSettings()).add("getIamPolicySettings", this.stubSettings.getIamPolicySettings()).add("setIamPolicySettings", this.stubSettings.setIamPolicySettings()).add("testIamPermissionsSettings", this.stubSettings.testIamPermissionsSettings()).add("createMaterializedViewSettings", this.stubSettings.createMaterializedViewSettings()).add("getMaterializedViewSettings", this.stubSettings.getMaterializedViewSettings()).add("listMaterializedViewsSettings", this.stubSettings.listMaterializedViewsSettings()).add("updateMaterializedViewSettings", this.stubSettings.updateMaterializedViewSettings()).add("deleteMaterializedViewSettings", this.stubSettings.deleteMaterializedViewSettings()).add("createLogicalViewSettings", this.stubSettings.createLogicalViewSettings()).add("getLogicalViewSettings", this.stubSettings.getLogicalViewSettings()).add("listLogicalViewsSettings", this.stubSettings.listLogicalViewsSettings()).add("updateLogicalViewSettings", this.stubSettings.updateLogicalViewSettings()).add("deleteLogicalViewSettings", this.stubSettings.deleteLogicalViewSettings()).add("stubSettings", (Object)this.stubSettings).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        String hostAndPort = System.getenv("BIGTABLE_EMULATOR_HOST");
        if (!Strings.isNullOrEmpty((String)hostAndPort)) {
            try {
                int port = Integer.parseInt(hostAndPort.substring(hostAndPort.lastIndexOf(":") + 1));
                return BigtableInstanceAdminSettings.newBuilderForEmulator(hostAndPort.substring(0, hostAndPort.lastIndexOf(":")), port);
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                throw new RuntimeException("Invalid host/port in BIGTABLE_EMULATOR_HOST environment variable: " + hostAndPort);
            }
        }
        return new Builder();
    }

    public static Builder newBuilderForEmulator(int port) {
        return BigtableInstanceAdminSettings.newBuilderForEmulator("localhost", port);
    }

    public static Builder newBuilderForEmulator(String hostname, int port) {
        Builder builder = new Builder();
        ((BigtableInstanceAdminStubSettings.Builder)((BigtableInstanceAdminStubSettings.Builder)builder.stubSettings().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setEndpoint(hostname + ":" + port)).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)1)).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).build());
        LOGGER.info("Connecting to the Bigtable emulator at " + hostname + ":" + port);
        return builder;
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        private final BigtableInstanceAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableInstanceAdminStubSettings.newBuilder();
        }

        private Builder(BigtableInstanceAdminSettings settings) {
            this.projectId = settings.projectId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        public BigtableInstanceAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableInstanceAdminSettings build() throws IOException {
            return new BigtableInstanceAdminSettings(this);
        }
    }
}

