/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@InternalApi
public class MeasuredMutateRowsCallable
extends UnaryCallable<BulkMutation, Void> {
    private final UnaryCallable<BulkMutation, Void> innerCallable;
    private final TagValue methodName;
    private final TagContext parentCtx;
    private final Tagger tagger;
    private final StatsRecorder stats;
    private final ApiClock clock;

    @InternalApi
    public MeasuredMutateRowsCallable(@Nonnull UnaryCallable<BulkMutation, Void> innerCallable, @Nonnull String methodName, @Nonnull Tagger tagger, @Nonnull StatsRecorder stats, @Nonnull ApiClock clock) {
        this.innerCallable = (UnaryCallable)Preconditions.checkNotNull(innerCallable, (Object)"innerCallable");
        this.methodName = TagValue.create((String)((String)Preconditions.checkNotNull((Object)methodName, (Object)"methodName")));
        this.tagger = (Tagger)Preconditions.checkNotNull((Object)tagger, (Object)"tagger");
        this.parentCtx = tagger.getCurrentTagContext();
        this.stats = (StatsRecorder)Preconditions.checkNotNull((Object)stats, (Object)"stats");
        this.clock = (ApiClock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
    }

    public ApiFuture<Void> futureCall(BulkMutation request, ApiCallContext context) {
        long operationStartTime = this.clock.nanoTime();
        ApiFuture future = this.innerCallable.futureCall((Object)request, context);
        future.addListener((Runnable)new StatsRecordingRunnable((Future)future, operationStartTime, request.getEntryCount()), MoreExecutors.directExecutor());
        return future;
    }

    private class StatsRecordingRunnable
    implements Runnable {
        private final Future<?> operationFuture;
        private final long operationStart;
        private final long numEntries;

        private StatsRecordingRunnable(Future<?> operationFuture, long operationStartTime, long numEntries) {
            this.operationFuture = (Future)Preconditions.checkNotNull(operationFuture, (Object)"operationFuture");
            this.operationStart = operationStartTime;
            this.numEntries = numEntries;
        }

        @Override
        public void run() {
            long elapsed = TimeUnit.NANOSECONDS.toMillis(MeasuredMutateRowsCallable.this.clock.nanoTime() - this.operationStart);
            MeasuredMutateRowsCallable.this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_OP_LATENCY, (double)elapsed).put(RpcMeasureConstants.BIGTABLE_MUTATE_ROWS_ENTRIES_PER_BATCH, this.numEntries).record(MeasuredMutateRowsCallable.this.tagger.toBuilder(MeasuredMutateRowsCallable.this.parentCtx).putLocal(RpcMeasureConstants.BIGTABLE_OP, MeasuredMutateRowsCallable.this.methodName).putLocal(RpcMeasureConstants.BIGTABLE_STATUS, Util.extractStatus(this.operationFuture)).build());
        }
    }
}

