package com.google.cloud.bigtable.data.v2.models;

import com.google.protobuf.ByteString;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_KeyOffset extends KeyOffset {

  private final ByteString key;

  private final long offsetBytes;

  AutoValue_KeyOffset(
      ByteString key,
      long offsetBytes) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    this.offsetBytes = offsetBytes;
  }

  @Override
  public ByteString getKey() {
    return key;
  }

  @Override
  public long getOffsetBytes() {
    return offsetBytes;
  }

  @Override
  public String toString() {
    return "KeyOffset{"
         + "key=" + key + ", "
         + "offsetBytes=" + offsetBytes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof KeyOffset) {
      KeyOffset that = (KeyOffset) o;
      return this.key.equals(that.getKey())
          && this.offsetBytes == that.getOffsetBytes();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((offsetBytes >>> 32) ^ offsetBytes);
    return h$;
  }

}
