/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

@InternalApi(value="For internal use only")
public class CompositeTracerFactory
implements ApiTracerFactory {
    private final List<ApiTracerFactory> apiTracerFactories;

    public CompositeTracerFactory(List<ApiTracerFactory> apiTracerFactories) {
        this.apiTracerFactories = ImmutableList.copyOf(apiTracerFactories);
    }

    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        ArrayList<ApiTracer> children = new ArrayList<ApiTracer>(this.apiTracerFactories.size());
        for (ApiTracerFactory factory : this.apiTracerFactories) {
            children.add(factory.newTracer(parent, spanName, operationType));
        }
        return new CompositeTracer(children);
    }
}

