/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.BulkMutateRowsUserFacingCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsRetryingCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsResumptionStrategy;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsUserCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.cloud.bigtable.gaxx.retrying.ApiResultRetryAlgorithm;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private static final String CLIENT_NAME = "Bigtable";
    private final EnhancedBigtableStubSettings settings;
    private final ClientContext clientContext;
    private final RequestContext requestContext;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<Query, Row> readRowCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;
    private final UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable;
    private final UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        ClientContext clientContext = ClientContext.create((StubSettings)settings);
        return new EnhancedBigtableStub(settings, clientContext, Tags.getTagger(), Stats.getStatsRecorder());
    }

    @InternalApi(value="Visible for testing")
    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext, Tagger tagger, StatsRecorder statsRecorder) {
        this.settings = settings;
        this.clientContext = clientContext.toBuilder().setTracerFactory((ApiTracerFactory)new CompositeTracerFactory((List<ApiTracerFactory>)ImmutableList.of((Object)new OpencensusTracerFactory((Map)ImmutableMap.builder().put((Object)RpcMeasureConstants.BIGTABLE_PROJECT_ID.getName(), (Object)settings.getProjectId()).put((Object)RpcMeasureConstants.BIGTABLE_INSTANCE_ID.getName(), (Object)settings.getInstanceId()).put((Object)RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID.getName(), (Object)settings.getAppProfileId()).put((Object)"gax", (Object)GaxGrpcProperties.getGaxGrpcVersion()).put((Object)"grpc", (Object)GaxGrpcProperties.getGrpcVersion()).put((Object)"gapic", (Object)GaxProperties.getLibraryVersion(EnhancedBigtableStubSettings.class)).build()), (Object)MetricsTracerFactory.create(tagger, statsRecorder, (ImmutableMap<TagKey, TagValue>)ImmutableMap.builder().put((Object)RpcMeasureConstants.BIGTABLE_PROJECT_ID, (Object)TagValue.create((String)settings.getProjectId())).put((Object)RpcMeasureConstants.BIGTABLE_INSTANCE_ID, (Object)TagValue.create((String)settings.getInstanceId())).put((Object)RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID, (Object)TagValue.create((String)settings.getAppProfileId())).build()), (Object)clientContext.getTracerFactory()))).build();
        this.requestContext = RequestContext.create(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.readRowCallable = this.createReadRowCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.mutateRowCallable = this.createMutateRowCallable();
        this.bulkMutateRowsCallable = this.createBulkMutateRowsCallable();
        this.checkAndMutateRowCallable = this.createCheckAndMutateRowCallable();
        this.readModifyWriteRowCallable = this.createReadModifyWriteRowCallable();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public <RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsRawCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter).withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readRowsUserCallable, this.clientContext.getTracerFactory(), SpanName.of((String)CLIENT_NAME, (String)"ReadRows"));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> UnaryCallable<Query, RowT> createReadRowCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.readRowSettings().getRetryableCodes()).setRetrySettings(this.settings.readRowSettings().getRetrySettings()).setIdleTimeout(this.settings.readRowSettings().getRetrySettings().getTotalTimeout()).build(), rowAdapter);
        UnaryCallable<Query, RowT> readRowCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext).first();
        return this.createUserFacingUnaryCallable("ReadRow", readRowCallable);
    }

    private <ReqT, RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsBaseCallable(ServerStreamingCallSettings<ReqT, Row> readRowsSettings, RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRowsRequest>(){

            public Map<String, String> extract(ReadRowsRequest readRowsRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)readRowsRequest.getTableName(), (Object)"app_profile_id", (Object)readRowsRequest.getAppProfileId());
            }
        }).build(), (Set)readRowsSettings.getRetryableCodes());
        RowMergingCallable<RowT> merging = new RowMergingCallable<RowT>((ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse>)base, rowAdapter);
        ServerStreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadRowsResumptionStrategy<RowT>(rowAdapter)).setRetryableCodes(readRowsSettings.getRetryableCodes()).setRetrySettings(readRowsSettings.getRetrySettings()).setIdleTimeout(readRowsSettings.getIdleTimeout()).build();
        ServerStreamingCallable watched = Callables.watched(merging, (ServerStreamingCallSettings)innerSettings, (ClientContext)this.clientContext);
        ReadRowsRetryCompletedCallable retrying1 = new ReadRowsRetryCompletedCallable(watched);
        ServerStreamingCallable retrying2 = Callables.retrying(retrying1, (ServerStreamingCallSettings)innerSettings, (ClientContext)this.clientContext);
        return new FilterMarkerRowsCallable<RowT>(retrying2, rowAdapter);
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getSampleRowKeysMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SampleRowKeysRequest>(){

            public Map<String, String> extract(SampleRowKeysRequest sampleRowKeysRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)sampleRowKeysRequest.getTableName(), (Object)"app_profile_id", (Object)sampleRowKeysRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.sampleRowKeysSettings().getRetryableCodes());
        UnaryCallable spoolable = base.all();
        UnaryCallable retryable = Callables.retrying((UnaryCallable)spoolable, this.settings.sampleRowKeysSettings(), (ClientContext)this.clientContext);
        return this.createUserFacingUnaryCallable("SampleRowKeys", new SampleRowKeysCallable((UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>>)retryable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        UnaryCallable base = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateRowRequest>(){

            public Map<String, String> extract(MutateRowRequest mutateRowRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)mutateRowRequest.getTableName(), (Object)"app_profile_id", (Object)mutateRowRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.mutateRowSettings().getRetryableCodes());
        UnaryCallable retrying = Callables.retrying((UnaryCallable)base, this.settings.mutateRowSettings(), (ClientContext)this.clientContext);
        return this.createUserFacingUnaryCallable("MutateRow", new MutateRowCallable((UnaryCallable<MutateRowRequest, MutateRowResponse>)retrying, this.requestContext));
    }

    private UnaryCallable<BulkMutation, Void> createBulkMutateRowsCallable() {
        UnaryCallable<MutateRowsRequest, Void> baseCallable = this.createMutateRowsBaseCallable();
        BulkMutateRowsUserFacingCallable userFacing = new BulkMutateRowsUserFacingCallable(baseCallable, this.requestContext);
        TracedUnaryCallable traced = new TracedUnaryCallable((UnaryCallable)userFacing, this.clientContext.getTracerFactory(), SpanName.of((String)CLIENT_NAME, (String)"MutateRows"));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public Batcher<RowMutationEntry, Void> newMutateRowsBatcher(@Nonnull String tableId) {
        return new BatcherImpl(this.settings.bulkMutateRowsSettings().getBatchingDescriptor(), this.bulkMutateRowsCallable, (Object)BulkMutation.create(tableId), this.settings.bulkMutateRowsSettings().getBatchingSettings(), this.clientContext.getExecutor());
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(@Nonnull Query query) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        return new BatcherImpl(this.settings.bulkReadRowsSettings().getBatchingDescriptor(), this.readRowsCallable().all(), (Object)query, this.settings.bulkReadRowsSettings().getBatchingSettings(), this.clientContext.getExecutor());
    }

    private UnaryCallable<MutateRowsRequest, Void> createMutateRowsBaseCallable() {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateRowsRequest>(){

            public Map<String, String> extract(MutateRowsRequest mutateRowsRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)mutateRowsRequest.getTableName(), (Object)"app_profile_id", (Object)mutateRowsRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.bulkMutateRowsSettings().getRetryableCodes());
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm(new ApiResultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(this.settings.bulkMutateRowsSettings().getRetrySettings(), this.clientContext.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor(retryAlgorithm, this.clientContext.getExecutor());
        return new MutateRowsRetryingCallable(this.clientContext.getDefaultCallContext(), (ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse>)base, (RetryingExecutorWithContext<Void>)retryingExecutor, this.settings.bulkMutateRowsSettings().getRetryableCodes());
    }

    private UnaryCallable<ConditionalRowMutation, Boolean> createCheckAndMutateRowCallable() {
        UnaryCallable base = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getCheckAndMutateRowMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CheckAndMutateRowRequest>(){

            public Map<String, String> extract(CheckAndMutateRowRequest checkAndMutateRowRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)checkAndMutateRowRequest.getTableName(), (Object)"app_profile_id", (Object)checkAndMutateRowRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.checkAndMutateRowSettings().getRetryableCodes());
        UnaryCallable retrying = Callables.retrying((UnaryCallable)base, this.settings.checkAndMutateRowSettings(), (ClientContext)this.clientContext);
        return this.createUserFacingUnaryCallable("CheckAndMutateRow", new CheckAndMutateRowCallable((UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse>)retrying, this.requestContext));
    }

    private UnaryCallable<ReadModifyWriteRow, Row> createReadModifyWriteRowCallable() {
        UnaryCallable base = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadModifyWriteRowMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadModifyWriteRowRequest>(){

            public Map<String, String> extract(ReadModifyWriteRowRequest request) {
                return ImmutableMap.of((Object)"table_name", (Object)request.getTableName(), (Object)"app_profile_id", (Object)request.getAppProfileId());
            }
        }).build(), (Set)this.settings.readModifyWriteRowSettings().getRetryableCodes());
        UnaryCallable retrying = Callables.retrying((UnaryCallable)base, this.settings.readModifyWriteRowSettings(), (ClientContext)this.clientContext);
        return this.createUserFacingUnaryCallable("ReadModifyWriteRow", new ReadModifyWriteRowCallable((UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse>)retrying, this.requestContext));
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUserFacingUnaryCallable(String methodName, UnaryCallable<RequestT, ResponseT> inner) {
        TracedUnaryCallable traced = new TracedUnaryCallable(inner, this.clientContext.getTracerFactory(), SpanName.of((String)CLIENT_NAME, (String)methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.readRowCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    public UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable() {
        return this.bulkMutateRowsCallable;
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    @Override
    public void close() {
        for (BackgroundResource backgroundResource : this.clientContext.getBackgroundResources()) {
            backgroundResource.shutdown();
        }
    }
}

