/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotMetadata;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotName;
import com.google.bigtable.admin.v2.SnapshotTableMetadata;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BaseBigtableTableAdminClient
implements BackgroundResource {
    private final BaseBigtableTableAdminSettings settings;
    private final BigtableTableAdminStub stub;
    private final OperationsClient operationsClient;

    public static final BaseBigtableTableAdminClient create() throws IOException {
        return BaseBigtableTableAdminClient.create(BaseBigtableTableAdminSettings.newBuilder().build());
    }

    public static final BaseBigtableTableAdminClient create(BaseBigtableTableAdminSettings settings) throws IOException {
        return new BaseBigtableTableAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BaseBigtableTableAdminClient create(BigtableTableAdminStub stub) {
        return new BaseBigtableTableAdminClient(stub);
    }

    protected BaseBigtableTableAdminClient(BaseBigtableTableAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigtableTableAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BaseBigtableTableAdminClient(BigtableTableAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BaseBigtableTableAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigtableTableAdminStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Table createTable(InstanceName parent, String tableId, Table table) {
        CreateTableRequest request = CreateTableRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTableId(tableId).setTable(table).build();
        return this.createTable(request);
    }

    public final Table createTable(String parent, String tableId, Table table) {
        CreateTableRequest request = CreateTableRequest.newBuilder().setParent(parent).setTableId(tableId).setTable(table).build();
        return this.createTable(request);
    }

    public final Table createTable(CreateTableRequest request) {
        return (Table)this.createTableCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTableRequest, Table> createTableCallable() {
        return this.stub.createTableCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(InstanceName parent, String tableId, SnapshotName sourceSnapshot) {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTableId(tableId).setSourceSnapshot(sourceSnapshot == null ? null : sourceSnapshot.toString()).build();
        return this.createTableFromSnapshotAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(String parent, String tableId, String sourceSnapshot) {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(parent).setTableId(tableId).setSourceSnapshot(sourceSnapshot).build();
        return this.createTableFromSnapshotAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest request) {
        return this.createTableFromSnapshotOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationCallable() {
        return this.stub.createTableFromSnapshotOperationCallable();
    }

    public final UnaryCallable<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotCallable() {
        return this.stub.createTableFromSnapshotCallable();
    }

    public final ListTablesPagedResponse listTables(InstanceName parent) {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTables(request);
    }

    public final ListTablesPagedResponse listTables(String parent) {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(parent).build();
        return this.listTables(request);
    }

    public final ListTablesPagedResponse listTables(ListTablesRequest request) {
        return (ListTablesPagedResponse)((Object)this.listTablesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTablesRequest, ListTablesPagedResponse> listTablesPagedCallable() {
        return this.stub.listTablesPagedCallable();
    }

    public final UnaryCallable<ListTablesRequest, ListTablesResponse> listTablesCallable() {
        return this.stub.listTablesCallable();
    }

    public final Table getTable(TableName name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTable(request);
    }

    public final Table getTable(String name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name).build();
        return this.getTable(request);
    }

    public final Table getTable(GetTableRequest request) {
        return (Table)this.getTableCallable().call((Object)request);
    }

    public final UnaryCallable<GetTableRequest, Table> getTableCallable() {
        return this.stub.getTableCallable();
    }

    public final void deleteTable(TableName name) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTable(request);
    }

    public final void deleteTable(String name) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(name).build();
        this.deleteTable(request);
    }

    public final void deleteTable(DeleteTableRequest request) {
        this.deleteTableCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTableRequest, Empty> deleteTableCallable() {
        return this.stub.deleteTableCallable();
    }

    public final Table modifyColumnFamilies(TableName name, List<ModifyColumnFamiliesRequest.Modification> modifications) {
        ModifyColumnFamiliesRequest request = ModifyColumnFamiliesRequest.newBuilder().setName(name == null ? null : name.toString()).addAllModifications(modifications).build();
        return this.modifyColumnFamilies(request);
    }

    public final Table modifyColumnFamilies(String name, List<ModifyColumnFamiliesRequest.Modification> modifications) {
        ModifyColumnFamiliesRequest request = ModifyColumnFamiliesRequest.newBuilder().setName(name).addAllModifications(modifications).build();
        return this.modifyColumnFamilies(request);
    }

    public final Table modifyColumnFamilies(ModifyColumnFamiliesRequest request) {
        return (Table)this.modifyColumnFamiliesCallable().call((Object)request);
    }

    public final UnaryCallable<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesCallable() {
        return this.stub.modifyColumnFamiliesCallable();
    }

    public final void dropRowRange(DropRowRangeRequest request) {
        this.dropRowRangeCallable().call((Object)request);
    }

    public final UnaryCallable<DropRowRangeRequest, Empty> dropRowRangeCallable() {
        return this.stub.dropRowRangeCallable();
    }

    public final GenerateConsistencyTokenResponse generateConsistencyToken(TableName name) {
        GenerateConsistencyTokenRequest request = GenerateConsistencyTokenRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.generateConsistencyToken(request);
    }

    public final GenerateConsistencyTokenResponse generateConsistencyToken(String name) {
        GenerateConsistencyTokenRequest request = GenerateConsistencyTokenRequest.newBuilder().setName(name).build();
        return this.generateConsistencyToken(request);
    }

    public final GenerateConsistencyTokenResponse generateConsistencyToken(GenerateConsistencyTokenRequest request) {
        return (GenerateConsistencyTokenResponse)this.generateConsistencyTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenCallable() {
        return this.stub.generateConsistencyTokenCallable();
    }

    public final CheckConsistencyResponse checkConsistency(TableName name, String consistencyToken) {
        CheckConsistencyRequest request = CheckConsistencyRequest.newBuilder().setName(name == null ? null : name.toString()).setConsistencyToken(consistencyToken).build();
        return this.checkConsistency(request);
    }

    public final CheckConsistencyResponse checkConsistency(String name, String consistencyToken) {
        CheckConsistencyRequest request = CheckConsistencyRequest.newBuilder().setName(name).setConsistencyToken(consistencyToken).build();
        return this.checkConsistency(request);
    }

    public final CheckConsistencyResponse checkConsistency(CheckConsistencyRequest request) {
        return (CheckConsistencyResponse)this.checkConsistencyCallable().call((Object)request);
    }

    public final UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencyCallable() {
        return this.stub.checkConsistencyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(TableName name, ClusterName cluster, SnapshotName snapshotId, String description) {
        SnapshotTableRequest request = SnapshotTableRequest.newBuilder().setName(name == null ? null : name.toString()).setCluster(cluster == null ? null : cluster.toString()).setSnapshotId(snapshotId == null ? null : snapshotId.toString()).setDescription(description).build();
        return this.snapshotTableAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(String name, String cluster, String snapshotId, String description) {
        SnapshotTableRequest request = SnapshotTableRequest.newBuilder().setName(name).setCluster(cluster).setSnapshotId(snapshotId).setDescription(description).build();
        return this.snapshotTableAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Snapshot, SnapshotTableMetadata> snapshotTableAsync(SnapshotTableRequest request) {
        return this.snapshotTableOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationCallable() {
        return this.stub.snapshotTableOperationCallable();
    }

    public final UnaryCallable<SnapshotTableRequest, Operation> snapshotTableCallable() {
        return this.stub.snapshotTableCallable();
    }

    public final Snapshot getSnapshot(SnapshotName name) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSnapshot(request);
    }

    public final Snapshot getSnapshot(String name) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setName(name).build();
        return this.getSnapshot(request);
    }

    public final Snapshot getSnapshot(GetSnapshotRequest request) {
        return (Snapshot)this.getSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.stub.getSnapshotCallable();
    }

    public final ListSnapshotsPagedResponse listSnapshots(ClusterName parent) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(String parent) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(parent).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(ListSnapshotsRequest request) {
        return (ListSnapshotsPagedResponse)((Object)this.listSnapshotsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.stub.listSnapshotsPagedCallable();
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.stub.listSnapshotsCallable();
    }

    public final void deleteSnapshot(SnapshotName name) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSnapshot(request);
    }

    public final void deleteSnapshot(String name) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(name).build();
        this.deleteSnapshot(request);
    }

    public final void deleteSnapshot(DeleteSnapshotRequest request) {
        this.deleteSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable() {
        return this.stub.deleteSnapshotCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        private ListSnapshotsFixedSizeCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListSnapshotsFixedSizeCollection createCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            return new ListSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnapshotsPage
    extends AbstractPage<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage> {
        private ListSnapshotsPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            super(context, (Object)response);
        }

        private static ListSnapshotsPage createEmptyPage() {
            return new ListSnapshotsPage(null, null);
        }

        protected ListSnapshotsPage createPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            return new ListSnapshotsPage(context, response);
        }

        public ApiFuture<ListSnapshotsPage> createPageAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListSnapshotsPagedResponse> createAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            ApiFuture<ListSnapshotsPage> futurePage = ListSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSnapshotsPage, ListSnapshotsPagedResponse>(){

                public ListSnapshotsPagedResponse apply(ListSnapshotsPage input) {
                    return new ListSnapshotsPagedResponse(input);
                }
            });
        }

        private ListSnapshotsPagedResponse(ListSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTablesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        private ListTablesFixedSizeCollection(List<ListTablesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTablesFixedSizeCollection createEmptyCollection() {
            return new ListTablesFixedSizeCollection(null, 0);
        }

        protected ListTablesFixedSizeCollection createCollection(List<ListTablesPage> pages, int collectionSize) {
            return new ListTablesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTablesPage
    extends AbstractPage<ListTablesRequest, ListTablesResponse, Table, ListTablesPage> {
        private ListTablesPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            super(context, (Object)response);
        }

        private static ListTablesPage createEmptyPage() {
            return new ListTablesPage(null, null);
        }

        protected ListTablesPage createPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            return new ListTablesPage(context, response);
        }

        public ApiFuture<ListTablesPage> createPageAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTablesPagedResponse
    extends AbstractPagedListResponse<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        public static ApiFuture<ListTablesPagedResponse> createAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            ApiFuture<ListTablesPage> futurePage = ListTablesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTablesPage, ListTablesPagedResponse>(){

                public ListTablesPagedResponse apply(ListTablesPage input) {
                    return new ListTablesPagedResponse(input);
                }
            });
        }

        private ListTablesPagedResponse(ListTablesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTablesFixedSizeCollection.createEmptyCollection());
        }
    }
}

