/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowController;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.AutoValue_ConnectionWorkerPool_Settings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import javax.annotation.concurrent.GuardedBy;

public class ConnectionWorkerPool {
    private final long maxInflightRequests;
    private final long maxInflightBytes;
    private final FlowController.LimitExceededBehavior limitExceededBehavior;
    private final String traceId;
    @GuardedBy(value="lock")
    private long inflightRequests = 0L;
    @GuardedBy(value="lock")
    private long inflightBytes = 0L;
    @GuardedBy(value="lock")
    private long conectionRetryCountWithoutCallback = 0L;
    @GuardedBy(value="lock")
    private boolean streamConnectionIsConnected = false;
    @GuardedBy(value="lock")
    private boolean inflightCleanuped = false;
    @GuardedBy(value="lock")
    private boolean userClosed = false;
    @GuardedBy(value="lock")
    private Throwable connectionFinalStatus = null;
    @GuardedBy(value="lock")
    private TableSchema updatedSchema;
    private BigQueryWriteClient client;
    private boolean ownsBigQueryWriteClient = false;
    private static Settings settings = Settings.builder().build();

    public ConnectionWorkerPool(long maxInflightRequests, long maxInflightBytes, FlowController.LimitExceededBehavior limitExceededBehavior, String traceId, BigQueryWriteClient client, boolean ownsBigQueryWriteClient) {
        this.maxInflightRequests = maxInflightRequests;
        this.maxInflightBytes = maxInflightBytes;
        this.limitExceededBehavior = limitExceededBehavior;
        this.traceId = traceId;
        this.client = client;
        this.ownsBigQueryWriteClient = ownsBigQueryWriteClient;
    }

    public static void setOptions(Settings settings) {
        ConnectionWorkerPool.settings = settings;
    }

    public ApiFuture<AppendRowsResponse> append(StreamWriter streamWriter, ProtoRows rows) {
        throw new RuntimeException("Append is not implemented!");
    }

    public ApiFuture<AppendRowsResponse> append(StreamWriter streamWriter, ProtoRows rows, long offset) {
        throw new RuntimeException("append with offset is not implemented on connection pool!");
    }

    public void close(StreamWriter streamWriter) {
        throw new RuntimeException("close is implemented on connection pool");
    }

    @AutoValue
    public static abstract class Settings {
        abstract int minConnectionsPerPool();

        abstract int maxConnectionsPerPool();

        public static Builder builder() {
            return new AutoValue_ConnectionWorkerPool_Settings.Builder().setMinConnectionsPerPool(2).setMaxConnectionsPerPool(10);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setMinConnectionsPerPool(int var1);

            public abstract Builder setMaxConnectionsPerPool(int var1);

            public abstract Settings build();
        }
    }
}

