/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStub;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStubSettings;
import com.google.cloud.bigquery.storage.v1beta1.stub.GrpcBigQueryStorageCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcBigQueryStorageStub
extends BigQueryStorageStub {
    private static final MethodDescriptor<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/CreateReadSession").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.CreateReadSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.ReadSession.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/ReadRows").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.ReadRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/BatchCreateReadSessionStreams").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.BatchCreateReadSessionStreamsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.BatchCreateReadSessionStreamsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.FinalizeStreamRequest, Empty> finalizeStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/FinalizeStream").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.FinalizeStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/SplitReadStream").setRequestMarshaller(ProtoUtils.marshaller((Message)Storage.SplitReadStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Storage.SplitReadStreamResponse.getDefaultInstance())).build();
    private final UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable;
    private final ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable;
    private final UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable;
    private final UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable;
    private final UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigQueryStorageStub create(BigQueryStorageStubSettings settings) throws IOException {
        return new GrpcBigQueryStorageStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBigQueryStorageStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigQueryStorageStub(BigQueryStorageStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigQueryStorageStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigQueryStorageStub(BigQueryStorageStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigQueryStorageStub(BigQueryStorageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigQueryStorageCallableFactory());
    }

    protected GrpcBigQueryStorageStub(BigQueryStorageStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createReadSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReadSessionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.CreateReadSessionRequest>(){

            public Map<String, String> extract(Storage.CreateReadSessionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_reference.dataset_id", (Object)String.valueOf(request.getTableReference().getDatasetId()));
                params.put((Object)"table_reference.project_id", (Object)String.valueOf(request.getTableReference().getProjectId()));
                return params.build();
            }
        }).build();
        GrpcCallSettings readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.ReadRowsRequest>(){

            public Map<String, String> extract(Storage.ReadRowsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"read_position.stream.name", (Object)String.valueOf(request.getReadPosition().getStream().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchCreateReadSessionStreamsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateReadSessionStreamsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.BatchCreateReadSessionStreamsRequest>(){

            public Map<String, String> extract(Storage.BatchCreateReadSessionStreamsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session.name", (Object)String.valueOf(request.getSession().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings finalizeStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(finalizeStreamMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.FinalizeStreamRequest>(){

            public Map<String, String> extract(Storage.FinalizeStreamRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"stream.name", (Object)String.valueOf(request.getStream().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings splitReadStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(splitReadStreamMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.SplitReadStreamRequest>(){

            public Map<String, String> extract(Storage.SplitReadStreamRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"original_stream.name", (Object)String.valueOf(request.getOriginalStream().getName()));
                return params.build();
            }
        }).build();
        this.createReadSessionCallable = callableFactory.createUnaryCallable(createReadSessionTransportSettings, settings.createReadSessionSettings(), clientContext);
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.batchCreateReadSessionStreamsCallable = callableFactory.createUnaryCallable(batchCreateReadSessionStreamsTransportSettings, settings.batchCreateReadSessionStreamsSettings(), clientContext);
        this.finalizeStreamCallable = callableFactory.createUnaryCallable(finalizeStreamTransportSettings, settings.finalizeStreamSettings(), clientContext);
        this.splitReadStreamCallable = callableFactory.createUnaryCallable(splitReadStreamTransportSettings, settings.splitReadStreamSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable() {
        return this.createReadSessionCallable;
    }

    @Override
    public ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable() {
        return this.batchCreateReadSessionStreamsCallable;
    }

    @Override
    public UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable() {
        return this.finalizeStreamCallable;
    }

    @Override
    public UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable() {
        return this.splitReadStreamCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

