/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1beta2.BQV2ToBQStorageConverter;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage;
import com.google.cloud.bigquery.storage.v1beta2.ProtoRows;
import com.google.cloud.bigquery.storage.v1beta2.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1beta2.StreamWriter;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Int64Value;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamWriter
implements AutoCloseable {
    private static String streamPatternString = "projects/[^/]+/datasets/[^/]+/tables/[^/]+/streams/[^/]+";
    private static Pattern streamPattern = Pattern.compile(streamPatternString);
    private static final Logger LOG = Logger.getLogger(JsonStreamWriter.class.getName());
    private BigQueryWriteClient client;
    private String streamName;
    private StreamWriter streamWriter;
    private StreamWriter.Builder streamWriterBuilder;
    private Descriptors.Descriptor descriptor;
    private TableSchema tableSchema;

    private JsonStreamWriter(Builder builder) throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
        this.client = builder.client;
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(builder.tableSchema);
        this.streamWriterBuilder = this.client == null ? StreamWriter.newBuilder(builder.streamOrTableName) : StreamWriter.newBuilder(builder.streamOrTableName, builder.client);
        this.setStreamWriterSettings(builder.channelProvider, builder.credentialsProvider, builder.endpoint, builder.flowControlSettings, builder.createDefaultStream);
        this.streamWriter = this.streamWriterBuilder.build();
        this.streamName = this.streamWriter.getStreamNameString();
    }

    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr) {
        return this.append(jsonArr, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr, long offset) {
        ProtoRows.Builder rowsBuilder = ProtoRows.newBuilder();
        for (int i = 0; i < jsonArr.length(); ++i) {
            JSONObject json = jsonArr.getJSONObject(i);
            DynamicMessage protoMessage = JsonToProtoMessage.convertJsonToProtoMessage(this.descriptor, json);
            rowsBuilder.addSerializedRows(protoMessage.toByteString());
        }
        AppendRowsRequest.ProtoData.Builder data = AppendRowsRequest.ProtoData.newBuilder();
        JsonStreamWriter jsonStreamWriter = this;
        synchronized (jsonStreamWriter) {
            data.setWriterSchema(ProtoSchemaConverter.convert(this.descriptor));
            data.setRows(rowsBuilder.build());
            AppendRowsRequest.Builder request = AppendRowsRequest.newBuilder().setProtoRows(data.build());
            if (offset >= 0L) {
                request.setOffset(Int64Value.of((long)offset));
            }
            ApiFuture<AppendRowsResponse> appendResponseFuture = this.streamWriter.append(request.build());
            return appendResponseFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshConnection() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        JsonStreamWriter jsonStreamWriter = this;
        synchronized (jsonStreamWriter) {
            this.streamWriter.shutdown();
            this.streamWriter = this.streamWriterBuilder.build();
            this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(this.tableSchema);
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void setStreamWriterSettings(@Nullable TransportChannelProvider channelProvider, @Nullable CredentialsProvider credentialsProvider, @Nullable String endpoint, @Nullable FlowControlSettings flowControlSettings, Boolean createDefaultStream) {
        if (channelProvider != null) {
            this.streamWriterBuilder.setChannelProvider(channelProvider);
        }
        if (credentialsProvider != null) {
            this.streamWriterBuilder.setCredentialsProvider(credentialsProvider);
        }
        BatchingSettings.Builder batchSettingBuilder = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).setRequestByteThreshold(Long.valueOf(0x400000L));
        if (flowControlSettings != null) {
            this.streamWriterBuilder.setBatchingSettings(batchSettingBuilder.setFlowControlSettings(flowControlSettings).build());
        } else {
            this.streamWriterBuilder.setBatchingSettings(batchSettingBuilder.build());
        }
        if (endpoint != null) {
            this.streamWriterBuilder.setEndpoint(endpoint);
        }
        if (createDefaultStream.booleanValue()) {
            this.streamWriterBuilder.createDefaultStream();
        }
    }

    void setTableSchema(TableSchema tableSchema) {
        this.tableSchema = tableSchema;
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        return new Builder(streamOrTableName, tableSchema, null);
    }

    public static Builder newBuilder(String streamOrTableName, Schema tableSchema) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        return new Builder(streamOrTableName, BQV2ToBQStorageConverter.ConvertTableSchema(tableSchema), null);
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        return new Builder(streamOrTableName, tableSchema, client);
    }

    @Override
    public void close() {
        this.streamWriter.close();
    }

    public static final class Builder {
        private String streamOrTableName;
        private BigQueryWriteClient client;
        private TableSchema tableSchema;
        private TransportChannelProvider channelProvider;
        private CredentialsProvider credentialsProvider;
        private FlowControlSettings flowControlSettings;
        private String endpoint;
        private boolean createDefaultStream = false;

        private Builder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
            this.streamOrTableName = streamOrTableName;
            this.tableSchema = tableSchema;
            this.client = client;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            Preconditions.checkNotNull((Object)flowControlSettings, (Object)"FlowControlSettings is null.");
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings, (Object)"FlowControlSettings is null.");
            return this;
        }

        public Builder createDefaultStream() {
            this.createDefaultStream = true;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public JsonStreamWriter build() throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
            return new JsonStreamWriter(this);
        }
    }
}

