/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.cloud.bigquery.storage.v1beta2.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class BQTableSchemaToProtoDescriptor {
    private static ImmutableMap<TableFieldSchema.Mode, DescriptorProtos.FieldDescriptorProto.Label> BQTableSchemaModeMap = ImmutableMap.of((Object)TableFieldSchema.Mode.NULLABLE, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, (Object)TableFieldSchema.Mode.REPEATED, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, (Object)TableFieldSchema.Mode.REQUIRED, (Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
    private static ImmutableMap<TableFieldSchema.Type, DescriptorProtos.FieldDescriptorProto.Type> BQTableSchemaTypeMap = new ImmutableMap.Builder().put((Object)TableFieldSchema.Type.BOOL, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)TableFieldSchema.Type.BYTES, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.DATE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)TableFieldSchema.Type.DATETIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.DOUBLE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.INT64, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.NUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.STRING, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.STRUCT, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).put((Object)TableFieldSchema.Type.TIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).build();

    public static Descriptors.Descriptor convertBQTableSchemaToProtoDescriptor(TableSchema BQTableSchema) throws Descriptors.DescriptorValidationException {
        Preconditions.checkNotNull((Object)BQTableSchema, (Object)"BQTableSchema is null.");
        return BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(BQTableSchema, "root", new HashMap<ImmutableList<TableFieldSchema>, Descriptors.Descriptor>());
    }

    private static Descriptors.Descriptor convertBQTableSchemaToProtoDescriptorImpl(TableSchema BQTableSchema, String scope, HashMap<ImmutableList<TableFieldSchema>, Descriptors.Descriptor> dependencyMap) throws Descriptors.DescriptorValidationException {
        Descriptors.Descriptor descriptor;
        ArrayList<Descriptors.FileDescriptor> dependenciesList = new ArrayList<Descriptors.FileDescriptor>();
        ArrayList<DescriptorProtos.FieldDescriptorProto> fields = new ArrayList<DescriptorProtos.FieldDescriptorProto>();
        int index = 1;
        for (TableFieldSchema BQTableField : BQTableSchema.getFieldsList()) {
            String currentScope = scope + "__" + BQTableField.getName();
            if (BQTableField.getType() == TableFieldSchema.Type.STRUCT) {
                ImmutableList fieldList = ImmutableList.copyOf((Collection)BQTableField.getFieldsList());
                if (dependencyMap.containsKey(fieldList)) {
                    descriptor = dependencyMap.get(fieldList);
                    dependenciesList.add(descriptor.getFile());
                    fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, descriptor.getName()));
                    continue;
                }
                descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(TableSchema.newBuilder().addAllFields((Iterable)fieldList).build(), currentScope, dependencyMap);
                dependenciesList.add(descriptor.getFile());
                dependencyMap.put((ImmutableList<TableFieldSchema>)fieldList, descriptor);
                fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
                continue;
            }
            fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
        }
        Descriptors.FileDescriptor[] dependenciesArray = new Descriptors.FileDescriptor[dependenciesList.size()];
        dependenciesArray = dependenciesList.toArray(dependenciesArray);
        DescriptorProtos.DescriptorProto descriptorProto = DescriptorProtos.DescriptorProto.newBuilder().setName(scope).addAllField(fields).build();
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])dependenciesArray);
        descriptor = fileDescriptor.findMessageTypeByName(scope);
        return descriptor;
    }

    private static DescriptorProtos.FieldDescriptorProto convertBQTableFieldToProtoField(TableFieldSchema BQTableField, int index, String scope) {
        TableFieldSchema.Mode mode = BQTableField.getMode();
        String fieldName = BQTableField.getName().toLowerCase();
        if (BQTableField.getType() == TableFieldSchema.Type.STRUCT) {
            return DescriptorProtos.FieldDescriptorProto.newBuilder().setName(fieldName).setTypeName(scope).setLabel((DescriptorProtos.FieldDescriptorProto.Label)BQTableSchemaModeMap.get((Object)mode)).setNumber(index).build();
        }
        return DescriptorProtos.FieldDescriptorProto.newBuilder().setName(fieldName).setType((DescriptorProtos.FieldDescriptorProto.Type)BQTableSchemaTypeMap.get((Object)BQTableField.getType())).setLabel((DescriptorProtos.FieldDescriptorProto.Label)BQTableSchemaModeMap.get((Object)mode)).setNumber(index).build();
    }
}

