/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnimplementedException;
import io.grpc.Status;
import java.util.logging.Logger;

class Waiter {
    private static final Logger LOG = Logger.getLogger(Waiter.class.getName());
    private int pendingCount = 0;
    private int pendingSize = 0;
    FlowControlSettings flowControlSettings;

    Waiter(FlowControlSettings flowControlSettings) {
        this.flowControlSettings = flowControlSettings;
    }

    public synchronized void incrementPendingCount(int delta) {
        this.pendingCount += delta;
        if (this.pendingCount == 0) {
            this.notifyAll();
        }
    }

    public synchronized void incrementPendingSize(int delta) {
        this.pendingSize += delta;
    }

    private void wait(String message) {
        boolean interrupted = false;
        try {
            LOG.fine("Wait on: " + message);
            this.wait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void handleOverLimit(String message) {
        boolean interrupted = false;
        switch (this.flowControlSettings.getLimitExceededBehavior()) {
            case Block: {
                this.wait(message);
                break;
            }
            case ThrowException: {
                throw new IllegalStateException("FlowControl limit exceeded: " + message);
            }
            case Ignore: {
                return;
            }
            default: {
                throw new UnimplementedException("Unknown behavior setting: " + this.flowControlSettings.getLimitExceededBehavior().toString(), null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNIMPLEMENTED), false);
            }
        }
    }

    public synchronized void waitOnElementCount() {
        LOG.finer("Waiting on element count " + this.pendingCount + " " + this.flowControlSettings.getMaxOutstandingElementCount());
        while ((long)this.pendingCount >= this.flowControlSettings.getMaxOutstandingElementCount()) {
            this.handleOverLimit("Element count");
        }
    }

    public synchronized void waitOnSizeLimit(int incomingSize) {
        LOG.finer("Waiting on size limit " + (this.pendingSize + incomingSize) + " " + this.flowControlSettings.getMaxOutstandingRequestBytes());
        while ((long)(this.pendingSize + incomingSize) >= this.flowControlSettings.getMaxOutstandingRequestBytes()) {
            this.handleOverLimit("Byte size");
        }
    }

    public synchronized void waitComplete() {
        boolean interrupted = false;
        try {
            while (this.pendingCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @InternalApi
    public int pendingCount() {
        return this.pendingCount;
    }

    @InternalApi
    public int pendingSize() {
        return this.pendingSize;
    }
}

