/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.reservation.v1.Assignment;
import com.google.cloud.bigquery.reservation.v1.BiReservation;
import com.google.cloud.bigquery.reservation.v1.CapacityCommitment;
import com.google.cloud.bigquery.reservation.v1.CreateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.GetReservationRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListReservationsRequest;
import com.google.cloud.bigquery.reservation.v1.ListReservationsResponse;
import com.google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.Reservation;
import com.google.cloud.bigquery.reservation.v1.ReservationServiceClient;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse;
import com.google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.stub.GrpcReservationServiceStub;
import com.google.cloud.bigquery.reservation.v1.stub.HttpJsonReservationServiceStub;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ReservationServiceStubSettings
extends StubSettings<ReservationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateReservationRequest, Reservation> createReservationSettings;
    private final PagedCallSettings<ListReservationsRequest, ListReservationsResponse, ReservationServiceClient.ListReservationsPagedResponse> listReservationsSettings;
    private final UnaryCallSettings<GetReservationRequest, Reservation> getReservationSettings;
    private final UnaryCallSettings<DeleteReservationRequest, Empty> deleteReservationSettings;
    private final UnaryCallSettings<UpdateReservationRequest, Reservation> updateReservationSettings;
    private final UnaryCallSettings<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentSettings;
    private final PagedCallSettings<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsSettings;
    private final UnaryCallSettings<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentSettings;
    private final UnaryCallSettings<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentSettings;
    private final UnaryCallSettings<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentSettings;
    private final UnaryCallSettings<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentSettings;
    private final UnaryCallSettings<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsSettings;
    private final UnaryCallSettings<CreateAssignmentRequest, Assignment> createAssignmentSettings;
    private final PagedCallSettings<ListAssignmentsRequest, ListAssignmentsResponse, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsSettings;
    private final UnaryCallSettings<DeleteAssignmentRequest, Empty> deleteAssignmentSettings;
    private final PagedCallSettings<SearchAssignmentsRequest, SearchAssignmentsResponse, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsSettings;
    private final PagedCallSettings<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsSettings;
    private final UnaryCallSettings<MoveAssignmentRequest, Assignment> moveAssignmentSettings;
    private final UnaryCallSettings<UpdateAssignmentRequest, Assignment> updateAssignmentSettings;
    private final UnaryCallSettings<GetBiReservationRequest, BiReservation> getBiReservationSettings;
    private final UnaryCallSettings<UpdateBiReservationRequest, BiReservation> updateBiReservationSettings;
    private static final PagedListDescriptor<ListReservationsRequest, ListReservationsResponse, Reservation> LIST_RESERVATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListReservationsRequest, ListReservationsResponse, Reservation>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationsRequest injectToken(ListReservationsRequest payload, String token) {
            return ListReservationsRequest.newBuilder((ListReservationsRequest)payload).setPageToken(token).build();
        }

        public ListReservationsRequest injectPageSize(ListReservationsRequest payload, int pageSize) {
            return ListReservationsRequest.newBuilder((ListReservationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReservationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReservationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reservation> extractResources(ListReservationsResponse payload) {
            return payload.getReservationsList();
        }
    };
    private static final PagedListDescriptor<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment> LIST_CAPACITY_COMMITMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment>(){

        public String emptyToken() {
            return "";
        }

        public ListCapacityCommitmentsRequest injectToken(ListCapacityCommitmentsRequest payload, String token) {
            return ListCapacityCommitmentsRequest.newBuilder((ListCapacityCommitmentsRequest)payload).setPageToken(token).build();
        }

        public ListCapacityCommitmentsRequest injectPageSize(ListCapacityCommitmentsRequest payload, int pageSize) {
            return ListCapacityCommitmentsRequest.newBuilder((ListCapacityCommitmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCapacityCommitmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCapacityCommitmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CapacityCommitment> extractResources(ListCapacityCommitmentsResponse payload) {
            return payload.getCapacityCommitmentsList();
        }
    };
    private static final PagedListDescriptor<ListAssignmentsRequest, ListAssignmentsResponse, Assignment> LIST_ASSIGNMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAssignmentsRequest, ListAssignmentsResponse, Assignment>(){

        public String emptyToken() {
            return "";
        }

        public ListAssignmentsRequest injectToken(ListAssignmentsRequest payload, String token) {
            return ListAssignmentsRequest.newBuilder((ListAssignmentsRequest)payload).setPageToken(token).build();
        }

        public ListAssignmentsRequest injectPageSize(ListAssignmentsRequest payload, int pageSize) {
            return ListAssignmentsRequest.newBuilder((ListAssignmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssignmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAssignmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Assignment> extractResources(ListAssignmentsResponse payload) {
            return payload.getAssignmentsList();
        }
    };
    private static final PagedListDescriptor<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment> SEARCH_ASSIGNMENTS_PAGE_STR_DESC = new PagedListDescriptor<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment>(){

        public String emptyToken() {
            return "";
        }

        public SearchAssignmentsRequest injectToken(SearchAssignmentsRequest payload, String token) {
            return SearchAssignmentsRequest.newBuilder((SearchAssignmentsRequest)payload).setPageToken(token).build();
        }

        public SearchAssignmentsRequest injectPageSize(SearchAssignmentsRequest payload, int pageSize) {
            return SearchAssignmentsRequest.newBuilder((SearchAssignmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAssignmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAssignmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Assignment> extractResources(SearchAssignmentsResponse payload) {
            return payload.getAssignmentsList();
        }
    };
    private static final PagedListDescriptor<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment> SEARCH_ALL_ASSIGNMENTS_PAGE_STR_DESC = new PagedListDescriptor<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment>(){

        public String emptyToken() {
            return "";
        }

        public SearchAllAssignmentsRequest injectToken(SearchAllAssignmentsRequest payload, String token) {
            return SearchAllAssignmentsRequest.newBuilder((SearchAllAssignmentsRequest)payload).setPageToken(token).build();
        }

        public SearchAllAssignmentsRequest injectPageSize(SearchAllAssignmentsRequest payload, int pageSize) {
            return SearchAllAssignmentsRequest.newBuilder((SearchAllAssignmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAllAssignmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAllAssignmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Assignment> extractResources(SearchAllAssignmentsResponse payload) {
            return payload.getAssignmentsList();
        }
    };
    private static final PagedListResponseFactory<ListReservationsRequest, ListReservationsResponse, ReservationServiceClient.ListReservationsPagedResponse> LIST_RESERVATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationsRequest, ListReservationsResponse, ReservationServiceClient.ListReservationsPagedResponse>(){

        public ApiFuture<ReservationServiceClient.ListReservationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationsRequest, ListReservationsResponse> callable, ListReservationsRequest request, ApiCallContext context, ApiFuture<ListReservationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESERVATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationServiceClient.ListReservationsPagedResponse.createAsync((PageContext<ListReservationsRequest, ListReservationsResponse, Reservation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> LIST_CAPACITY_COMMITMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, ReservationServiceClient.ListCapacityCommitmentsPagedResponse>(){

        public ApiFuture<ReservationServiceClient.ListCapacityCommitmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> callable, ListCapacityCommitmentsRequest request, ApiCallContext context, ApiFuture<ListCapacityCommitmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CAPACITY_COMMITMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationServiceClient.ListCapacityCommitmentsPagedResponse.createAsync((PageContext<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAssignmentsRequest, ListAssignmentsResponse, ReservationServiceClient.ListAssignmentsPagedResponse> LIST_ASSIGNMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssignmentsRequest, ListAssignmentsResponse, ReservationServiceClient.ListAssignmentsPagedResponse>(){

        public ApiFuture<ReservationServiceClient.ListAssignmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssignmentsRequest, ListAssignmentsResponse> callable, ListAssignmentsRequest request, ApiCallContext context, ApiFuture<ListAssignmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSIGNMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationServiceClient.ListAssignmentsPagedResponse.createAsync((PageContext<ListAssignmentsRequest, ListAssignmentsResponse, Assignment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchAssignmentsRequest, SearchAssignmentsResponse, ReservationServiceClient.SearchAssignmentsPagedResponse> SEARCH_ASSIGNMENTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchAssignmentsRequest, SearchAssignmentsResponse, ReservationServiceClient.SearchAssignmentsPagedResponse>(){

        public ApiFuture<ReservationServiceClient.SearchAssignmentsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsResponse> callable, SearchAssignmentsRequest request, ApiCallContext context, ApiFuture<SearchAssignmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ASSIGNMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationServiceClient.SearchAssignmentsPagedResponse.createAsync((PageContext<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, ReservationServiceClient.SearchAllAssignmentsPagedResponse> SEARCH_ALL_ASSIGNMENTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, ReservationServiceClient.SearchAllAssignmentsPagedResponse>(){

        public ApiFuture<ReservationServiceClient.SearchAllAssignmentsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> callable, SearchAllAssignmentsRequest request, ApiCallContext context, ApiFuture<SearchAllAssignmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ALL_ASSIGNMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationServiceClient.SearchAllAssignmentsPagedResponse.createAsync((PageContext<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateReservationRequest, Reservation> createReservationSettings() {
        return this.createReservationSettings;
    }

    public PagedCallSettings<ListReservationsRequest, ListReservationsResponse, ReservationServiceClient.ListReservationsPagedResponse> listReservationsSettings() {
        return this.listReservationsSettings;
    }

    public UnaryCallSettings<GetReservationRequest, Reservation> getReservationSettings() {
        return this.getReservationSettings;
    }

    public UnaryCallSettings<DeleteReservationRequest, Empty> deleteReservationSettings() {
        return this.deleteReservationSettings;
    }

    public UnaryCallSettings<UpdateReservationRequest, Reservation> updateReservationSettings() {
        return this.updateReservationSettings;
    }

    public UnaryCallSettings<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentSettings() {
        return this.createCapacityCommitmentSettings;
    }

    public PagedCallSettings<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsSettings() {
        return this.listCapacityCommitmentsSettings;
    }

    public UnaryCallSettings<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentSettings() {
        return this.getCapacityCommitmentSettings;
    }

    public UnaryCallSettings<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentSettings() {
        return this.deleteCapacityCommitmentSettings;
    }

    public UnaryCallSettings<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentSettings() {
        return this.updateCapacityCommitmentSettings;
    }

    public UnaryCallSettings<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentSettings() {
        return this.splitCapacityCommitmentSettings;
    }

    public UnaryCallSettings<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsSettings() {
        return this.mergeCapacityCommitmentsSettings;
    }

    public UnaryCallSettings<CreateAssignmentRequest, Assignment> createAssignmentSettings() {
        return this.createAssignmentSettings;
    }

    public PagedCallSettings<ListAssignmentsRequest, ListAssignmentsResponse, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsSettings() {
        return this.listAssignmentsSettings;
    }

    public UnaryCallSettings<DeleteAssignmentRequest, Empty> deleteAssignmentSettings() {
        return this.deleteAssignmentSettings;
    }

    @Deprecated
    public PagedCallSettings<SearchAssignmentsRequest, SearchAssignmentsResponse, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsSettings() {
        return this.searchAssignmentsSettings;
    }

    public PagedCallSettings<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsSettings() {
        return this.searchAllAssignmentsSettings;
    }

    public UnaryCallSettings<MoveAssignmentRequest, Assignment> moveAssignmentSettings() {
        return this.moveAssignmentSettings;
    }

    public UnaryCallSettings<UpdateAssignmentRequest, Assignment> updateAssignmentSettings() {
        return this.updateAssignmentSettings;
    }

    public UnaryCallSettings<GetBiReservationRequest, BiReservation> getBiReservationSettings() {
        return this.getBiReservationSettings;
    }

    public UnaryCallSettings<UpdateBiReservationRequest, BiReservation> updateBiReservationSettings() {
        return this.updateBiReservationSettings;
    }

    public ReservationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcReservationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReservationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "bigqueryreservation";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "bigqueryreservation.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigqueryreservation.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReservationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReservationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReservationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ReservationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReservationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createReservationSettings = settingsBuilder.createReservationSettings().build();
        this.listReservationsSettings = settingsBuilder.listReservationsSettings().build();
        this.getReservationSettings = settingsBuilder.getReservationSettings().build();
        this.deleteReservationSettings = settingsBuilder.deleteReservationSettings().build();
        this.updateReservationSettings = settingsBuilder.updateReservationSettings().build();
        this.createCapacityCommitmentSettings = settingsBuilder.createCapacityCommitmentSettings().build();
        this.listCapacityCommitmentsSettings = settingsBuilder.listCapacityCommitmentsSettings().build();
        this.getCapacityCommitmentSettings = settingsBuilder.getCapacityCommitmentSettings().build();
        this.deleteCapacityCommitmentSettings = settingsBuilder.deleteCapacityCommitmentSettings().build();
        this.updateCapacityCommitmentSettings = settingsBuilder.updateCapacityCommitmentSettings().build();
        this.splitCapacityCommitmentSettings = settingsBuilder.splitCapacityCommitmentSettings().build();
        this.mergeCapacityCommitmentsSettings = settingsBuilder.mergeCapacityCommitmentsSettings().build();
        this.createAssignmentSettings = settingsBuilder.createAssignmentSettings().build();
        this.listAssignmentsSettings = settingsBuilder.listAssignmentsSettings().build();
        this.deleteAssignmentSettings = settingsBuilder.deleteAssignmentSettings().build();
        this.searchAssignmentsSettings = settingsBuilder.searchAssignmentsSettings().build();
        this.searchAllAssignmentsSettings = settingsBuilder.searchAllAssignmentsSettings().build();
        this.moveAssignmentSettings = settingsBuilder.moveAssignmentSettings().build();
        this.updateAssignmentSettings = settingsBuilder.updateAssignmentSettings().build();
        this.getBiReservationSettings = settingsBuilder.getBiReservationSettings().build();
        this.updateBiReservationSettings = settingsBuilder.updateBiReservationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReservationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateReservationRequest, Reservation> createReservationSettings;
        private final PagedCallSettings.Builder<ListReservationsRequest, ListReservationsResponse, ReservationServiceClient.ListReservationsPagedResponse> listReservationsSettings;
        private final UnaryCallSettings.Builder<GetReservationRequest, Reservation> getReservationSettings;
        private final UnaryCallSettings.Builder<DeleteReservationRequest, Empty> deleteReservationSettings;
        private final UnaryCallSettings.Builder<UpdateReservationRequest, Reservation> updateReservationSettings;
        private final UnaryCallSettings.Builder<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentSettings;
        private final PagedCallSettings.Builder<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsSettings;
        private final UnaryCallSettings.Builder<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentSettings;
        private final UnaryCallSettings.Builder<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentSettings;
        private final UnaryCallSettings.Builder<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentSettings;
        private final UnaryCallSettings.Builder<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentSettings;
        private final UnaryCallSettings.Builder<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsSettings;
        private final UnaryCallSettings.Builder<CreateAssignmentRequest, Assignment> createAssignmentSettings;
        private final PagedCallSettings.Builder<ListAssignmentsRequest, ListAssignmentsResponse, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsSettings;
        private final UnaryCallSettings.Builder<DeleteAssignmentRequest, Empty> deleteAssignmentSettings;
        private final PagedCallSettings.Builder<SearchAssignmentsRequest, SearchAssignmentsResponse, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsSettings;
        private final PagedCallSettings.Builder<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsSettings;
        private final UnaryCallSettings.Builder<MoveAssignmentRequest, Assignment> moveAssignmentSettings;
        private final UnaryCallSettings.Builder<UpdateAssignmentRequest, Assignment> updateAssignmentSettings;
        private final UnaryCallSettings.Builder<GetBiReservationRequest, BiReservation> getBiReservationSettings;
        private final UnaryCallSettings.Builder<UpdateBiReservationRequest, BiReservation> updateBiReservationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReservationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESERVATIONS_PAGE_STR_FACT);
            this.getReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCapacityCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCapacityCommitmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CAPACITY_COMMITMENTS_PAGE_STR_FACT);
            this.getCapacityCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCapacityCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCapacityCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.splitCapacityCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mergeCapacityCommitmentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAssignmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSIGNMENTS_PAGE_STR_FACT);
            this.deleteAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchAssignmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ASSIGNMENTS_PAGE_STR_FACT);
            this.searchAllAssignmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ALL_ASSIGNMENTS_PAGE_STR_FACT);
            this.moveAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBiReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBiReservationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReservationSettings, this.listReservationsSettings, this.getReservationSettings, this.deleteReservationSettings, this.updateReservationSettings, this.createCapacityCommitmentSettings, this.listCapacityCommitmentsSettings, this.getCapacityCommitmentSettings, this.deleteCapacityCommitmentSettings, this.updateCapacityCommitmentSettings, this.splitCapacityCommitmentSettings, this.mergeCapacityCommitmentsSettings, (Object[])new UnaryCallSettings.Builder[]{this.createAssignmentSettings, this.listAssignmentsSettings, this.deleteAssignmentSettings, this.searchAssignmentsSettings, this.searchAllAssignmentsSettings, this.moveAssignmentSettings, this.updateAssignmentSettings, this.getBiReservationSettings, this.updateBiReservationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ReservationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createReservationSettings = settings.createReservationSettings.toBuilder();
            this.listReservationsSettings = settings.listReservationsSettings.toBuilder();
            this.getReservationSettings = settings.getReservationSettings.toBuilder();
            this.deleteReservationSettings = settings.deleteReservationSettings.toBuilder();
            this.updateReservationSettings = settings.updateReservationSettings.toBuilder();
            this.createCapacityCommitmentSettings = settings.createCapacityCommitmentSettings.toBuilder();
            this.listCapacityCommitmentsSettings = settings.listCapacityCommitmentsSettings.toBuilder();
            this.getCapacityCommitmentSettings = settings.getCapacityCommitmentSettings.toBuilder();
            this.deleteCapacityCommitmentSettings = settings.deleteCapacityCommitmentSettings.toBuilder();
            this.updateCapacityCommitmentSettings = settings.updateCapacityCommitmentSettings.toBuilder();
            this.splitCapacityCommitmentSettings = settings.splitCapacityCommitmentSettings.toBuilder();
            this.mergeCapacityCommitmentsSettings = settings.mergeCapacityCommitmentsSettings.toBuilder();
            this.createAssignmentSettings = settings.createAssignmentSettings.toBuilder();
            this.listAssignmentsSettings = settings.listAssignmentsSettings.toBuilder();
            this.deleteAssignmentSettings = settings.deleteAssignmentSettings.toBuilder();
            this.searchAssignmentsSettings = settings.searchAssignmentsSettings.toBuilder();
            this.searchAllAssignmentsSettings = settings.searchAllAssignmentsSettings.toBuilder();
            this.moveAssignmentSettings = settings.moveAssignmentSettings.toBuilder();
            this.updateAssignmentSettings = settings.updateAssignmentSettings.toBuilder();
            this.getBiReservationSettings = settings.getBiReservationSettings.toBuilder();
            this.updateBiReservationSettings = settings.updateBiReservationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReservationSettings, this.listReservationsSettings, this.getReservationSettings, this.deleteReservationSettings, this.updateReservationSettings, this.createCapacityCommitmentSettings, this.listCapacityCommitmentsSettings, this.getCapacityCommitmentSettings, this.deleteCapacityCommitmentSettings, this.updateCapacityCommitmentSettings, this.splitCapacityCommitmentSettings, this.mergeCapacityCommitmentsSettings, (Object[])new UnaryCallSettings.Builder[]{this.createAssignmentSettings, this.listAssignmentsSettings, this.deleteAssignmentSettings, this.searchAssignmentsSettings, this.searchAllAssignmentsSettings, this.moveAssignmentSettings, this.updateAssignmentSettings, this.getBiReservationSettings, this.updateBiReservationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReservationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReservationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReservationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReservationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ReservationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ReservationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReservationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReservationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listReservationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createCapacityCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listCapacityCommitmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getCapacityCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteCapacityCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateCapacityCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.splitCapacityCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.mergeCapacityCommitmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listAssignmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.searchAssignmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.searchAllAssignmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.moveAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getBiReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateBiReservationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateReservationRequest, Reservation> createReservationSettings() {
            return this.createReservationSettings;
        }

        public PagedCallSettings.Builder<ListReservationsRequest, ListReservationsResponse, ReservationServiceClient.ListReservationsPagedResponse> listReservationsSettings() {
            return this.listReservationsSettings;
        }

        public UnaryCallSettings.Builder<GetReservationRequest, Reservation> getReservationSettings() {
            return this.getReservationSettings;
        }

        public UnaryCallSettings.Builder<DeleteReservationRequest, Empty> deleteReservationSettings() {
            return this.deleteReservationSettings;
        }

        public UnaryCallSettings.Builder<UpdateReservationRequest, Reservation> updateReservationSettings() {
            return this.updateReservationSettings;
        }

        public UnaryCallSettings.Builder<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentSettings() {
            return this.createCapacityCommitmentSettings;
        }

        public PagedCallSettings.Builder<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsSettings() {
            return this.listCapacityCommitmentsSettings;
        }

        public UnaryCallSettings.Builder<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentSettings() {
            return this.getCapacityCommitmentSettings;
        }

        public UnaryCallSettings.Builder<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentSettings() {
            return this.deleteCapacityCommitmentSettings;
        }

        public UnaryCallSettings.Builder<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentSettings() {
            return this.updateCapacityCommitmentSettings;
        }

        public UnaryCallSettings.Builder<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentSettings() {
            return this.splitCapacityCommitmentSettings;
        }

        public UnaryCallSettings.Builder<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsSettings() {
            return this.mergeCapacityCommitmentsSettings;
        }

        public UnaryCallSettings.Builder<CreateAssignmentRequest, Assignment> createAssignmentSettings() {
            return this.createAssignmentSettings;
        }

        public PagedCallSettings.Builder<ListAssignmentsRequest, ListAssignmentsResponse, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsSettings() {
            return this.listAssignmentsSettings;
        }

        public UnaryCallSettings.Builder<DeleteAssignmentRequest, Empty> deleteAssignmentSettings() {
            return this.deleteAssignmentSettings;
        }

        @Deprecated
        public PagedCallSettings.Builder<SearchAssignmentsRequest, SearchAssignmentsResponse, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsSettings() {
            return this.searchAssignmentsSettings;
        }

        public PagedCallSettings.Builder<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsSettings() {
            return this.searchAllAssignmentsSettings;
        }

        public UnaryCallSettings.Builder<MoveAssignmentRequest, Assignment> moveAssignmentSettings() {
            return this.moveAssignmentSettings;
        }

        public UnaryCallSettings.Builder<UpdateAssignmentRequest, Assignment> updateAssignmentSettings() {
            return this.updateAssignmentSettings;
        }

        public UnaryCallSettings.Builder<GetBiReservationRequest, BiReservation> getBiReservationSettings() {
            return this.getBiReservationSettings;
        }

        public UnaryCallSettings.Builder<UpdateBiReservationRequest, BiReservation> updateBiReservationSettings() {
            return this.updateBiReservationSettings;
        }

        public ReservationServiceStubSettings build() throws IOException {
            return new ReservationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

