/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.reservation.v1.Assignment;
import com.google.cloud.bigquery.reservation.v1.BiReservation;
import com.google.cloud.bigquery.reservation.v1.CapacityCommitment;
import com.google.cloud.bigquery.reservation.v1.CreateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.GetReservationRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListReservationsRequest;
import com.google.cloud.bigquery.reservation.v1.ListReservationsResponse;
import com.google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.Reservation;
import com.google.cloud.bigquery.reservation.v1.ReservationServiceClient;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse;
import com.google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.stub.GrpcReservationServiceCallableFactory;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStub;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcReservationServiceStub
extends ReservationServiceStub {
    private static final MethodDescriptor<CreateReservationRequest, Reservation> createReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/CreateReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Reservation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListReservationsRequest, ListReservationsResponse> listReservationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/ListReservations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListReservationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListReservationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetReservationRequest, Reservation> getReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/GetReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Reservation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteReservationRequest, Empty> deleteReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/DeleteReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateReservationRequest, Reservation> updateReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Reservation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/CreateCapacityCommitment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCapacityCommitmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CapacityCommitment.getDefaultInstance())).build();
    private static final MethodDescriptor<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/ListCapacityCommitments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCapacityCommitmentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCapacityCommitmentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/GetCapacityCommitment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCapacityCommitmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CapacityCommitment.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/DeleteCapacityCommitment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteCapacityCommitmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateCapacityCommitment").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCapacityCommitmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CapacityCommitment.getDefaultInstance())).build();
    private static final MethodDescriptor<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/SplitCapacityCommitment").setRequestMarshaller(ProtoUtils.marshaller((Message)SplitCapacityCommitmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SplitCapacityCommitmentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/MergeCapacityCommitments").setRequestMarshaller(ProtoUtils.marshaller((Message)MergeCapacityCommitmentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CapacityCommitment.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateAssignmentRequest, Assignment> createAssignmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/CreateAssignment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAssignmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Assignment.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/ListAssignments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAssignmentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAssignmentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAssignmentRequest, Empty> deleteAssignmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/DeleteAssignment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAssignmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/SearchAssignments").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchAssignmentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchAssignmentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/SearchAllAssignments").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchAllAssignmentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchAllAssignmentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MoveAssignmentRequest, Assignment> moveAssignmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/MoveAssignment").setRequestMarshaller(ProtoUtils.marshaller((Message)MoveAssignmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Assignment.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateAssignmentRequest, Assignment> updateAssignmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateAssignment").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAssignmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Assignment.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBiReservationRequest, BiReservation> getBiReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/GetBiReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBiReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BiReservation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateBiReservationRequest, BiReservation> updateBiReservationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateBiReservation").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateBiReservationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BiReservation.getDefaultInstance())).build();
    private final UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable;
    private final UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable;
    private final UnaryCallable<ListReservationsRequest, ReservationServiceClient.ListReservationsPagedResponse> listReservationsPagedCallable;
    private final UnaryCallable<GetReservationRequest, Reservation> getReservationCallable;
    private final UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable;
    private final UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable;
    private final UnaryCallable<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentCallable;
    private final UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsCallable;
    private final UnaryCallable<ListCapacityCommitmentsRequest, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsPagedCallable;
    private final UnaryCallable<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentCallable;
    private final UnaryCallable<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentCallable;
    private final UnaryCallable<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentCallable;
    private final UnaryCallable<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentCallable;
    private final UnaryCallable<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsCallable;
    private final UnaryCallable<CreateAssignmentRequest, Assignment> createAssignmentCallable;
    private final UnaryCallable<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsCallable;
    private final UnaryCallable<ListAssignmentsRequest, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsPagedCallable;
    private final UnaryCallable<DeleteAssignmentRequest, Empty> deleteAssignmentCallable;
    private final UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsCallable;
    private final UnaryCallable<SearchAssignmentsRequest, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsPagedCallable;
    private final UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsCallable;
    private final UnaryCallable<SearchAllAssignmentsRequest, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsPagedCallable;
    private final UnaryCallable<MoveAssignmentRequest, Assignment> moveAssignmentCallable;
    private final UnaryCallable<UpdateAssignmentRequest, Assignment> updateAssignmentCallable;
    private final UnaryCallable<GetBiReservationRequest, BiReservation> getBiReservationCallable;
    private final UnaryCallable<UpdateBiReservationRequest, BiReservation> updateBiReservationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcReservationServiceStub create(ReservationServiceStubSettings settings) throws IOException {
        return new GrpcReservationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcReservationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcReservationServiceStub(ReservationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcReservationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcReservationServiceStub(ReservationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcReservationServiceStub(ReservationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcReservationServiceCallableFactory());
    }

    protected GrpcReservationServiceStub(ReservationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listReservationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listReservationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("reservation.name", String.valueOf(request.getReservation().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createCapacityCommitmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCapacityCommitmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listCapacityCommitmentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCapacityCommitmentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCapacityCommitmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCapacityCommitmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteCapacityCommitmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteCapacityCommitmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCapacityCommitmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCapacityCommitmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("capacity_commitment.name", String.valueOf(request.getCapacityCommitment().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings splitCapacityCommitmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(splitCapacityCommitmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings mergeCapacityCommitmentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mergeCapacityCommitmentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createAssignmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAssignmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listAssignmentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAssignmentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAssignmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAssignmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings searchAssignmentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchAssignmentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings searchAllAssignmentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchAllAssignmentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings moveAssignmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(moveAssignmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAssignmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAssignmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("assignment.name", String.valueOf(request.getAssignment().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getBiReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBiReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateBiReservationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateBiReservationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("bi_reservation.name", String.valueOf(request.getBiReservation().getName()));
            return builder.build();
        }).build();
        this.createReservationCallable = callableFactory.createUnaryCallable(createReservationTransportSettings, settings.createReservationSettings(), clientContext);
        this.listReservationsCallable = callableFactory.createUnaryCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.listReservationsPagedCallable = callableFactory.createPagedCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.getReservationCallable = callableFactory.createUnaryCallable(getReservationTransportSettings, settings.getReservationSettings(), clientContext);
        this.deleteReservationCallable = callableFactory.createUnaryCallable(deleteReservationTransportSettings, settings.deleteReservationSettings(), clientContext);
        this.updateReservationCallable = callableFactory.createUnaryCallable(updateReservationTransportSettings, settings.updateReservationSettings(), clientContext);
        this.createCapacityCommitmentCallable = callableFactory.createUnaryCallable(createCapacityCommitmentTransportSettings, settings.createCapacityCommitmentSettings(), clientContext);
        this.listCapacityCommitmentsCallable = callableFactory.createUnaryCallable(listCapacityCommitmentsTransportSettings, settings.listCapacityCommitmentsSettings(), clientContext);
        this.listCapacityCommitmentsPagedCallable = callableFactory.createPagedCallable(listCapacityCommitmentsTransportSettings, settings.listCapacityCommitmentsSettings(), clientContext);
        this.getCapacityCommitmentCallable = callableFactory.createUnaryCallable(getCapacityCommitmentTransportSettings, settings.getCapacityCommitmentSettings(), clientContext);
        this.deleteCapacityCommitmentCallable = callableFactory.createUnaryCallable(deleteCapacityCommitmentTransportSettings, settings.deleteCapacityCommitmentSettings(), clientContext);
        this.updateCapacityCommitmentCallable = callableFactory.createUnaryCallable(updateCapacityCommitmentTransportSettings, settings.updateCapacityCommitmentSettings(), clientContext);
        this.splitCapacityCommitmentCallable = callableFactory.createUnaryCallable(splitCapacityCommitmentTransportSettings, settings.splitCapacityCommitmentSettings(), clientContext);
        this.mergeCapacityCommitmentsCallable = callableFactory.createUnaryCallable(mergeCapacityCommitmentsTransportSettings, settings.mergeCapacityCommitmentsSettings(), clientContext);
        this.createAssignmentCallable = callableFactory.createUnaryCallable(createAssignmentTransportSettings, settings.createAssignmentSettings(), clientContext);
        this.listAssignmentsCallable = callableFactory.createUnaryCallable(listAssignmentsTransportSettings, settings.listAssignmentsSettings(), clientContext);
        this.listAssignmentsPagedCallable = callableFactory.createPagedCallable(listAssignmentsTransportSettings, settings.listAssignmentsSettings(), clientContext);
        this.deleteAssignmentCallable = callableFactory.createUnaryCallable(deleteAssignmentTransportSettings, settings.deleteAssignmentSettings(), clientContext);
        this.searchAssignmentsCallable = callableFactory.createUnaryCallable(searchAssignmentsTransportSettings, settings.searchAssignmentsSettings(), clientContext);
        this.searchAssignmentsPagedCallable = callableFactory.createPagedCallable(searchAssignmentsTransportSettings, settings.searchAssignmentsSettings(), clientContext);
        this.searchAllAssignmentsCallable = callableFactory.createUnaryCallable(searchAllAssignmentsTransportSettings, settings.searchAllAssignmentsSettings(), clientContext);
        this.searchAllAssignmentsPagedCallable = callableFactory.createPagedCallable(searchAllAssignmentsTransportSettings, settings.searchAllAssignmentsSettings(), clientContext);
        this.moveAssignmentCallable = callableFactory.createUnaryCallable(moveAssignmentTransportSettings, settings.moveAssignmentSettings(), clientContext);
        this.updateAssignmentCallable = callableFactory.createUnaryCallable(updateAssignmentTransportSettings, settings.updateAssignmentSettings(), clientContext);
        this.getBiReservationCallable = callableFactory.createUnaryCallable(getBiReservationTransportSettings, settings.getBiReservationSettings(), clientContext);
        this.updateBiReservationCallable = callableFactory.createUnaryCallable(updateBiReservationTransportSettings, settings.updateBiReservationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable() {
        return this.createReservationCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable() {
        return this.listReservationsCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ReservationServiceClient.ListReservationsPagedResponse> listReservationsPagedCallable() {
        return this.listReservationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetReservationRequest, Reservation> getReservationCallable() {
        return this.getReservationCallable;
    }

    @Override
    public UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable() {
        return this.deleteReservationCallable;
    }

    @Override
    public UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable() {
        return this.updateReservationCallable;
    }

    @Override
    public UnaryCallable<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentCallable() {
        return this.createCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsCallable() {
        return this.listCapacityCommitmentsCallable;
    }

    @Override
    public UnaryCallable<ListCapacityCommitmentsRequest, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsPagedCallable() {
        return this.listCapacityCommitmentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentCallable() {
        return this.getCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentCallable() {
        return this.deleteCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentCallable() {
        return this.updateCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentCallable() {
        return this.splitCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsCallable() {
        return this.mergeCapacityCommitmentsCallable;
    }

    @Override
    public UnaryCallable<CreateAssignmentRequest, Assignment> createAssignmentCallable() {
        return this.createAssignmentCallable;
    }

    @Override
    public UnaryCallable<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsCallable() {
        return this.listAssignmentsCallable;
    }

    @Override
    public UnaryCallable<ListAssignmentsRequest, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsPagedCallable() {
        return this.listAssignmentsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteAssignmentRequest, Empty> deleteAssignmentCallable() {
        return this.deleteAssignmentCallable;
    }

    @Override
    public UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsCallable() {
        return this.searchAssignmentsCallable;
    }

    @Override
    public UnaryCallable<SearchAssignmentsRequest, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsPagedCallable() {
        return this.searchAssignmentsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsCallable() {
        return this.searchAllAssignmentsCallable;
    }

    @Override
    public UnaryCallable<SearchAllAssignmentsRequest, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsPagedCallable() {
        return this.searchAllAssignmentsPagedCallable;
    }

    @Override
    public UnaryCallable<MoveAssignmentRequest, Assignment> moveAssignmentCallable() {
        return this.moveAssignmentCallable;
    }

    @Override
    public UnaryCallable<UpdateAssignmentRequest, Assignment> updateAssignmentCallable() {
        return this.updateAssignmentCallable;
    }

    @Override
    public UnaryCallable<GetBiReservationRequest, BiReservation> getBiReservationCallable() {
        return this.getBiReservationCallable;
    }

    @Override
    public UnaryCallable<UpdateBiReservationRequest, BiReservation> updateBiReservationCallable() {
        return this.updateBiReservationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

