/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.migration.v2.CreateMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.DeleteMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.GetMigrationSubtaskRequest;
import com.google.cloud.bigquery.migration.v2.GetMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.ListMigrationSubtasksRequest;
import com.google.cloud.bigquery.migration.v2.ListMigrationSubtasksResponse;
import com.google.cloud.bigquery.migration.v2.ListMigrationWorkflowsRequest;
import com.google.cloud.bigquery.migration.v2.ListMigrationWorkflowsResponse;
import com.google.cloud.bigquery.migration.v2.MigrationServiceClient;
import com.google.cloud.bigquery.migration.v2.MigrationSubtask;
import com.google.cloud.bigquery.migration.v2.MigrationWorkflow;
import com.google.cloud.bigquery.migration.v2.StartMigrationWorkflowRequest;
import com.google.cloud.bigquery.migration.v2.stub.GrpcMigrationServiceCallableFactory;
import com.google.cloud.bigquery.migration.v2.stub.MigrationServiceStub;
import com.google.cloud.bigquery.migration.v2.stub.MigrationServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcMigrationServiceStub
extends MigrationServiceStub {
    private static final MethodDescriptor<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/CreateMigrationWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateMigrationWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MigrationWorkflow.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/GetMigrationWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)GetMigrationWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MigrationWorkflow.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/ListMigrationWorkflows").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMigrationWorkflowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMigrationWorkflowsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/DeleteMigrationWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteMigrationWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/StartMigrationWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)StartMigrationWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/GetMigrationSubtask").setRequestMarshaller(ProtoUtils.marshaller((Message)GetMigrationSubtaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MigrationSubtask.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.migration.v2.MigrationService/ListMigrationSubtasks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMigrationSubtasksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMigrationSubtasksResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowCallable;
    private final UnaryCallable<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowCallable;
    private final UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsCallable;
    private final UnaryCallable<ListMigrationWorkflowsRequest, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsPagedCallable;
    private final UnaryCallable<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowCallable;
    private final UnaryCallable<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowCallable;
    private final UnaryCallable<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskCallable;
    private final UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksCallable;
    private final UnaryCallable<ListMigrationSubtasksRequest, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMigrationServiceStub create(MigrationServiceStubSettings settings) throws IOException {
        return new GrpcMigrationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMigrationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcMigrationServiceStub(MigrationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMigrationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMigrationServiceStub(MigrationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMigrationServiceStub(MigrationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMigrationServiceCallableFactory());
    }

    protected GrpcMigrationServiceStub(MigrationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createMigrationWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createMigrationWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getMigrationWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getMigrationWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listMigrationWorkflowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMigrationWorkflowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteMigrationWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteMigrationWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings startMigrationWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startMigrationWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getMigrationSubtaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getMigrationSubtaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listMigrationSubtasksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMigrationSubtasksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createMigrationWorkflowCallable = callableFactory.createUnaryCallable(createMigrationWorkflowTransportSettings, settings.createMigrationWorkflowSettings(), clientContext);
        this.getMigrationWorkflowCallable = callableFactory.createUnaryCallable(getMigrationWorkflowTransportSettings, settings.getMigrationWorkflowSettings(), clientContext);
        this.listMigrationWorkflowsCallable = callableFactory.createUnaryCallable(listMigrationWorkflowsTransportSettings, settings.listMigrationWorkflowsSettings(), clientContext);
        this.listMigrationWorkflowsPagedCallable = callableFactory.createPagedCallable(listMigrationWorkflowsTransportSettings, settings.listMigrationWorkflowsSettings(), clientContext);
        this.deleteMigrationWorkflowCallable = callableFactory.createUnaryCallable(deleteMigrationWorkflowTransportSettings, settings.deleteMigrationWorkflowSettings(), clientContext);
        this.startMigrationWorkflowCallable = callableFactory.createUnaryCallable(startMigrationWorkflowTransportSettings, settings.startMigrationWorkflowSettings(), clientContext);
        this.getMigrationSubtaskCallable = callableFactory.createUnaryCallable(getMigrationSubtaskTransportSettings, settings.getMigrationSubtaskSettings(), clientContext);
        this.listMigrationSubtasksCallable = callableFactory.createUnaryCallable(listMigrationSubtasksTransportSettings, settings.listMigrationSubtasksSettings(), clientContext);
        this.listMigrationSubtasksPagedCallable = callableFactory.createPagedCallable(listMigrationSubtasksTransportSettings, settings.listMigrationSubtasksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateMigrationWorkflowRequest, MigrationWorkflow> createMigrationWorkflowCallable() {
        return this.createMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<GetMigrationWorkflowRequest, MigrationWorkflow> getMigrationWorkflowCallable() {
        return this.getMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<ListMigrationWorkflowsRequest, ListMigrationWorkflowsResponse> listMigrationWorkflowsCallable() {
        return this.listMigrationWorkflowsCallable;
    }

    @Override
    public UnaryCallable<ListMigrationWorkflowsRequest, MigrationServiceClient.ListMigrationWorkflowsPagedResponse> listMigrationWorkflowsPagedCallable() {
        return this.listMigrationWorkflowsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteMigrationWorkflowRequest, Empty> deleteMigrationWorkflowCallable() {
        return this.deleteMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<StartMigrationWorkflowRequest, Empty> startMigrationWorkflowCallable() {
        return this.startMigrationWorkflowCallable;
    }

    @Override
    public UnaryCallable<GetMigrationSubtaskRequest, MigrationSubtask> getMigrationSubtaskCallable() {
        return this.getMigrationSubtaskCallable;
    }

    @Override
    public UnaryCallable<ListMigrationSubtasksRequest, ListMigrationSubtasksResponse> listMigrationSubtasksCallable() {
        return this.listMigrationSubtasksCallable;
    }

    @Override
    public UnaryCallable<ListMigrationSubtasksRequest, MigrationServiceClient.ListMigrationSubtasksPagedResponse> listMigrationSubtasksPagedCallable() {
        return this.listMigrationSubtasksPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

