/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connection.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.connection.v1beta1.ConnectionProto;
import com.google.cloud.bigquery.connection.v1beta1.stub.ConnectionServiceStub;
import com.google.cloud.bigquery.connection.v1beta1.stub.ConnectionServiceStubSettings;
import com.google.cloud.bigquery.connection.v1beta1.stub.GrpcConnectionServiceCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConnectionServiceStub
extends ConnectionServiceStub {
    private static final MethodDescriptor<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/CreateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.CreateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.Connection.getDefaultInstance())).build();
    private static final MethodDescriptor<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/GetConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.GetConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.Connection.getDefaultInstance())).build();
    private static final MethodDescriptor<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/ListConnections").setRequestMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.ListConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.ListConnectionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/UpdateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.UpdateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.Connection.getDefaultInstance())).build();
    private static final MethodDescriptor<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/UpdateConnectionCredential").setRequestMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.UpdateConnectionCredentialRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/DeleteConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)ConnectionProto.DeleteConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.connection.v1beta1.ConnectionService/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionCallable;
    private final UnaryCallable<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionCallable;
    private final UnaryCallable<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionCallable;
    private final UnaryCallable<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialCallable;
    private final UnaryCallable<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConnectionServiceStub create(ConnectionServiceStubSettings settings) throws IOException {
        return new GrpcConnectionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConnectionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConnectionServiceStub(ConnectionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConnectionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConnectionServiceStub(ConnectionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConnectionServiceStub(ConnectionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConnectionServiceCallableFactory());
    }

    protected GrpcConnectionServiceStub(ConnectionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConnectionCredentialTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConnectionCredentialMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createConnectionCallable = callableFactory.createUnaryCallable(createConnectionTransportSettings, settings.createConnectionSettings(), clientContext);
        this.getConnectionCallable = callableFactory.createUnaryCallable(getConnectionTransportSettings, settings.getConnectionSettings(), clientContext);
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.updateConnectionCallable = callableFactory.createUnaryCallable(updateConnectionTransportSettings, settings.updateConnectionSettings(), clientContext);
        this.updateConnectionCredentialCallable = callableFactory.createUnaryCallable(updateConnectionCredentialTransportSettings, settings.updateConnectionCredentialSettings(), clientContext);
        this.deleteConnectionCallable = callableFactory.createUnaryCallable(deleteConnectionTransportSettings, settings.deleteConnectionSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionCallable() {
        return this.createConnectionCallable;
    }

    @Override
    public UnaryCallable<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionCallable() {
        return this.getConnectionCallable;
    }

    @Override
    public UnaryCallable<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionCallable() {
        return this.updateConnectionCallable;
    }

    @Override
    public UnaryCallable<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialCallable() {
        return this.updateConnectionCredentialCallable;
    }

    @Override
    public UnaryCallable<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionCallable() {
        return this.deleteConnectionCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

