/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigtableColumn;
import com.google.cloud.bigquery.BigtableColumnFamily;
import java.util.List;

final class AutoValue_BigtableColumnFamily
extends BigtableColumnFamily {
    private final String familyID;
    private final List<BigtableColumn> columns;
    private final String encoding;
    private final Boolean onlyReadLatest;
    private final String type;
    private static final long serialVersionUID = 1L;

    private AutoValue_BigtableColumnFamily(String familyID, List<BigtableColumn> columns, String encoding, Boolean onlyReadLatest, String type) {
        this.familyID = familyID;
        this.columns = columns;
        this.encoding = encoding;
        this.onlyReadLatest = onlyReadLatest;
        this.type = type;
    }

    @Override
    public String getFamilyID() {
        return this.familyID;
    }

    @Override
    public List<BigtableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Boolean getOnlyReadLatest() {
        return this.onlyReadLatest;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return "BigtableColumnFamily{familyID=" + this.familyID + ", columns=" + this.columns + ", encoding=" + this.encoding + ", onlyReadLatest=" + this.onlyReadLatest + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableColumnFamily) {
            BigtableColumnFamily that = (BigtableColumnFamily)o;
            return this.familyID.equals(that.getFamilyID()) && this.columns.equals(that.getColumns()) && this.encoding.equals(that.getEncoding()) && this.onlyReadLatest.equals(that.getOnlyReadLatest()) && this.type.equals(that.getType());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.familyID.hashCode();
        h *= 1000003;
        h ^= this.columns.hashCode();
        h *= 1000003;
        h ^= this.encoding.hashCode();
        h *= 1000003;
        h ^= this.onlyReadLatest.hashCode();
        h *= 1000003;
        return h ^= this.type.hashCode();
    }

    static final class Builder
    extends BigtableColumnFamily.Builder {
        private String familyID;
        private List<BigtableColumn> columns;
        private String encoding;
        private Boolean onlyReadLatest;
        private String type;

        Builder() {
        }

        @Override
        public BigtableColumnFamily.Builder setFamilyID(String familyID) {
            if (familyID == null) {
                throw new NullPointerException("Null familyID");
            }
            this.familyID = familyID;
            return this;
        }

        @Override
        public BigtableColumnFamily.Builder setColumns(List<BigtableColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("Null columns");
            }
            this.columns = columns;
            return this;
        }

        @Override
        public BigtableColumnFamily.Builder setEncoding(String encoding) {
            if (encoding == null) {
                throw new NullPointerException("Null encoding");
            }
            this.encoding = encoding;
            return this;
        }

        @Override
        public BigtableColumnFamily.Builder setOnlyReadLatest(Boolean onlyReadLatest) {
            if (onlyReadLatest == null) {
                throw new NullPointerException("Null onlyReadLatest");
            }
            this.onlyReadLatest = onlyReadLatest;
            return this;
        }

        @Override
        public BigtableColumnFamily.Builder setType(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public BigtableColumnFamily build() {
            String missing = "";
            if (this.familyID == null) {
                missing = missing + " familyID";
            }
            if (this.columns == null) {
                missing = missing + " columns";
            }
            if (this.encoding == null) {
                missing = missing + " encoding";
            }
            if (this.onlyReadLatest == null) {
                missing = missing + " onlyReadLatest";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigtableColumnFamily(this.familyID, this.columns, this.encoding, this.onlyReadLatest, this.type);
        }
    }
}

