/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.cloud.bigquery.AutoValue_QueryParameterValue;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class QueryParameterValue
implements Serializable {
    private static final DateTimeFormatter timestampFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSZZ").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter datetimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS");
    static final Function<QueryParameterValue, com.google.api.services.bigquery.model.QueryParameterValue> TO_VALUE_PB_FUNCTION = new Function<QueryParameterValue, com.google.api.services.bigquery.model.QueryParameterValue>(){

        public com.google.api.services.bigquery.model.QueryParameterValue apply(QueryParameterValue value) {
            return value.toValuePb();
        }
    };
    private static final long serialVersionUID = -5620695863123562896L;

    QueryParameterValue() {
    }

    @Nullable
    public abstract String getValue();

    @Nullable
    public List<QueryParameterValue> getArrayValues() {
        return this.getArrayValuesInner();
    }

    @Nullable
    abstract ImmutableList<QueryParameterValue> getArrayValuesInner();

    public abstract StandardSQLTypeName getType();

    @Nullable
    public abstract StandardSQLTypeName getArrayType();

    public static <T> QueryParameterValue of(T value, Class<T> type) {
        return QueryParameterValue.of(value, QueryParameterValue.classToType(type));
    }

    public static <T> QueryParameterValue of(T value, StandardSQLTypeName type) {
        return QueryParameterValue.newBuilder().setValue(QueryParameterValue.valueToStringOrNull(value, type)).setType(type).build();
    }

    public static QueryParameterValue bool(Boolean value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BOOL);
    }

    public static QueryParameterValue int64(Long value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INT64);
    }

    public static QueryParameterValue int64(Integer value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INT64);
    }

    public static QueryParameterValue float64(Double value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.FLOAT64);
    }

    public static QueryParameterValue float64(Float value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.FLOAT64);
    }

    public static QueryParameterValue numeric(BigDecimal value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.NUMERIC);
    }

    public static QueryParameterValue string(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.STRING);
    }

    public static QueryParameterValue bytes(byte[] value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BYTES);
    }

    public static QueryParameterValue timestamp(Long value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIMESTAMP);
    }

    public static QueryParameterValue timestamp(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIMESTAMP);
    }

    public static QueryParameterValue date(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.DATE);
    }

    public static QueryParameterValue time(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIME);
    }

    public static QueryParameterValue dateTime(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.DATETIME);
    }

    public static <T> QueryParameterValue array(T[] array, Class<T> clazz) {
        return QueryParameterValue.array(array, QueryParameterValue.classToType(clazz));
    }

    public static <T> QueryParameterValue array(T[] array, StandardSQLTypeName type) {
        ArrayList<QueryParameterValue> listValues = new ArrayList<QueryParameterValue>();
        for (T obj : array) {
            listValues.add(QueryParameterValue.of(obj, type));
        }
        return QueryParameterValue.newBuilder().setArrayValues(listValues).setType(StandardSQLTypeName.ARRAY).setArrayType(type).build();
    }

    private static <T> StandardSQLTypeName classToType(Class<T> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BOOL;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.STRING;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Long.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Double.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (Float.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.NUMERIC;
        }
        throw new IllegalArgumentException("Unsupported object type for QueryParameter: " + type);
    }

    private static <T> String valueToStringOrNull(T value, StandardSQLTypeName type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case BOOL: {
                if (!(value instanceof Boolean)) break;
                return value.toString();
            }
            case INT64: {
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                return value.toString();
            }
            case FLOAT64: {
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return value.toString();
            }
            case NUMERIC: {
                if (!(value instanceof BigDecimal)) break;
                return value.toString();
            }
            case BYTES: {
                if (!(value instanceof byte[])) break;
                return BaseEncoding.base64().encode((byte[])value);
            }
            case STRING: {
                return value.toString();
            }
            case STRUCT: {
                throw new IllegalArgumentException("Cannot convert STRUCT to String value");
            }
            case ARRAY: {
                throw new IllegalArgumentException("Cannot convert ARRAY to String value");
            }
            case TIMESTAMP: {
                if (value instanceof Long) {
                    return timestampFormatter.print((Long)value / 1000L);
                }
                if (!(value instanceof String)) break;
                timestampFormatter.parseMillis((String)value);
                return (String)value;
            }
            case DATE: {
                if (!(value instanceof String)) break;
                dateFormatter.parseMillis((String)value);
                return (String)value;
            }
            case TIME: {
                if (!(value instanceof String)) break;
                timeFormatter.parseMillis((String)value);
                return (String)value;
            }
            case DATETIME: {
                if (!(value instanceof String)) break;
                datetimeFormatter.parseMillis((String)value);
                return (String)value;
            }
            default: {
                throw new UnsupportedOperationException("Implementation error - Unsupported type: " + (Object)((Object)type));
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)type) + " incompatible with " + value.getClass().getCanonicalName());
    }

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_QueryParameterValue.Builder();
    }

    com.google.api.services.bigquery.model.QueryParameterValue toValuePb() {
        com.google.api.services.bigquery.model.QueryParameterValue valuePb = new com.google.api.services.bigquery.model.QueryParameterValue();
        valuePb.setValue(this.getValue());
        if (this.getArrayValues() != null) {
            valuePb.setArrayValues(Lists.transform(this.getArrayValues(), TO_VALUE_PB_FUNCTION));
        }
        return valuePb;
    }

    QueryParameterType toTypePb() {
        QueryParameterType typePb = new QueryParameterType();
        typePb.setType(this.getType().toString());
        if (this.getArrayType() != null) {
            QueryParameterType arrayTypePb = new QueryParameterType();
            arrayTypePb.setType(this.getArrayType().toString());
            typePb.setArrayType(arrayTypePb);
        }
        return typePb;
    }

    static QueryParameterValue fromPb(com.google.api.services.bigquery.model.QueryParameterValue valuePb, QueryParameterType typePb) {
        Builder valueBuilder = QueryParameterValue.newBuilder();
        StandardSQLTypeName type = StandardSQLTypeName.valueOf(typePb.getType());
        valueBuilder.setType(type);
        if (type == StandardSQLTypeName.ARRAY) {
            valueBuilder.setArrayType(StandardSQLTypeName.valueOf(typePb.getArrayType().getType()));
            if (valuePb == null || valuePb.getArrayValues() == null) {
                valueBuilder.setArrayValues((List<QueryParameterValue>)ImmutableList.of());
            } else {
                ImmutableList.Builder arrayValues = ImmutableList.builder();
                for (com.google.api.services.bigquery.model.QueryParameterValue elementValuePb : valuePb.getArrayValues()) {
                    arrayValues.add((Object)QueryParameterValue.fromPb(elementValuePb, typePb.getArrayType()));
                }
                valueBuilder.setArrayValues((List<QueryParameterValue>)arrayValues.build());
            }
        } else {
            valueBuilder.setValue(valuePb == null ? "" : valuePb.getValue());
        }
        return valueBuilder.build();
    }

    public static abstract class Builder {
        public abstract Builder setValue(String var1);

        public Builder setArrayValues(List<QueryParameterValue> arrayValues) {
            return this.setArrayValuesInner((ImmutableList<QueryParameterValue>)ImmutableList.copyOf(arrayValues));
        }

        abstract Builder setArrayValuesInner(ImmutableList<QueryParameterValue> var1);

        public abstract Builder setType(StandardSQLTypeName var1);

        public abstract Builder setArrayType(StandardSQLTypeName var1);

        public abstract QueryParameterValue build();
    }
}

