/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.Labels;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetInfo
implements Serializable {
    static final Function<Dataset, DatasetInfo> FROM_PB_FUNCTION = new Function<Dataset, DatasetInfo>(){

        public DatasetInfo apply(Dataset pb) {
            return DatasetInfo.fromPb(pb);
        }
    };
    static final Function<DatasetInfo, Dataset> TO_PB_FUNCTION = new Function<DatasetInfo, Dataset>(){

        public Dataset apply(DatasetInfo datasetInfo) {
            return datasetInfo.toPb();
        }
    };
    private static final long serialVersionUID = 8469473744160758489L;
    private final DatasetId datasetId;
    private final List<Acl> acl;
    private final Long creationTime;
    private final Long defaultTableLifetime;
    private final String description;
    private final String etag;
    private final String friendlyName;
    private final String generatedId;
    private final Long lastModified;
    private final String location;
    private final String selfLink;
    private final Labels labels;
    private final EncryptionConfiguration defaultEncryptionConfiguration;
    private final Long defaultPartitionExpirationMs;

    DatasetInfo(BuilderImpl builder) {
        this.datasetId = (DatasetId)Preconditions.checkNotNull((Object)builder.datasetId);
        this.acl = builder.acl;
        this.creationTime = builder.creationTime;
        this.defaultTableLifetime = builder.defaultTableLifetime;
        this.description = builder.description;
        this.etag = builder.etag;
        this.friendlyName = builder.friendlyName;
        this.generatedId = builder.generatedId;
        this.lastModified = builder.lastModified;
        this.location = builder.location;
        this.selfLink = builder.selfLink;
        this.labels = builder.labels;
        this.defaultEncryptionConfiguration = builder.defaultEncryptionConfiguration;
        this.defaultPartitionExpirationMs = builder.defaultPartitionExpirationMs;
    }

    public DatasetId getDatasetId() {
        return this.datasetId;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getDefaultTableLifetime() {
        return this.defaultTableLifetime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Map<String, String> getLabels() {
        return this.labels.userMap();
    }

    public EncryptionConfiguration getDefaultEncryptionConfiguration() {
        return this.defaultEncryptionConfiguration;
    }

    public Long getDefaultPartitionExpirationMs() {
        return this.defaultPartitionExpirationMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datasetId", (Object)this.datasetId).add("creationTime", (Object)this.creationTime).add("defaultTableLifetime", (Object)this.defaultTableLifetime).add("description", (Object)this.description).add("etag", (Object)this.etag).add("friendlyName", (Object)this.friendlyName).add("generatedId", (Object)this.generatedId).add("lastModified", (Object)this.lastModified).add("location", (Object)this.location).add("selfLink", (Object)this.selfLink).add("acl", this.acl).add("labels", (Object)this.labels).add("defaultEncryptionConfiguration", (Object)this.defaultEncryptionConfiguration).add("defaultPartitionExpirationMs", (Object)this.defaultPartitionExpirationMs).toString();
    }

    public int hashCode() {
        return Objects.hash(this.datasetId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(DatasetInfo.class) && Objects.equals(this.toPb(), ((DatasetInfo)obj).toPb());
    }

    DatasetInfo setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        builder.setDatasetId(this.getDatasetId().setProjectId(projectId));
        if (this.getAcl() != null) {
            ArrayList acls = Lists.newArrayListWithCapacity((int)this.getAcl().size());
            for (Acl acl : this.getAcl()) {
                if (acl.getEntity().getType() == Acl.Entity.Type.VIEW) {
                    Dataset.Access accessPb = acl.toPb();
                    TableReference viewReferencePb = accessPb.getView();
                    if (viewReferencePb.getProjectId() == null) {
                        viewReferencePb.setProjectId(projectId);
                    }
                    acls.add(Acl.of(new Acl.View(TableId.fromPb(viewReferencePb))));
                    continue;
                }
                acls.add(acl);
            }
            builder.setAcl(acls);
        }
        return builder.build();
    }

    Dataset toPb() {
        Dataset datasetPb = new Dataset();
        datasetPb.setDatasetReference(this.datasetId.toPb());
        datasetPb.setCreationTime(this.creationTime);
        datasetPb.setDefaultTableExpirationMs(this.defaultTableLifetime);
        datasetPb.setDescription(this.description);
        datasetPb.setEtag(this.etag);
        datasetPb.setFriendlyName(this.friendlyName);
        datasetPb.setId(this.generatedId);
        datasetPb.setLastModifiedTime(this.lastModified);
        datasetPb.setLocation(this.location);
        datasetPb.setSelfLink(this.selfLink);
        if (this.acl != null) {
            datasetPb.setAccess(Lists.transform(this.acl, (Function)new Function<Acl, Dataset.Access>(){

                public Dataset.Access apply(Acl acl) {
                    return acl.toPb();
                }
            }));
        }
        datasetPb.setLabels(this.labels.toPb());
        if (this.defaultEncryptionConfiguration != null) {
            datasetPb.setDefaultEncryptionConfiguration(this.defaultEncryptionConfiguration.toPb());
        }
        if (this.defaultPartitionExpirationMs != null) {
            datasetPb.setDefaultPartitionExpirationMs(this.defaultPartitionExpirationMs);
        }
        return datasetPb;
    }

    public static Builder newBuilder(DatasetId datasetId) {
        return new BuilderImpl().setDatasetId(datasetId);
    }

    public static Builder newBuilder(String datasetId) {
        return DatasetInfo.newBuilder(DatasetId.of(datasetId));
    }

    public static Builder newBuilder(String projectId, String datasetId) {
        return DatasetInfo.newBuilder(DatasetId.of(projectId, datasetId));
    }

    public static DatasetInfo of(DatasetId datasetId) {
        return DatasetInfo.newBuilder(datasetId).build();
    }

    public static DatasetInfo of(String datasetId) {
        return DatasetInfo.newBuilder(datasetId).build();
    }

    static DatasetInfo fromPb(Dataset datasetPb) {
        return new BuilderImpl(datasetPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private DatasetId datasetId;
        private List<Acl> acl;
        private Long creationTime;
        private Long defaultTableLifetime;
        private String description;
        private String etag;
        private String friendlyName;
        private String generatedId;
        private Long lastModified;
        private String location;
        private String selfLink;
        private Labels labels = Labels.ZERO;
        private EncryptionConfiguration defaultEncryptionConfiguration;
        private Long defaultPartitionExpirationMs;

        BuilderImpl() {
        }

        BuilderImpl(DatasetInfo datasetInfo) {
            this.datasetId = datasetInfo.datasetId;
            this.acl = datasetInfo.acl;
            this.creationTime = datasetInfo.creationTime;
            this.defaultTableLifetime = datasetInfo.defaultTableLifetime;
            this.description = datasetInfo.description;
            this.etag = datasetInfo.etag;
            this.friendlyName = datasetInfo.friendlyName;
            this.generatedId = datasetInfo.generatedId;
            this.lastModified = datasetInfo.lastModified;
            this.location = datasetInfo.location;
            this.selfLink = datasetInfo.selfLink;
            this.labels = datasetInfo.labels;
            this.defaultEncryptionConfiguration = datasetInfo.defaultEncryptionConfiguration;
            this.defaultPartitionExpirationMs = datasetInfo.defaultPartitionExpirationMs;
        }

        BuilderImpl(Dataset datasetPb) {
            if (datasetPb.getDatasetReference() != null) {
                this.datasetId = DatasetId.fromPb(datasetPb.getDatasetReference());
            }
            if (datasetPb.getAccess() != null) {
                this.acl = Lists.transform((List)datasetPb.getAccess(), (Function)new Function<Dataset.Access, Acl>(){

                    public Acl apply(Dataset.Access accessPb) {
                        return Acl.fromPb(accessPb);
                    }
                });
            }
            this.creationTime = datasetPb.getCreationTime();
            this.defaultTableLifetime = datasetPb.getDefaultTableExpirationMs();
            this.description = datasetPb.getDescription();
            this.etag = datasetPb.getEtag();
            this.friendlyName = datasetPb.getFriendlyName();
            this.generatedId = datasetPb.getId();
            this.lastModified = datasetPb.getLastModifiedTime();
            this.location = datasetPb.getLocation();
            this.selfLink = datasetPb.getSelfLink();
            this.labels = Labels.fromPb(datasetPb.getLabels());
            if (datasetPb.getDefaultEncryptionConfiguration() != null) {
                this.defaultEncryptionConfiguration = new EncryptionConfiguration.Builder(datasetPb.getDefaultEncryptionConfiguration()).build();
            }
            this.defaultPartitionExpirationMs = datasetPb.getDefaultPartitionExpirationMs();
        }

        @Override
        public Builder setDatasetId(DatasetId datasetId) {
            this.datasetId = (DatasetId)Preconditions.checkNotNull((Object)datasetId);
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Builder setDefaultTableLifetime(Long defaultTableLifetime) {
            this.defaultTableLifetime = (Long)MoreObjects.firstNonNull((Object)defaultTableLifetime, (Object)Data.nullOf(Long.class));
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.friendlyName = (String)MoreObjects.firstNonNull((Object)friendlyName, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setLastModified(Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.location = (String)MoreObjects.firstNonNull((Object)location, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.labels = Labels.fromUser(labels);
            return this;
        }

        @Override
        public Builder setDefaultEncryptionConfiguration(EncryptionConfiguration defaultEncryptionConfiguration) {
            this.defaultEncryptionConfiguration = defaultEncryptionConfiguration;
            return this;
        }

        @Override
        public Builder setDefaultPartitionExpirationMs(Long defaultPartitionExpirationMs) {
            this.defaultPartitionExpirationMs = defaultPartitionExpirationMs;
            return this;
        }

        @Override
        public DatasetInfo build() {
            return new DatasetInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setDatasetId(DatasetId var1);

        public abstract Builder setAcl(List<Acl> var1);

        abstract Builder setCreationTime(Long var1);

        public abstract Builder setDefaultTableLifetime(Long var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setEtag(String var1);

        public abstract Builder setFriendlyName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setLastModified(Long var1);

        public abstract Builder setLocation(String var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setLabels(Map<String, String> var1);

        public abstract Builder setDefaultEncryptionConfiguration(EncryptionConfiguration var1);

        public abstract Builder setDefaultPartitionExpirationMs(Long var1);

        public abstract DatasetInfo build();
    }
}

