package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StandardSQLDataType extends StandardSQLDataType {

  private final String typeKind;

  private final StandardSQLDataType arrayElementType;

  private final StandardSQLStructType structType;

  private AutoValue_StandardSQLDataType(
      String typeKind,
      @Nullable StandardSQLDataType arrayElementType,
      @Nullable StandardSQLStructType structType) {
    this.typeKind = typeKind;
    this.arrayElementType = arrayElementType;
    this.structType = structType;
  }

  @Override
  public String getTypeKind() {
    return typeKind;
  }

  @Nullable
  @Override
  public StandardSQLDataType getArrayElementType() {
    return arrayElementType;
  }

  @Nullable
  @Override
  public StandardSQLStructType getStructType() {
    return structType;
  }

  @Override
  public String toString() {
    return "StandardSQLDataType{"
        + "typeKind=" + typeKind + ", "
        + "arrayElementType=" + arrayElementType + ", "
        + "structType=" + structType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StandardSQLDataType) {
      StandardSQLDataType that = (StandardSQLDataType) o;
      return this.typeKind.equals(that.getTypeKind())
          && (this.arrayElementType == null ? that.getArrayElementType() == null : this.arrayElementType.equals(that.getArrayElementType()))
          && (this.structType == null ? that.getStructType() == null : this.structType.equals(that.getStructType()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= typeKind.hashCode();
    h$ *= 1000003;
    h$ ^= (arrayElementType == null) ? 0 : arrayElementType.hashCode();
    h$ *= 1000003;
    h$ ^= (structType == null) ? 0 : structType.hashCode();
    return h$;
  }

  @Override
  public StandardSQLDataType.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StandardSQLDataType.Builder {
    private String typeKind;
    private StandardSQLDataType arrayElementType;
    private StandardSQLStructType structType;
    Builder() {
    }
    private Builder(StandardSQLDataType source) {
      this.typeKind = source.getTypeKind();
      this.arrayElementType = source.getArrayElementType();
      this.structType = source.getStructType();
    }
    @Override
    public StandardSQLDataType.Builder setTypeKind(String typeKind) {
      if (typeKind == null) {
        throw new NullPointerException("Null typeKind");
      }
      this.typeKind = typeKind;
      return this;
    }
    @Override
    public StandardSQLDataType.Builder setArrayElementType(StandardSQLDataType arrayElementType) {
      this.arrayElementType = arrayElementType;
      return this;
    }
    @Override
    public StandardSQLDataType.Builder setStructType(StandardSQLStructType structType) {
      this.structType = structType;
      return this;
    }
    @Override
    public StandardSQLDataType build() {
      String missing = "";
      if (this.typeKind == null) {
        missing += " typeKind";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StandardSQLDataType(
          this.typeKind,
          this.arrayElementType,
          this.structType);
    }
  }

}
