package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ModelTableDefinition extends ModelTableDefinition {

  private final TableDefinition.Type type;

  private final Schema schema;

  private final Long numBytes;

  private final String location;

  private AutoValue_ModelTableDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable Long numBytes,
      @Nullable String location) {
    this.type = type;
    this.schema = schema;
    this.numBytes = numBytes;
    this.location = location;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public Long getNumBytes() {
    return numBytes;
  }

  @Nullable
  @Override
  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "ModelTableDefinition{"
        + "type=" + type + ", "
        + "schema=" + schema + ", "
        + "numBytes=" + numBytes + ", "
        + "location=" + location
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ModelTableDefinition) {
      ModelTableDefinition that = (ModelTableDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.numBytes == null ? that.getNumBytes() == null : this.numBytes.equals(that.getNumBytes()))
          && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (numBytes == null) ? 0 : numBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (location == null) ? 0 : location.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 2113445776046717900L;

  @Override
  public ModelTableDefinition.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ModelTableDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private Long numBytes;
    private String location;
    Builder() {
    }
    private Builder(ModelTableDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.numBytes = source.getNumBytes();
      this.location = source.getLocation();
    }
    @Override
    public ModelTableDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ModelTableDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public ModelTableDefinition.Builder setNumBytes(Long numBytes) {
      this.numBytes = numBytes;
      return this;
    }
    @Override
    public ModelTableDefinition.Builder setLocation(String location) {
      this.location = location;
      return this;
    }
    @Override
    public ModelTableDefinition build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ModelTableDefinition(
          this.type,
          this.schema,
          this.numBytes,
          this.location);
    }
  }

}
