/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class JobStatus
implements Serializable {
    private static final long serialVersionUID = -714976456815445365L;
    private final State state;
    private final BigQueryError error;
    private final List<BigQueryError> executionErrors;

    JobStatus(State state) {
        this.state = state;
        this.error = null;
        this.executionErrors = null;
    }

    JobStatus(State state, BigQueryError error, List<BigQueryError> executionErrors) {
        this.state = state;
        this.error = error;
        this.executionErrors = executionErrors != null ? ImmutableList.copyOf(executionErrors) : null;
    }

    @Deprecated
    public State state() {
        return this.getState();
    }

    public State getState() {
        return this.state;
    }

    @Deprecated
    public BigQueryError error() {
        return this.getError();
    }

    public BigQueryError getError() {
        return this.error;
    }

    @Deprecated
    public List<BigQueryError> executionErrors() {
        return this.getExecutionErrors();
    }

    public List<BigQueryError> getExecutionErrors() {
        return this.executionErrors;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("error", (Object)this.error).add("executionErrors", this.executionErrors).toString();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.state, this.error, this.executionErrors});
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(JobStatus.class) && Objects.equals(this.toPb(), ((JobStatus)obj).toPb());
    }

    com.google.api.services.bigquery.model.JobStatus toPb() {
        com.google.api.services.bigquery.model.JobStatus statusPb = new com.google.api.services.bigquery.model.JobStatus();
        if (this.state != null) {
            statusPb.setState(this.state.toString());
        }
        if (this.error != null) {
            statusPb.setErrorResult(this.error.toPb());
        }
        if (this.executionErrors != null) {
            statusPb.setErrors(Lists.transform(this.executionErrors, BigQueryError.TO_PB_FUNCTION));
        }
        return statusPb;
    }

    static JobStatus fromPb(com.google.api.services.bigquery.model.JobStatus statusPb) {
        List allErrors = null;
        if (statusPb.getErrors() != null) {
            allErrors = Lists.transform((List)statusPb.getErrors(), BigQueryError.FROM_PB_FUNCTION);
        }
        BigQueryError error = statusPb.getErrorResult() != null ? BigQueryError.fromPb(statusPb.getErrorResult()) : null;
        return new JobStatus(State.valueOf(statusPb.getState()), error, allErrors);
    }

    public static enum State {
        PENDING,
        RUNNING,
        DONE;

    }
}

