/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public class TableInfo
implements Serializable {
    static final Function<Table, TableInfo> FROM_PB_FUNCTION = new Function<Table, TableInfo>(){

        public TableInfo apply(Table pb) {
            return TableInfo.fromPb(pb);
        }
    };
    static final Function<TableInfo, Table> TO_PB_FUNCTION = new Function<TableInfo, Table>(){

        public Table apply(TableInfo tableInfo) {
            return tableInfo.toPb();
        }
    };
    private static final long serialVersionUID = 609769795097719407L;
    private final String etag;
    private final String generatedId;
    private final String selfLink;
    private final TableId tableId;
    private final String friendlyName;
    private final String description;
    private final Long creationTime;
    private final Long expirationTime;
    private final Long lastModifiedTime;
    private final TableDefinition definition;

    TableInfo(BuilderImpl builder) {
        this.tableId = (TableId)Preconditions.checkNotNull((Object)builder.tableId);
        this.etag = builder.etag;
        this.generatedId = builder.generatedId;
        this.selfLink = builder.selfLink;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.definition = builder.definition;
    }

    public String etag() {
        return this.etag;
    }

    public String generatedId() {
        return this.generatedId;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public TableId tableId() {
        return this.tableId;
    }

    public String friendlyName() {
        return Data.isNull((Object)this.friendlyName) ? null : this.friendlyName;
    }

    public String description() {
        return Data.isNull((Object)this.description) ? null : this.description;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long expirationTime() {
        return Data.isNull((Object)this.expirationTime) ? null : this.expirationTime;
    }

    public Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public <T extends TableDefinition> T definition() {
        return (T)this.definition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", (Object)this.tableId).add("etag", (Object)this.etag).add("generatedId", (Object)this.generatedId).add("selfLink", (Object)this.selfLink).add("friendlyName", (Object)this.friendlyName).add("description", (Object)this.description).add("expirationTime", (Object)this.expirationTime).add("creationTime", (Object)this.creationTime).add("lastModifiedTime", (Object)this.lastModifiedTime).add("definition", (Object)this.definition).toString();
    }

    public int hashCode() {
        return Objects.hash(this.tableId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(TableInfo.class) && Objects.equals(this.toPb(), ((TableInfo)obj).toPb());
    }

    public static Builder builder(TableId tableId, TableDefinition definition) {
        return new BuilderImpl().tableId(tableId).definition(definition);
    }

    public static TableInfo of(TableId tableId, TableDefinition definition) {
        return TableInfo.builder(tableId, definition).build();
    }

    TableInfo setProjectId(String projectId) {
        return this.toBuilder().tableId(this.tableId().setProjectId(projectId)).build();
    }

    Table toPb() {
        Table tablePb = this.definition.toPb();
        tablePb.setTableReference(this.tableId.toPb());
        if (this.lastModifiedTime != null) {
            tablePb.setLastModifiedTime(BigInteger.valueOf(this.lastModifiedTime));
        }
        tablePb.setCreationTime(this.creationTime);
        tablePb.setDescription(this.description);
        tablePb.setEtag(this.etag);
        tablePb.setExpirationTime(this.expirationTime);
        tablePb.setFriendlyName(this.friendlyName);
        tablePb.setId(this.generatedId);
        tablePb.setSelfLink(this.selfLink);
        return tablePb;
    }

    static TableInfo fromPb(Table tablePb) {
        return new BuilderImpl(tablePb).build();
    }

    static class BuilderImpl
    extends Builder {
        private String etag;
        private String generatedId;
        private String selfLink;
        private TableId tableId;
        private String friendlyName;
        private String description;
        private Long creationTime;
        private Long expirationTime;
        private Long lastModifiedTime;
        private TableDefinition definition;

        BuilderImpl() {
        }

        BuilderImpl(TableInfo tableInfo) {
            this.etag = tableInfo.etag;
            this.generatedId = tableInfo.generatedId;
            this.selfLink = tableInfo.selfLink;
            this.tableId = tableInfo.tableId;
            this.friendlyName = tableInfo.friendlyName;
            this.description = tableInfo.description;
            this.creationTime = tableInfo.creationTime;
            this.expirationTime = tableInfo.expirationTime;
            this.lastModifiedTime = tableInfo.lastModifiedTime;
            this.definition = tableInfo.definition;
        }

        BuilderImpl(Table tablePb) {
            this.tableId = TableId.fromPb(tablePb.getTableReference());
            if (tablePb.getLastModifiedTime() != null) {
                this.lastModifiedTime(tablePb.getLastModifiedTime().longValue());
            }
            this.description = tablePb.getDescription();
            this.expirationTime = tablePb.getExpirationTime();
            this.friendlyName = tablePb.getFriendlyName();
            this.creationTime = tablePb.getCreationTime();
            this.etag = tablePb.getEtag();
            this.generatedId = tablePb.getId();
            this.selfLink = tablePb.getSelfLink();
            this.definition = TableDefinition.fromPb(tablePb);
        }

        @Override
        Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Builder description(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder expirationTime(Long expirationTime) {
            this.expirationTime = (Long)MoreObjects.firstNonNull((Object)expirationTime, (Object)Data.nullOf(Long.class));
            return this;
        }

        @Override
        public Builder friendlyName(String friendlyName) {
            this.friendlyName = (String)MoreObjects.firstNonNull((Object)friendlyName, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        Builder selfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder tableId(TableId tableId) {
            this.tableId = (TableId)Preconditions.checkNotNull((Object)tableId);
            return this;
        }

        @Override
        public Builder definition(TableDefinition definition) {
            this.definition = (TableDefinition)Preconditions.checkNotNull((Object)definition);
            return this;
        }

        @Override
        public TableInfo build() {
            return new TableInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder creationTime(Long var1);

        public abstract Builder description(String var1);

        abstract Builder etag(String var1);

        public abstract Builder expirationTime(Long var1);

        public abstract Builder friendlyName(String var1);

        abstract Builder generatedId(String var1);

        abstract Builder lastModifiedTime(Long var1);

        abstract Builder selfLink(String var1);

        public abstract Builder tableId(TableId var1);

        public abstract Builder definition(TableDefinition var1);

        public abstract TableInfo build();
    }
}

