/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.Clock;
import com.google.cloud.WaitForOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class Job
extends JobInfo {
    private static final long serialVersionUID = -4324100991693024704L;
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Job(BigQuery bigquery, JobInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.options = (BigQueryOptions)bigquery.options();
    }

    public boolean exists() {
        return this.bigquery.getJob(this.jobId(), BigQuery.JobOption.fields(new BigQuery.JobField[0])) != null;
    }

    public boolean isDone() {
        Job job = this.bigquery.getJob(this.jobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATUS));
        return job == null || job.status().state() == JobStatus.State.DONE;
    }

    public Job waitFor(WaitForOption ... waitOptions) throws InterruptedException, TimeoutException {
        WaitForOption.Timeout timeout = WaitForOption.Timeout.getOrDefault((WaitForOption[])waitOptions);
        WaitForOption.CheckingPeriod checkingPeriod = WaitForOption.CheckingPeriod.getOrDefault((WaitForOption[])waitOptions);
        long timeoutMillis = timeout.timeoutMillis();
        Clock clock = this.options.clock();
        long startTime = clock.millis();
        while (!this.isDone()) {
            if (timeoutMillis != -1L && clock.millis() - startTime >= timeoutMillis) {
                throw new TimeoutException();
            }
            checkingPeriod.sleep();
        }
        return this.reload(new BigQuery.JobOption[0]);
    }

    public Job reload(BigQuery.JobOption ... options) {
        return this.bigquery.getJob(this.jobId(), options);
    }

    public boolean cancel() {
        return this.bigquery.cancel(this.jobId());
    }

    public BigQuery bigquery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Job.class)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.service();
    }

    static Job fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Job jobPb) {
        return new Job(bigquery, new JobInfo.BuilderImpl(jobPb));
    }

    public static final class Builder
    extends JobInfo.Builder {
        private final BigQuery bigquery;
        private final JobInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, JobConfiguration configuration) {
            this.bigquery = bigquery;
            this.infoBuilder = new JobInfo.BuilderImpl();
            this.infoBuilder.configuration(configuration);
        }

        Builder(Job job) {
            this.bigquery = job.bigquery;
            this.infoBuilder = new JobInfo.BuilderImpl(job);
        }

        @Override
        Builder etag(String etag) {
            this.infoBuilder.etag(etag);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        public Builder jobId(JobId jobId) {
            this.infoBuilder.jobId(jobId);
            return this;
        }

        @Override
        Builder selfLink(String selfLink) {
            this.infoBuilder.selfLink(selfLink);
            return this;
        }

        @Override
        Builder status(JobStatus status) {
            this.infoBuilder.status(status);
            return this;
        }

        @Override
        Builder statistics(JobStatistics statistics) {
            this.infoBuilder.statistics(statistics);
            return this;
        }

        @Override
        Builder userEmail(String userEmail) {
            this.infoBuilder.userEmail(userEmail);
            return this;
        }

        @Override
        public Builder configuration(JobConfiguration configuration) {
            this.infoBuilder.configuration(configuration);
            return this;
        }

        @Override
        public Job build() {
            return new Job(this.bigquery, this.infoBuilder);
        }
    }
}

