/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public abstract class TableDefinition
implements Serializable {
    private static final long serialVersionUID = -374760330662959529L;
    private final Type type;
    private final Schema schema;

    TableDefinition(Builder builder) {
        this.type = builder.type;
        this.schema = builder.schema;
    }

    public Type getType() {
        return this.type;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public abstract Builder toBuilder();

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("schema", (Object)this.schema);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    final boolean baseEquals(TableDefinition tableDefinition) {
        return Objects.equals(this.toPb(), tableDefinition.toPb());
    }

    Table toPb() {
        Table tablePb = new Table();
        if (this.schema != null) {
            tablePb.setSchema(this.schema.toPb());
        }
        tablePb.setType(this.type.name());
        return tablePb;
    }

    static <T extends TableDefinition> T fromPb(Table tablePb) {
        switch (Type.valueOf(tablePb.getType())) {
            case TABLE: {
                return (T)StandardTableDefinition.fromPb(tablePb);
            }
            case VIEW: {
                return (T)ViewDefinition.fromPb(tablePb);
            }
            case EXTERNAL: {
                return (T)ExternalTableDefinition.fromPb(tablePb);
            }
        }
        throw new IllegalArgumentException("Format " + tablePb.getType() + " is not supported");
    }

    public static abstract class Builder<T extends TableDefinition, B extends Builder<T, B>> {
        private Type type;
        private Schema schema;

        Builder(Type type) {
            this.type = type;
        }

        Builder(TableDefinition tableDefinition) {
            this.type = tableDefinition.type;
            this.schema = tableDefinition.schema;
        }

        Builder(Table tablePb) {
            this.type = Type.valueOf(tablePb.getType());
            if (tablePb.getSchema() != null) {
                this.setSchema(Schema.fromPb(tablePb.getSchema()));
            }
        }

        B self() {
            return (B)this;
        }

        B setType(Type type) {
            this.type = type;
            return this.self();
        }

        public B setSchema(Schema schema) {
            this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
            return this.self();
        }

        public abstract T build();
    }

    public static enum Type {
        TABLE,
        VIEW,
        EXTERNAL;

    }
}

