/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.batch.v1alpha.BatchServiceClient;
import com.google.cloud.batch.v1alpha.CreateJobRequest;
import com.google.cloud.batch.v1alpha.DeleteJobRequest;
import com.google.cloud.batch.v1alpha.GetJobRequest;
import com.google.cloud.batch.v1alpha.GetTaskRequest;
import com.google.cloud.batch.v1alpha.Job;
import com.google.cloud.batch.v1alpha.ListJobsRequest;
import com.google.cloud.batch.v1alpha.ListJobsResponse;
import com.google.cloud.batch.v1alpha.ListTasksRequest;
import com.google.cloud.batch.v1alpha.ListTasksResponse;
import com.google.cloud.batch.v1alpha.OperationMetadata;
import com.google.cloud.batch.v1alpha.Task;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStubSettings;
import com.google.cloud.batch.v1alpha.stub.GrpcBatchServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcBatchServiceStub
extends BatchServiceStub {
    private static final MethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/CreateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobRequest, Operation> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTaskRequest, Task> getTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetTask").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Task.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTasksRequest, ListTasksResponse> listTasksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListTasks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTasksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTasksResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable;
    private final OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, BatchServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<GetTaskRequest, Task> getTaskCallable;
    private final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable;
    private final UnaryCallable<ListTasksRequest, BatchServiceClient.ListTasksPagedResponse> listTasksPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, BatchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBatchServiceStub create(BatchServiceStubSettings settings) throws IOException {
        return new GrpcBatchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBatchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBatchServiceStub(BatchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBatchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBatchServiceStub(BatchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBatchServiceStub(BatchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBatchServiceCallableFactory());
    }

    protected GrpcBatchServiceStub(BatchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTaskMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listTasksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTasksMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.deleteJobOperationCallable = callableFactory.createOperationCallable(deleteJobTransportSettings, settings.deleteJobOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.getTaskCallable = callableFactory.createUnaryCallable(getTaskTransportSettings, settings.getTaskSettings(), clientContext);
        this.listTasksCallable = callableFactory.createUnaryCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listTasksPagedCallable = callableFactory.createPagedCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable() {
        return this.deleteJobOperationCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, BatchServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.getTaskCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.listTasksCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, BatchServiceClient.ListTasksPagedResponse> listTasksPagedCallable() {
        return this.listTasksPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, BatchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

